; ------------------------------------------------------
; Simple Pixel Shader
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Picture.asm
                        include ..\Common_Src\Textures.asm
                        include ..\Common_Src\Shaders.asm

; ------------------------------------------------------
; Variables
                        
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

Texture1                PICTURE <>
Texture1_Id             dd      0

PShader_Id              dd      0

; Amplitude / Frequency / Time / Not used
PShader_Args            SHADER_ARG <0.05, 80.0, 0.0, 0.0>

Wave_Speed              dd      0.1

; The w param set the infinite/local type
Light_Position          real4   -2.0, 2.0, 2.0, 1.0
Light_Diffuse           real4   1.0, 1.0, 1.0, 1.0
Light_Ambient           real4   0.5, 0.5, 0.5, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Init the context (needs shader 2.0)
                        invoke  Init_Shaders_Context
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("This gfxcard doesn't handle ARB programs")
                                mov     eax, FALSE
                                ret
                        .endif

                        ; Load & assemble the shader
                        invoke  Load_Pixel_Shader, CSTR("..\..\Media\simple.psh"), addr PShader_Id
                        .if     eax == FALSE
                                invoke  Get_Shader_Error
                                invoke  Set_Error_Msg, eax
                                mov     eax, FALSE
                                ret
                        .endif                  

                        invoke  Load_PICTURE, CSTR("..\..\Media\floor.jpg"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context
                        
                        invoke  Create_2D_Texture, Texture1.Datas, Texture1._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture1_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        invoke  glEnable, GL_LIGHTING

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Texture, Texture1_Id
                        invoke  Unload_PICTURE, addr Texture1
                        invoke  Destroy_Shader, PShader_Id
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here

                        ; Move the wave
                        fld     Wave_Speed
                        fmul    FrameRate
                        fadd    PShader_Args.Arg3
                        fstp    PShader_Args.Arg3

                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glLightf, GL_LIGHT0, GL_QUADRATIC_ATTENUATION, CFLT(0.02)
                        invoke  glEnable, GL_LIGHT0

                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glBindTexture, GL_TEXTURE_2D, Texture1_Id
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR

                                ; USe this shader to render the pixels
                                invoke  Enable_Pixel_Shader, PShader_Id
                                ; Update it's parameters
                                ; (arguments are sent by group of 4 floating points)
                                invoke  Set_Pixel_Shader_Param, 0, addr PShader_Args

                                invoke  glBegin, GL_QUADS
                                        invoke  glColor3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)

                                        invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)

                                        invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)

                                        invoke  glNormal3f, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)

                                        invoke  glNormal3f, CFLT(0.0), CFLT(-1.0), CFLT(0.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0f)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0f)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0f)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0f)

                                        invoke  glNormal3f, CFLT(1.0), CFLT(0.0), CFLT(0.0)     
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)

                                        invoke  glNormal3f, CFLT(-1.0), CFLT(0.0), CFLT(0.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glEnd

                                invoke  glDisable, GL_TEXTURE_2D

                                ; Stop rendering with the shader
                                invoke  Disable_Pixel_Shader

                        invoke  glPopMatrix
                        ret
Draw                    endp

end start
