; ------------------------------------------------------
; Multi Textures
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Bmp.asm
                        include ..\Common_Src\Textures.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

Texture1                BMP     <>
Texture2                BMP     <>
Texture1_Id             dd      0
Texture2_Id             dd      0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Init_Textures_Context
                        .if     _HWMultiTex == FALSE
                                invoke  Set_Error_Msg, CSTR("Multi-texturing not supported on this hardware")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Load_BMP, CSTR("..\..\Media\masm32.bmp"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load main texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Load_BMP, CSTR("..\..\Media\lightmap.bmp"), addr Texture2, 0ffffffh
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load lightmap texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Create_2D_Texture, Texture1.Datas, Texture1._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture1_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create main texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        invoke  Create_2D_Texture,  Texture2.Datas, Texture2._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture2_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create lightmap texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Texture, Texture2_Id
                        invoke  Destroy_Texture, Texture1_Id
                        invoke  Unload_BMP, addr Texture2
                        invoke  Unload_BMP, addr Texture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                invoke  glActiveTextureARB, GL_TEXTURE0_ARB
                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glBindTexture, GL_TEXTURE_2D, Texture1_Id
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR

                                invoke  glActiveTextureARB, GL_TEXTURE1_ARB
                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glBindTexture, GL_TEXTURE_2D, Texture2_Id
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR
                                
                                invoke  glColor3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)

                                invoke  glBegin, GL_QUADS
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)

                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)

                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)

                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)

                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)

                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE0_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glMultiTexCoord2fARB, GL_TEXTURE1_ARB, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glEnd

                                invoke  glActiveTextureARB, GL_TEXTURE1_ARB
                                invoke  glDisable, GL_TEXTURE_2D

                                invoke  glActiveTextureARB, GL_TEXTURE0_ARB
                                invoke  glDisable, GL_TEXTURE_2D

                        invoke  glPopMatrix
                        ret
Draw                    endp

end start

