; ------------------------------------------------------
; Lists And Glu Primitives
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   50.0

lst_Sphere              dd      0
Quadric_Sphere          dd      0

lst_Cylinder1           dd      0
Quadric_Cylinder        dd      0
Quadric_Cyl1_Disk1      dd      0
Quadric_Cyl1_Disk2      dd      0

lst_Cone                dd      0
Quadric_Cone            dd      0
Quadric_Cone_Disk       dd      0

lst_Cylinder2           dd      0
Quadric_Cylinder1       dd      0
Quadric_Cylinder2       dd      0
Quadric_Cyl2_Disk1      dd      0
Quadric_Cyl2_Disk2      dd      0

lst_Cube                dd      0

Light_Position          real4   -1.0, 1.0, 0.5, 1.0
Light_Diffuse           real4   0.6, 0.8, 0.9, 1.0
Light_Ambient           real4   0.2, 0.5, 0.6, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Create a sphere
                        invoke  glGenLists, 1
                        mov     lst_Sphere, eax

                        invoke  glNewList, eax, GL_COMPILE
                                invoke  gluNewQuadric
                                mov     Quadric_Sphere, eax
                                ; Note: These 2 are the default values for quadric objects
                                invoke  gluQuadricDrawStyle, Quadric_Sphere, GLU_FILL
                                invoke  gluQuadricNormals, Quadric_Sphere, GLU_SMOOTH
                                
                                invoke  gluSphere, Quadric_Sphere, CDBL(0.31), 36, 36
                        invoke  glEndList

                        ; Create a cylinder
                        invoke  glGenLists, 1
                        mov     lst_Cylinder1, eax
                        
                        invoke  glNewList, eax, GL_COMPILE
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cylinder, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cylinder, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cylinder, GLU_SMOOTH
                                        invoke  gluCylinder, Quadric_Cylinder, CDBL(0.21), CDBL(0.21), CDBL(1.0), 36, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cyl1_Disk1, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cyl1_Disk1, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cyl1_Disk1, GLU_SMOOTH
                                        invoke  gluDisk, Quadric_Cyl1_Disk1, CDBL(0.0), CDBL(0.21), 36, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cyl1_Disk2, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cyl1_Disk2, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cyl1_Disk2, GLU_SMOOTH
                                        ; Reversed
                                        invoke  gluQuadricOrientation, Quadric_Cyl1_Disk2, GLU_INSIDE
                                        invoke  gluDisk, Quadric_Cyl1_Disk2, CDBL(0.0), CDBL(0.21), 36, 1
                                invoke  glPopMatrix
                        invoke  glEndList

                        ; Create a cone
                        invoke  glGenLists, 1
                        mov     lst_Cone, eax
                        
                        invoke  glNewList, eax, GL_COMPILE
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cone, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cone, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cone, GLU_SMOOTH
                                        invoke  gluCylinder, Quadric_Cone, CDBL(0.21), CDBL(0.0), CDBL(1.0), 36, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cone_Disk, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cone_Disk, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cone_Disk, GLU_SMOOTH
                                        ; Reversed
                                        invoke  gluQuadricOrientation, Quadric_Cone_Disk, GLU_INSIDE
                                        invoke  gluDisk, Quadric_Cone_Disk, CDBL(0.0), CDBL(0.21), 36, 1
                                invoke  glPopMatrix
                        invoke  glEndList

                        ; Create a cylinder with a hole
                        invoke  glGenLists, 1
                        mov     lst_Cylinder2, eax

                        invoke  glNewList, eax, GL_COMPILE
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cylinder1, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cylinder1, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cylinder1, GLU_SMOOTH
                                        invoke  gluCylinder, Quadric_Cylinder1, CDBL(0.21), CDBL(0.21), CDBL(1.0), 36, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cyl2_Disk1, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cyl2_Disk1, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cyl2_Disk1, GLU_SMOOTH
                                        invoke  gluDisk, Quadric_Cyl2_Disk1, CDBL(0.10), CDBL(0.21), 36, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cyl2_Disk2, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cyl2_Disk2, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cyl2_Disk2, GLU_SMOOTH
                                        ; Reversed
                                        invoke  gluQuadricOrientation, Quadric_Cyl2_Disk2, GLU_INSIDE
                                        invoke  gluDisk, Quadric_Cyl2_Disk2, CDBL(0.10), CDBL(0.21), 36, 1
                                invoke  glPopMatrix
                                invoke  glPushMatrix
                                        invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-0.5)
                                        invoke  gluNewQuadric
                                        mov     Quadric_Cylinder2, eax
                                        invoke  gluQuadricDrawStyle, Quadric_Cylinder2, GLU_FILL
                                        invoke  gluQuadricNormals, Quadric_Cylinder2, GLU_SMOOTH
                                        ; Reversed
                                        invoke  gluQuadricOrientation, Quadric_Cylinder2, GLU_INSIDE
                                        invoke  gluCylinder, Quadric_Cylinder2, CDBL(0.10), CDBL(0.10), CDBL(1.0), 36, 1
                                invoke  glPopMatrix
                        invoke  glEndList

                        ; Create a cube
                        invoke  glGenLists, 1
                        mov     lst_Cube, eax

                        invoke  glNewList, eax, GL_COMPILE
                                invoke  glBegin, GL_QUADS
                                        invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(-0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(-0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(-0.21),  CFLT(0.21), CFLT(0.21)
        
                                        invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(-0.21), CFLT(-0.21)
                                        invoke  glVertex3f, CFLT(-0.21),  CFLT(0.21), CFLT(-0.21)
                                        invoke  glVertex3f, CFLT(0.21),  CFLT(0.21), CFLT(-0.21)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(-0.21), CFLT(-0.21)
        
                                        invoke  glNormal3f, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-0.21),  CFLT(0.21), CFLT(-0.21)
                                        invoke  glVertex3f, CFLT(-0.21),  CFLT(0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(0.21),  CFLT(0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(0.21),  CFLT(0.21), CFLT(-0.21)
        
                                        invoke  glNormal3f, CFLT(0.0), CFLT(-1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(-0.21), CFLT(-0.21f)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(-0.21), CFLT(-0.21f)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(-0.21), CFLT(0.21f)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(-0.21), CFLT(0.21f)
        
                                        invoke  glNormal3f, CFLT(1.0), CFLT(0.0), CFLT(0.0)     
                                        invoke  glVertex3f, CFLT(0.21), CFLT(-0.21), CFLT(-0.21)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(0.21), CFLT(-0.21)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(0.21), CFLT(-0.21), CFLT(0.21)
        
                                        invoke  glNormal3f, CFLT(-1.0), CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(-0.21), CFLT(-0.21)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(-0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(0.21), CFLT(0.21)
                                        invoke  glVertex3f, CFLT(-0.21), CFLT(0.21), CFLT(-0.21)
                                invoke  glEnd
                        invoke  glEndList

                        invoke  glEnable, GL_LIGHTING

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  gluDeleteQuadric, Quadric_Sphere
                        invoke  gluDeleteQuadric, Quadric_Cylinder
                        invoke  gluDeleteQuadric, Quadric_Cyl1_Disk1
                        invoke  gluDeleteQuadric, Quadric_Cyl1_Disk2
                        invoke  gluDeleteQuadric, Quadric_Cone
                        invoke  gluDeleteQuadric, Quadric_Cone_Disk
                        invoke  gluDeleteQuadric, Quadric_Cylinder1
                        invoke  gluDeleteQuadric, Quadric_Cylinder2
                        invoke  gluDeleteQuadric, Quadric_Cyl2_Disk1
                        invoke  gluDeleteQuadric, Quadric_Cyl2_Disk2

                        invoke  glDeleteLists, lst_Sphere, 1
                        invoke  glDeleteLists, lst_Cylinder1, 1
                        invoke  glDeleteLists, lst_Cone, 1
                        invoke  glDeleteLists, lst_Cylinder2, 1
                        invoke  glDeleteLists, lst_Cube, 1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glLightf, GL_LIGHT0, GL_QUADRATIC_ATTENUATION, CFLT(0.02)
                        invoke  glEnable, GL_LIGHT0

                        invoke  glEnable, GL_DEPTH_TEST

                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-3.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                invoke  glViewport, -230, 120, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glCallList, lst_Sphere

                                invoke  glViewport, -230, -120, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glCallList, lst_Cylinder1

                                invoke  glViewport, 230, -120, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glCallList, lst_Cone

                                invoke  glViewport, 230, 120, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glCallList, lst_Cylinder2

                                invoke  glViewport, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glCallList, lst_Cube
                        invoke  glPopMatrix

                        invoke  glViewport, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT
                        ret
Draw                    endp

end start
