; ------------------------------------------------------
; Horizontal ScrollText
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

NBR_CHARS               equ     48
MAX_SIZE                equ     64                      ; Size of the textures holding the letters

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Bmp.asm
                        include ..\Common_Src\HScrollText.asm

; ------------------------------------------------------
; Variables
Texture1                BMP     <>
Texture1_Id             dd      0

Font                    BITMAP_FONT <>

Chars_Ascii             db      "abcdefghijklmnopqrstuvwxyz()-0123456789?!.,:;""' "
Chars_Pos               dd      0, 32, 64, 96, 128, 160, 192, 224, 256, 268, 300, 332, 364, 396, 428, 460, 492
                        dd      524, 556, 588, 620, 652, 684, 716, 748, 780, 812, 829, 846, 876, 906, 922, 952
                        dd      982, 1012, 1042, 1072, 1102, 1132, 1162, 1194, 1206, 1218, 1230, 1242, 1254, 1278, 1290,

Chars_Size              dd      32, 32, 32, 32, 32, 32, 32, 32, 12, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32
                        dd      32, 32, 17, 17, 30, 30, 16, 30, 30, 30, 30, 30, 30, 30, 30, 32, 12, 12, 12, 12, 12, 24, 12, 13

Text1                   db      "this is an example of horizontal scrolltext with proportional bitmap fonts made with masm32. ",0
Scroll_Struct1          HSCROLLTEXT <>
Text2                   db      "this is a second scrolltext with different speed and colors. ",0
Scroll_Struct2          HSCROLLTEXT <>
Text3                   db      "and yet another one. ",0
Scroll_Struct3          HSCROLLTEXT <>
Text4                   db      "and a last one at minimum speed. ",0
Scroll_Struct4          HSCROLLTEXT <>

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_BMP, CSTR("..\..\Media\knight_font.bmp"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context

                        mov     Font.Nbr_Chars, NBR_CHARS
                        mov     Font.Pos_Table, offset Chars_Pos
                        mov     Font.Size_Table, offset Chars_Size
                        mov     Font.Ascii_Table, offset Chars_Ascii
                        mov     Font.Orig_Width, CMEM(Texture1.Orig_Width)
                        mov     Font.Orig_Height, CMEM(Texture1.Orig_Height)
                        mov     Font.Height, CMEM(Texture1.Height)
                        mov     Font.Orig_Datas, CMEM(Texture1.Datas)
                        mov     Font.Texture_Size, MAX_SIZE                     ; Must be a standard texture size
                        mov     Font.Color_Key, 0                               ; Background color
                        invoke  Create_Bitmap_Font, addr Font
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create font")
                                mov     eax, FALSE
                                ret
                        .endif

                        lea     esi, Scroll_Struct1
                        mov     [esi + HSCROLLTEXT._Text], offset Text1
                        mov     [esi + HSCROLLTEXT.y], 250
                        mov     [esi + HSCROLLTEXT.Speed], 4
                        mov     [esi + HSCROLLTEXT.Font], offset Font
                        mov     [esi + HSCROLLTEXT.Color.r], CMEM(CFLT(1.0))
                        mov     [esi + HSCROLLTEXT.Color.g], CMEM(CFLT(1.0))
                        mov     [esi + HSCROLLTEXT.Color.b], CMEM(CFLT(1.0))
                        invoke  Create_HScrollText, esi
                        .if     eax == FALSE
Err_HScrollText:                invoke  Set_Error_Msg, CSTR("Can't create scrolltext")
                                mov     eax, FALSE
                                ret
                        .endif

                        lea     esi, Scroll_Struct2
                        mov     [esi + HSCROLLTEXT._Text], offset Text2
                        mov     [esi + HSCROLLTEXT.y], 250 + (26 * 1)
                        mov     [esi + HSCROLLTEXT.Speed], 3
                        mov     [esi + HSCROLLTEXT.Font], offset Font
                        mov     [esi + HSCROLLTEXT.Color.r], CMEM(CFLT(0.8))
                        mov     [esi + HSCROLLTEXT.Color.g], CMEM(CFLT(0.8))
                        mov     [esi + HSCROLLTEXT.Color.b], CMEM(CFLT(0.8))
                        invoke  Create_HScrollText, esi
                        test    eax, eax
                        jz      Err_HScrollText

                        lea     esi, Scroll_Struct3
                        mov     [esi + HSCROLLTEXT._Text], offset Text3
                        mov     [esi + HSCROLLTEXT.y], 250 + (26 * 2)
                        mov     [esi + HSCROLLTEXT.Speed], 2
                        mov     [esi + HSCROLLTEXT.Font], offset Font
                        mov     [esi + HSCROLLTEXT.Color.r], CMEM(CFLT(0.6))
                        mov     [esi + HSCROLLTEXT.Color.g], CMEM(CFLT(0.6))
                        mov     [esi + HSCROLLTEXT.Color.b], CMEM(CFLT(0.6))
                        invoke  Create_HScrollText, esi
                        test    eax, eax
                        jz      Err_HScrollText

                        lea     esi, Scroll_Struct4
                        mov     [esi + HSCROLLTEXT._Text], offset Text4
                        mov     [esi + HSCROLLTEXT.y], 250 + (26 * 3)
                        mov     [esi + HSCROLLTEXT.Speed], 1
                        mov     [esi + HSCROLLTEXT.Font], offset Font
                        mov     [esi + HSCROLLTEXT.Color.r], CMEM(CFLT(0.4))
                        mov     [esi + HSCROLLTEXT.Color.g], CMEM(CFLT(0.4))
                        mov     [esi + HSCROLLTEXT.Color.b], CMEM(CFLT(0.4))
                        invoke  Create_HScrollText, esi
                        test    eax, eax
                        jz      Err_HScrollText

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_HScrollText, addr Scroll_Struct1
                        invoke  Destroy_HScrollText, addr Scroll_Struct2
                        invoke  Destroy_HScrollText, addr Scroll_Struct3
                        invoke  Destroy_HScrollText, addr Scroll_Struct4

                        invoke  Destroy_Bitmap_Font, addr Font
                        invoke  Unload_BMP, addr Texture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4
                        
                        invoke  Move_HScrollText, addr Scroll_Struct1, FrameRate
                        invoke  Move_HScrollText, addr Scroll_Struct2, FrameRate
                        invoke  Move_HScrollText, addr Scroll_Struct3, FrameRate
                        invoke  Move_HScrollText, addr Scroll_Struct4, FrameRate

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  Enter_2D_Mode, INT2FLT(SCREEN_WIDTH), INT2FLT(SCREEN_HEIGHT)
                                invoke  glEnable, GL_BLEND
                                invoke  glBlendFunc, GL_DST_ALPHA, GL_ONE_MINUS_SRC_ALPHA

                                invoke  Display_HScrollText, addr Scroll_Struct1
                                invoke  Display_HScrollText, addr Scroll_Struct2
                                invoke  Display_HScrollText, addr Scroll_Struct3
                                invoke  Display_HScrollText, addr Scroll_Struct4

                                invoke  glDisable, GL_BLEND
                                
                        invoke  Leave_2d_Mode

                        ret
Draw                    endp

end start
