; ------------------------------------------------------
; Environment Mapping Texture
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Bmp.asm
                        include ..\Common_Src\Textures.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0
Texture_Front           BMP     <>
Texture_Back            BMP     <>
Texture_Left            BMP     <>
Texture_Right           BMP     <>
Texture_Top             BMP     <>
Texture_Bottom          BMP     <>

Texture_Datas           dd      6 dup (0)

Texture_Cube_Id         dd      0

lst_Sphere              dd      0
Quadric_Sphere          dd      0

; The w param set the infinite/local type
Light_Position          real4   -2.0, 2.0, 2.0, 1.0
Light_Diffuse           real4   1.0, 1.0, 1.0, 1.0
Light_Ambient           real4   0.5, 0.5, 0.5, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Note: The pictures are generated with a tool called "terragen".
                        ; (http://www.planetside.co.uk/terragen/)
                        ;
                        ; The original pictures must be flipped as follows:
                        ; Front & Back: Vertically
                        ; Top & Bottom: Horizontally
                        ; Left & Right: Vertically
                        invoke  Load_BMP, CSTR("..\..\Media\sky_front.bmp"), addr Texture_Front, -1
                        .if     eax == FALSE
Err_Texture:                    invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        invoke  Load_BMP, CSTR("..\..\Media\sky_back.bmp"), addr Texture_Back, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_left.bmp"), addr Texture_Left, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_right.bmp"), addr Texture_Right, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_top.bmp"), addr Texture_Top, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_bottom.bmp"), addr Texture_Bottom, -1
                        test    eax, eax
                        jz      Err_Texture
                        
                        ; Fill the array to pass to Create_CubeMap_Texture
                        mov     eax, Texture_Left.Datas
                        mov     Texture_Datas[0], eax
                        mov     eax, Texture_Right.Datas
                        mov     Texture_Datas[1 * 4], eax
                        mov     eax, Texture_Top.Datas
                        mov     Texture_Datas[2 * 4], eax
                        mov     eax, Texture_Bottom.Datas
                        mov     Texture_Datas[3 * 4], eax
                        mov     eax, Texture_Back.Datas
                        mov     Texture_Datas[4 * 4], eax
                        mov     eax, Texture_Front.Datas
                        mov     Texture_Datas[5 * 4], eax
                        
                        invoke  Init_Textures_Context
                        .if     _HWCubeMap == FALSE
                                invoke  Set_Error_Msg, CSTR("Cubemap textures aren't supported on this hardware")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Create_CubeMap_Texture, addr Texture_Datas, Texture_Front._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture_Cube_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        ; Create a sphere
                        invoke  glGenLists, 1
                        mov     lst_Sphere, eax

                        invoke  glNewList, eax, GL_COMPILE
                                invoke  gluNewQuadric
                                mov     Quadric_Sphere, eax
                                ; Note: These 2 are the default values for quadric objects
                                invoke  gluQuadricDrawStyle, Quadric_Sphere, GLU_FILL
                                invoke  gluQuadricNormals, Quadric_Sphere, GLU_SMOOTH
                                
                                invoke  gluSphere, Quadric_Sphere, CDBL(0.31), 64, 64
                        invoke  glEndList

                        invoke  glEnable, GL_LIGHTING

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Texture, Texture_Cube_Id

                        invoke  Unload_BMP, addr Texture_Front
                        invoke  Unload_BMP, addr Texture_Back
                        invoke  Unload_BMP, addr Texture_Left
                        invoke  Unload_BMP, addr Texture_Right
                        invoke  Unload_BMP, addr Texture_Top
                        invoke  Unload_BMP, addr Texture_Bottom

                        invoke  glDeleteLists, lst_Sphere, 1
                        invoke  gluDeleteQuadric, Quadric_Sphere

                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        
                        invoke  glEnable, GL_DEPTH_TEST

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glLightf, GL_LIGHT0, GL_QUADRATIC_ATTENUATION, CFLT(0.01)
                        invoke  glEnable, GL_LIGHT0

                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-1.2)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(0.5)

                                invoke  glEnable, GL_TEXTURE_CUBE_MAP_ARB
                                invoke  glBindTexture, GL_TEXTURE_CUBE_MAP_ARB, Texture_Cube_Id
                                
                                invoke  glEnable, GL_TEXTURE_GEN_S
                                invoke  glEnable, GL_TEXTURE_GEN_T
                                invoke  glEnable, GL_TEXTURE_GEN_R
                                invoke  glTexGeni, GL_S, GL_TEXTURE_GEN_MODE, GL_REFLECTION_MAP_ARB
                                invoke  glTexGeni, GL_T, GL_TEXTURE_GEN_MODE, GL_REFLECTION_MAP_ARB
                                invoke  glTexGeni, GL_R, GL_TEXTURE_GEN_MODE, GL_REFLECTION_MAP_ARB
                                invoke  glTexParameteri, GL_TEXTURE_CUBE_MAP_ARB, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_CUBE_MAP_ARB, GL_TEXTURE_MIN_FILTER, GL_LINEAR
                                
                                invoke  glCallList, lst_Sphere

                                invoke  glDisable, GL_TEXTURE_GEN_S
                                invoke  glDisable, GL_TEXTURE_GEN_T
                                invoke  glDisable, GL_TEXTURE_GEN_R
                                invoke  glDisable, GL_TEXTURE_CUBE_MAP_ARB
                        invoke  glPopMatrix

                        ret
Draw                    endp

end start
