; ------------------------------------------------------
; Text 2D
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Textures.asm
                        include ..\Common_Src\Fonts.asm

; ------------------------------------------------------
; Functions
Bound_Mouse             proto   :dword, :dword, :dword, :dword
Display_Cube            proto

; ------------------------------------------------------
; Variables
lFont                   dd      0

RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

szMouse_X               db      64 dup (0)
szMouse_Y               db      64 dup (0)
szMouse_Z               db      64 dup (0)
szMouse_ButtonL         db      64 dup (0)
szMouse_ButtonR         db      64 dup (0)
szMouse_ButtonM         db      64 dup (0)
My_Mouse_X              dd      0
My_Mouse_Y              dd      0
My_Mouse_Z              dd      0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Create the fonts
                        invoke  Create_Font_Bitmap, CSTR("Courier New"), 12, FW_NORMAL
                        mov     lFont, eax
                        .if     eax == 0
                                invoke  Set_Error_Msg, CSTR("Can't create font")
                                xor     eax, eax
                                ret
                        .endif
                        
                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        invoke  Destroy_Font, lFont
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        ; The DInput.asm module exports:
                        ; Mouse_X / Mouse_Y / Mouse_Z (the wheel)
                        ; Mouse_LeftButton / Mouse_RightButton / Mouse_MiddleButton
                        ; + the DInput_Clamp_Mouse function

                        invoke  DInput_Clamp_Mouse, Mouse_X, addr My_Mouse_X, 0, SCREEN_WIDTH - 1
                        invoke  DInput_Clamp_Mouse, Mouse_Y, addr My_Mouse_Y, 0, SCREEN_HEIGHT - 1
                        invoke  DInput_Clamp_Mouse, Mouse_Z, addr My_Mouse_Z, -1000, 1000
                        
                        push    My_Mouse_X
                        push    CSTR("Mouse X: %d")
                        push    offset szMouse_X
                        invoke  sprintf
                        add     esp, 3 * 4

                        push    My_Mouse_Y
                        push    CSTR("Mouse Y: %d")
                        push    offset szMouse_Y
                        invoke  sprintf
                        add     esp, 3 * 4

                        fild    My_Mouse_Z
                        fdiv    CFLT(10.0)
                        fstp    RotY

                        push    My_Mouse_Z
                        push    CSTR("Mouse Z: %d")
                        push    offset szMouse_Z
                        invoke  sprintf
                        add     esp, 3 * 4

                        movzx   eax, byte ptr Mouse_Left_Button
                        push    eax
                        push    CSTR("Left Button: %d")
                        push    offset szMouse_ButtonL
                        invoke  sprintf

                        movzx   eax, byte ptr Mouse_Right_Button
                        push    eax
                        push    CSTR("Right Button: %d")
                        push    offset szMouse_ButtonR
                        invoke  sprintf
                        add     esp, 3 * 4

                        movzx   eax, byte ptr Mouse_Middle_Button
                        push    eax
                        push    CSTR("Middle Button: %d")
                        push    offset szMouse_ButtonM
                        invoke  sprintf
                        add     esp, 3 * 4

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        local   _X:real4
                        local   _Y:real4

                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  Enter_2D_Mode, INT2FLT(SCREEN_WIDTH), INT2FLT(SCREEN_HEIGHT)
                                invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                invoke  glColor3f, CFLT(0.4), CFLT(0.8), CFLT(0.3)
                                
                                lea     ebx, szMouse_X
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(0), INT2FLT(10), lFont, ebx, eax
                                lea     ebx, szMouse_Y
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(0), INT2FLT(22), lFont, ebx, eax
                                lea     ebx, szMouse_Z
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(0), INT2FLT(34), lFont, ebx, eax
                                lea     ebx, szMouse_ButtonL
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(0), INT2FLT(46), lFont, ebx, eax
                                lea     ebx, szMouse_ButtonR
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(0), INT2FLT(58), lFont, ebx, eax
                                lea     ebx, szMouse_ButtonM
                                invoke  lstrlen, ebx
                                invoke  Display_2D_Text, INT2FLT(0), INT2FLT(70), lFont, ebx, eax
                                invoke  glPopMatrix

                        invoke  Leave_2d_Mode

                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-12.0)
                                mov     eax, My_Mouse_X
                                sub     eax, SCREEN_WIDTH / 2
                                mov     ebx, My_Mouse_Y
                                sub     ebx, SCREEN_HEIGHT / 2
                                neg     ebx
                                
                                invoke  glViewport, eax, ebx, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                invoke  Display_Cube
                        invoke  glPopMatrix

                        invoke  glViewport, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT
                        ret
Draw                    endp

; ------------------------------------------------------
; Name: Display_Cube()
; Desc: Display a simple cube
Display_Cube            proc
                        invoke  glBegin, GL_QUADS
                                invoke  glColor3f, CFLT(0.0), CFLT(0.2), CFLT(0.3)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)

                                invoke  glColor3f, CFLT(0.2), CFLT(0.4), CFLT(0.5)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f,CFLT(-1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0),CFLT(-1.0)

                                invoke  glColor3f, CFLT(0.4), CFLT(0.6), CFLT(0.7)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(-1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),CFLT(-1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(-1.0),CFLT(-1.0), CFLT(1.0)

                                invoke  glVertex3f, CFLT(1.0), CFLT(1.0),CFLT(-1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0), CFLT(1.0)
                                invoke  glVertex3f, CFLT(1.0),CFLT(-1.0),CFLT(-1.0)
                        invoke  glEnd
                        ret
Display_Cube            endp

end start
