(** An object with a file position. *)

(*
    il4c  --  Compiler for the IL4 Lisp-ahtava langauge
    Copyright (C) 2007 Jere Sanisalo

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(** (file, line, column) -position. *)
type pos = string * int * int

(** File range. *)
type range = pos * pos

(** Positioned object. *)
type 'a t = 'a * pos


(** Creates a new position. *)
let make_pos f l c =
	(f, l, c)

(** Returns the positions file. *)
let pos_file (f,l,c) =
	f

(** Returns the positions line. *)
let pos_line (f,l,c) =
	l

(** Returns the positions column. *)
let pos_col (f,l,c) =
	c

(** Returns the position as a string. *)
let pos_desc (f,l,c) =
	Printf.sprintf "'%s', line %d, col %d" f l c


(** Creates a new range. *)
let make_range p1 p2 =
	if (pos_file p1) <> (pos_file p2) then failwith "Can't make a range from positions from 2 different files.";
	(p1, p2)

(** Returns the range as a string. *)
let range_desc ((f,l1,c1), (_,l2,c2)) =
	if l1 = l2 then
		Printf.sprintf "'%s', from line %d, col %d to col %d" f l1 c1 c2
	else
		Printf.sprintf "'%s', from (line %d, col %d) to (line %d, col %d)" f l1 c1 l2 c2


(** Creates a new positioned object. *)
let make_with_pos o p =
	(o, p)

(** Creates a new positioned object. *)
let make o f l c =
	make_with_pos o (make_pos f l c)

(** Returns the object. *)
let obj (o, p) =
	o

(** Returns the position. *)
let pos (o, p) =
	p
