(** Single character reader. *)

(*
    il4c  --  Compiler for the IL4 Lisp-ahtava langauge
    Copyright (C) 2007 Jere Sanisalo

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

type t

(** Creates a new character reader. *)
val make : string -> t

(** Reads a new character. Throws End_of_file when done. *)
val read : t -> char Pos_obj.t

(** Peeks the next character. Throws End_of_file if peek fails. *)
val peek : t -> char Pos_obj.t

(** Skips the next character. Throws End_of_file when done. *)
val skip : t -> unit

(** Closes a character reader. *)
val close : t -> unit
