;--------------------------------------
; PROGRAM CLS
;
; Provides an external DOS command to clear
; the CRT screen.  Example source file for CHASM.
;
; Uses BIOS routine VIDEO_IO to scroll up 
; the screen and position the cursor.  For
; documentation of VIDEO_IO see page A-43
; of Technical Referance.
;---------------------------------------
    MOV AH,6     ;this specifys we want a scroll
                 ;the CH/CL register pair specifies the row and
                 ;column of the upper left hand corner of the region
                 ;to be scrolled
    MOV CH,0     ;row = 0
    MOV CL,0     ;column = 0
                 ;the DH/DL pair does the same for the lower
                 ;right corner.
    MOV DH,24    ;row = 24
    MOV DL,79    ;column = 79
                 ;BH specifies what color to fill with
    MOV BH,7     ;we'll use black
                 ;AL specifies how far to scroll.
    MOV AL,0     ;pattern 0 means to blank out the whole region.
    INT 16       ;call video_io
                 ;
    MOV AH,2     ;specifies that we want to position the cursor.
                 ;the DH/DL pair specifies the row and column of
                 ;where we want the cursor.
    MOV DH,0     ;row = 0
    MOV DL,0     ;column = 0
                 ;BH specifies which display page
    MOV BH,0     ;put the cursor on page 0
    INT 16       ;call video_io
                 ;
    INT 32       ;return to DOS
