/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <caosGL/core/cParser.h>
/*#define WIN32_LEAN_AND_MEAN
#include <windows.h>*/
#include <caosGL/core/dynGL.h>
#include <GL/glu.h>

#include <caosGL/gfx/cCamera.h>

using namespace caosGL::gfx;

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cCamera
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	caosGL::gfx::cBaseNode
		 *<br> implements:	<none>
		 *<br> purpose:		Implements basic 3d camera funtionality
		 *
		 */

		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::gfx::cCamera");

		/********************************************************************************************/
		cCamera::cCamera (const string & n, cGroup * f) : super (n,f) {
			init ();
		}

		/********************************************************************************************/
		cCamera::~cCamera () {
		}

		/********************************************************************************************/
		tVoid cCamera::trasform (cTransform * transpose) {
			_transpose = transpose;
		}

		/********************************************************************************************/
		const cTransform * cCamera::trasform () const {
			return _transpose;
		}

		/********************************************************************************************/
		cTransform * cCamera::trasform () {
			return _transpose;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cCamera::compile () {
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cCamera::visit (tFloat t) {
			if (!evaluateAll (t)) return false;
//				gluLookAt (_epX, _epY, _epZ, _vdX, _vdY, _vdZ, _udX, _udY, _udZ);
			glMatrixMode (GL_PROJECTION);
			glPushMatrix ();
			glLoadIdentity ();
//				cat.info ("fov: %f, as: %f, zNear: %f, zFar: %f", _fovV, _as, _zNr, _zFar);
			gluPerspective (_fovV, _as, _zNr, _zFar);
			glMatrixMode (GL_MODELVIEW);
			glPushMatrix ();
			glLoadIdentity ();
			_transpose->visitInverted (t);
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		tVoid cCamera::leave () {
			_transpose->leaveInverted ();
			glMatrixMode (GL_MODELVIEW);
			glPopMatrix ();
			glMatrixMode (GL_PROJECTION);
			glPopMatrix ();
			return;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cCamera::init () {
			#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
			#include cCamera_attribsFile
			#undef ATTRIB
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cCamera::set (const tDWord key, const string & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
				#include cCamera_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cCamera::set (const tDWord key, const tFloat & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
				#include cCamera_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cCamera::get (const tDWord key, string & value) const {
			if (super::get (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
				#include cCamera_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const vector <tAttr> * cCamera::getAttributeNames () const {
			if (attributeNames.size () == 0) {
				const vector <tAttr> * v = super::getAttributeNames ();
				attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
				#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
				#include cCamera_attribsFile
				#undef ATTRIB
			}
			return &attributeNames;
		}

		// from cBaseNode
		/********************************************************************************************/
		const string cCamera::getTypeName () const { return "caosGL::gfx::cCamera"; }
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cCameraNodeCreator : public cNodeCreator {
public:
	cCameraNodeCreator () {
		name ("caosGL::gfx::cCamera");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::gfx::cCamera (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cCameraNodeCreator> cCameraNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof