/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
//#include <some.h>

// extern includes
#include <caosGL/gfx/cBaseNode.h>
#include <caosGL/gfx/cAnimCurve.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/cRegistry.h>

using namespace caosGL::core;

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cBaseNode
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		The mother of all clases, literaly! This base node provides basic object
		 *					house keeping, has a common interface for accessing a method's attributes
		 *
		 */

		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::gfx::cBaseNode");

		/********************************************************************************************/
		cBaseNode::cBaseNode (const string & n, cGroup * f) : _name (n), _father (f) { 
			init (); 
		}

		/********************************************************************************************/
		cBaseNode::~cBaseNode () {
		}

		/********************************************************************************************/
		tVoid cBaseNode::name (const string & n) {
			_name = n;
		}

		/********************************************************************************************/
		const string & cBaseNode::name () const {
			return _name;
		}
		
		/********************************************************************************************/
		string & cBaseNode::name () {
			return _name;
		}

		/********************************************************************************************/
		void cBaseNode::father (cGroup * father) {
			_father = father;
		}

		/********************************************************************************************/
		const cGroup * cBaseNode::father () const {
			return _father;
		}

		/********************************************************************************************/
		cGroup * cBaseNode::father () {
			return _father;
		}

		/********************************************************************************************/
		void cBaseNode::addEvaluatable (cEvaluatable * evaluatable) {
			_evaluatables.insert (map <string, cEvaluatable*>::value_type (evaluatable->name (), evaluatable));
		}

		/********************************************************************************************/
		cEvaluatable * cBaseNode::getEvaluatable (const string & evaluatableName) {
			map <string, cEvaluatable *>::const_iterator it = _evaluatables.find (evaluatableName);
			if (it != _evaluatables.end ()) {
				return it->second;
			}
			return cNULL;
		}

		/********************************************************************************************/
		void cBaseNode::removeEvaluatable (const string & evaluatableName) {
			_evaluatables.erase (evaluatableName);
		}

		/********************************************************************************************/
		tBool cBaseNode::evaluateAll (tFloat t) {
			for (map <string, cEvaluatable *>::const_iterator it = _evaluatables.begin (); it != _evaluatables.end (); it++) {
				cEvaluatable * ev = it->second;
				if (t < ev->_strt) continue;
				if (t > ev->_end) continue;
				set (ev->attr (), ev->evaluate (t));
			}
			return true;
		}

		/********************************************************************************************/
		const string cBaseNode::toString () const {
			string ret = "[" + getTypeName () + ":" + name () + "##";
			const vector <tAttr> * an = getAttributeNames ();
			for (vector <tAttr>::const_iterator it = an->begin (); it != an->end () ; it++) {
				string v; get ((*it).first, v);
				ret += cParser::toString((*it).first) + ":" + v + ", ";
			}
			ret += "] [";
			for (map <string, cEvaluatable *>::const_iterator ite = _evaluatables.begin (); ite != _evaluatables.end (); ite++) {
				cEvaluatable * ev = ite->second;
				ret += ev->name () + ", ";
			}
			ret += "]";
			return ret;
		}

		/********************************************************************************************/
		const tFloat cBaseNode::start () const {
			return _strt; 
		}

		/********************************************************************************************/
		const tFloat cBaseNode::end () const {
			return _end;
		}

		/********************************************************************************************/
		const tBool cBaseNode::isAlive () const {
			return true;
		}

		/********************************************************************************************/
		tBool cBaseNode::visit (tFloat t) {
			if (t < _strt) return false;
			if (t > _end) return false;
			return true;
		}

		/********************************************************************************************/
		tBool cBaseNode::init () {
			#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
			#include cBaseNode_attribsFile
			#undef ATTRIB
			return true;
		}

		/********************************************************************************************/
		const tBool cBaseNode::set (const tDWord key, const string & value) {
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
				#include cBaseNode_attribsFile
				#undef ATTRIB
			case 'fthr': {
					cGroup * gr = dynamic_cast<cGroup*> (caosGL::core::cRegistry::getNode (value));
					if (gr) {
						if (gr == _father) {
							return false;
						}
						if (_father)
							_father->removeNode (_name);
						gr->addNode (this);
						_father = gr;
						return true;
					} else {
						return false;
					}
				break;
			}
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		/********************************************************************************************/
		const tBool cBaseNode::set (const tDWord key, const tFloat & value) {
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
				#include cBaseNode_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		/********************************************************************************************/
		const tBool cBaseNode::get (const tDWord key, string & value) const {
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
				#include cBaseNode_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		/********************************************************************************************/
		const vector <tAttr> * cBaseNode::getAttributeNames () const {
			if (attributeNames.size () == 0) {
				#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
				#include cBaseNode_attribsFile
				#undef ATTRIB
				attributeNames.push_back(make_pair('fthr',string("Relinks the father node")));
			}
			return &attributeNames;
		}

	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof