/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/gfx/cMatrix.h>
#include <caosGL/gfx/cVector.h>
#include <caosGL/gfx/cTextureSpace.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/math.h>
#include <caosGL/gfx/cState.h>
#include <gl\glu.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

#define cSnow_attribsFile <caosGL/effects/cSnow.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cSnow");

		class cFlake {
		public:
			cVector p,r,d;
		};

		/**
		 *<br> class:		cSnow
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cScene
		 *<br> implements:	<none>
		 *<br> purpose:		Ho ho ho! The snow falls, you watch. Though you can control the flow of 
		 *					the snow, even make it go up, there is one problem, the snow will keep
		 *					going up, it will not re-appear from the bottom.
		 *
		 */

		class CAOSGL_API cSnow : public cScene {
			typedef cScene super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cSnow_attribsFile
			#undef ATTRIB
			cGLTexture * _img;
			tInt _list;
			vector <cFlake> _snowFlakes;
			tFloat yHalved;
			tFloat fall;
			tFloat lastFloat;

		public:
			/********************************************************************************************/
			cSnow (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cSnow () {
			}

			/********************************************************************************************/
			tFloat ran (tFloat range) const {
				return (static_cast <tFloat> (rand ())/0x7fff)*range;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool draw (const tFloat time) {
				fall = (time-lastFloat)*_falR;
//				cat.info ("ejem: %f, %f, %f", fall, lastFloat, time);
				lastFloat = time;
//				cat.info ("ejem: %f, %f, %f", _rotX, _rotY, _rotZ);
				glMatrixMode(GL_PROJECTION);
				glPushMatrix ();
				glLoadIdentity();

				gluPerspective (45.0,1.3,1,100.0);
				glTranslatef (0, 0, -_sizZ);
				glMatrixMode(GL_MODELVIEW);
				glPushMatrix ();

				_img->prepare ();
				glDepthMask (0);
				cState::disable (cState::oGL_DEPTH_TEST);
				cState::disable (cState::oGL_LIGHTING);
				cState::enable (cState::oGL_TEXTURE_2D);
				cState::enable (cState::oGL_BLEND);
				glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
				glColor4f (1,1,1,1);
				for (vector <cFlake>::iterator it = _snowFlakes.begin(); it != _snowFlakes.end(); it++) {
					glLoadIdentity ();
					glRotatef (_rotX, 1,  0,  0);
					glRotatef (_rotY, 0,  1,  0);
					glRotatef (_rotZ, 0,  0,  1);
					glTranslatef (it->p.x, it->p.y, it->p.z);
					glRotatef (it->r.x,  1,  0,  0);
					glRotatef (it->r.y,  0,  1,  0);
					glRotatef (it->r.z,  0,  0,  1);
					glCallList (_list);
					it->p.y -= fall;
					if (it->p.y<-yHalved)
						it->p.y += _sizY;
					it->r += it->d;
				}
				glDepthMask (1);
				glPopMatrix ();
				glMatrixMode(GL_PROJECTION);
				glPopMatrix ();
				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool transparent () const {
				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tVoid transparent (const tBool trasnp) {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				_img = cTextureSpace::instance ()->get (_tex);
				srand ((unsigned) _ranS);
				yHalved = _sizY /2;
				for (tInt i = _num ; i-->0;) {
					// sit them just above the box.
					cFlake f;
					f.p.set (ran(_sizX)-_sizX/2, ran(_sizY)+_sizY/2, ran(_sizZ)-_sizZ/2);
					f.d.set (ran(3)-1.5,ran(3)-1.5,ran(3)-1.5);
					f.r.set (0,0,0);
					_snowFlakes.push_back (f);
				}
				if (glIsList (_list))
					glDeleteLists (_list, 1);
				_list = glGenLists (1);
				glNewList (_list, GL_COMPILE_AND_EXECUTE); {
					glBegin (GL_QUADS); {
						glTexCoord2f (0.0f, 0.0f); glVertex3f (-0.1,  0.1,  0.0);
						glTexCoord2f (1.0f, 0.0f); glVertex3f ( 0.1,  0.1,  0.0);
						glTexCoord2f (1.0f, 1.0f); glVertex3f ( 0.1, -0.1,  0.0);
						glTexCoord2f (0.0f, 1.0f); glVertex3f (-0.1, -0.1,  0.0);
					} glEnd ();
				} glEndList ();
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				if (!cBaseNode::visit (t)) 
					return false;
				evaluateAll (t);
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cSnow_attribsFile
				#undef ATTRIB
				lastFloat = _strt;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cSnow_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cSnow_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cSnow_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cSnow_attribsFile
					#undef ATTRIB
				}
				return &attributeNames;
			}

			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cSnow"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cSnowNodeCreator : public cNodeCreator {
public:
	cSnowNodeCreator () {
		name ("caosGL::effects::cSnow");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cSnow (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cSnowNodeCreator> cSnowNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof
