/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/gfx/cTextureSpace.h>
#include <caosGL/gfx/cSceneGraph.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cGLTexture.h>
#include <caosGL/gfx/cState.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

#define cCubeDrawer_attribsFile <caosGL/effects/cCubeDrawer.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cCubeDrawer");

		/**
		 *<br> class:		cCubeDrawer
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cScene
		 *<br> implements:	<none>
		 *<br> purpose:		Draws cubes.
		 *
		 */

		class CAOSGL_API cCubeDrawer : public cScene {
			typedef cScene super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cCubeDrawer_attribsFile
			#undef ATTRIB
			cGLTexture * img;
			string _fileName;
			tInt _list;

		public:
			/********************************************************************************************/
			cCubeDrawer (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cCubeDrawer () {
			}

			// from iDrawable
			/********************************************************************************************/
			tBool draw (const tFloat time) {
				if (!img)
					return false;
				img->prepare ();
				if (_list == -1) {
					_list = glGenLists (1);
					glNewList (_list, GL_COMPILE_AND_EXECUTE);
						glEnable (GL_BLEND);
						glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
						glBegin (GL_QUADS);
							glColor4ub (255, 255, 255, 128);
							glTexCoord2f (0.0f, 0.0f); glVertex3f ( 1.0f, -1.0f,  1.0f);
							glTexCoord2f (1.0f, 0.0f); glVertex3f (-1.0f, -1.0f,  1.0f);
							glTexCoord2f (1.0f, 1.0f); glVertex3f (-1.0f,  1.0f,  1.0f);
							glTexCoord2f (0.0f, 1.0f); glVertex3f ( 1.0f,  1.0f,  1.0f);
		
							glTexCoord2f (0.0f, 0.0f); glVertex3f ( 1.0f, -1.0f, -1.0f);
							glTexCoord2f (1.0f, 0.0f); glVertex3f (-1.0f, -1.0f, -1.0f);
							glTexCoord2f (1.0f, 1.0f); glVertex3f (-1.0f,  1.0f, -1.0f);
							glTexCoord2f (0.0f, 1.0f); glVertex3f ( 1.0f,  1.0f, -1.0f);

							glTexCoord2f (0.0f, 0.0f); glVertex3f ( 1.0f, -1.0f,  1.0f);
							glTexCoord2f (1.0f, 0.0f); glVertex3f ( 1.0f, -1.0f, -1.0f);
							glTexCoord2f (1.0f, 1.0f); glVertex3f ( 1.0f,  1.0f, -1.0f);
							glTexCoord2f (0.0f, 1.0f); glVertex3f ( 1.0f,  1.0f,  1.0f);

							glTexCoord2f (0.0f, 0.0f); glVertex3f (-1.0f, -1.0f,  1.0f);
							glTexCoord2f (1.0f, 0.0f); glVertex3f (-1.0f, -1.0f, -1.0f);
							glTexCoord2f (1.0f, 1.0f); glVertex3f (-1.0f,  1.0f, -1.0f);
							glTexCoord2f (0.0f, 1.0f); glVertex3f (-1.0f,  1.0f,  1.0f);

							glTexCoord2f (0.0f, 0.0f); glVertex3f (-1.0f,  1.0f,  1.0f);
							glTexCoord2f (1.0f, 0.0f); glVertex3f (-1.0f,  1.0f, -1.0f);
							glTexCoord2f (1.0f, 1.0f); glVertex3f ( 1.0f,  1.0f, -1.0f);
							glTexCoord2f (0.0f, 1.0f); glVertex3f ( 1.0f,  1.0f,  1.0f);

							glTexCoord2f (0.0f, 0.0f); glVertex3f (-1.0f, -1.0f,  1.0f);
							glTexCoord2f (1.0f, 0.0f); glVertex3f (-1.0f, -1.0f, -1.0f);
							glTexCoord2f (1.0f, 1.0f); glVertex3f ( 1.0f, -1.0f, -1.0f);
							glTexCoord2f (0.0f, 1.0f); glVertex3f ( 1.0f, -1.0f,  1.0f);
						glEnd ();
					glEndList ();
				}

				glCallList (_list);

				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool transparent () const {
				return false;
			}

			// from iDrawable
			/********************************************************************************************/
			tVoid transparent (const tBool trasnp) {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				cAbsWindow * window = cOpenGLWindow::instance ();
				img = cTextureSpace::instance ()->get (_fileName);
				if (!img)
					return false;

				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				if (!cBaseNode::visit (t)) return false;
				evaluateAll (t);
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cCubeDrawer_attribsFile
				#undef ATTRIB
				_list = -1;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cCubeDrawer_attribsFile
					#undef ATTRIB
				case 'tex': {
					_fileName = value;
					compile ();
				} return true;
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cCubeDrawer_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cCubeDrawer_attribsFile
					#undef ATTRIB
				case 'tex': {
					value = _fileName;
				} return true;
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cCubeDrawer_attribsFile
					#undef ATTRIB
					attributeNames.push_back(make_pair('tex',string("Texture to use")));
				}
				return &attributeNames;
			}

			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cCubeDrawer"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cCubeDrawerNodeCreator : public cNodeCreator {
public:
	cCubeDrawerNodeCreator () {
		name ("caosGL::effects::cCubeDrawer");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cCubeDrawer (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cCubeDrawerNodeCreator> cCubeDrawerNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof