/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
//#include <some.h>

// extern includes
#include <caosGL/core/cSystem.h>
#include <caosGL/core/cZipFile.h>
#include <strstream>
#include <iostream>
#include <fstream>
#include <string>
using namespace std;

#include <caosGL/core/cVFS.h>

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cVFS
		 *<br> namespace:	caosGL::io
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		uniform access to a file. I tries to find it in the 
		 *				registered .caos, and after falls through to the
		 *				real file system.
		 *
		 */

	    static log4cpp::Category& cat = log4cpp::Category::getInstance ("sys.cVFS");
		static map <string, cZipFile*> cfs;
		cVFS::~cVFS () {}

		/********************************************************************************************/
		istream * cVFS::getStreamHard (const string name, const eMode mode) {
			return new ifstream (name.c_str (), ios_base::in|(mode==cVFS::eBin?ios_base::binary:0));
		}

		/********************************************************************************************/
		istream * cVFS::getStream (const string name, const eMode mode) {
			if (name == "") {
				return getStream ("badbadbadbadbadbad");
			}
			istream * f = getStreamHard (name, mode);

			if (f->good ()) {
				cat.info ("Reading \"%s\" from a hard file", name.c_str ());
				return f;
			} else {
				for (map <string, cZipFile*>::iterator it = cfs.begin (); it != cfs.end (); it++) {
					cZipFile * zf = it->second;
					for (tInt i = zf->GetNumFiles (); i-->0;) {
						if (zf->GetFilename (i) == name) {
							tInt length = zf->GetFileLen (i);
							tChar *pData = new tChar [length];
							if (caosGL::core::RET_OK == zf->ReadFile (i, pData)) {
								cat.info ("Reading %s from cfs file %s", name.c_str (), it->first.c_str ());
								return new strstream (pData, length);
							} else {
								delete [] pData;
								cat.error ("Error trying to read the file \"%s\" from the zip file.", name.c_str ());
							}
						}
					}
				}
				cat.warn ("I sincerly think that I did not find the file \"%s\", sorry!", name.c_str ());
			}

			return f;
		}
		
		/********************************************************************************************/
		tBool cVFS::registerCaos (const string name) {
			cZipFile * zf = new cZipFile ();
			if (caosGL::core::RET_OK != zf->Init(instance ()->getStream (name))) {
				cat.warn ("Could not register cfs file \"%s\"!", name.c_str ());
				return false;
			}

			cat.info ("Registered cfs file \"%s\"", name.c_str ());

			cfs.insert (map <string, cZipFile*>::value_type (name, zf));

			return true;
		}

		/********************************************************************************************/
		tBool cVFS::closeStream (const istream * stream) {

			return false;
		}

		/********************************************************************************************/
		tBool cVFS::read (tDWord & v, istream * i) {
			i->read ((tChar*)&v, sizeof(v));
			if (i->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool cVFS::read (tInt & v, istream * i) {
			i->read ((tChar*)&v, sizeof(v));
			if (i->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool cVFS::read (tFloat & v, istream * i) {
			i->read ((tChar*)&v, sizeof(v));
			if (i->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool cVFS::read (tBool & v, istream * i) {
			i->read ((tChar*)&v, sizeof(v));
			if (i->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool cVFS::read (tVoid * b, tDWord l, istream * i) {
			i->read ((tChar*)b, l);
			if (i->good()) return true;
			return false;
		}


		// singleton managment.
		cVFS * cVFS::_instance = cNULL;
		/********************************************************************************************/
		cVFS::cVFS () {
		}

		/********************************************************************************************/
		cVFS * cVFS::instance () {
			if (_instance == cNULL) {
				_instance = new cVFS ();
			}
			return _instance;
		}
	}
}


/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof