/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <stdarg.h>

#include <caosGL/core/cUtil.h>

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cUtil
		 *<br> namespace:	caosGL::util
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		
		 *
		 */

		/********************************************************************************************/
		tDWord cUtil::doFli (const string & s) {
			switch (s.size()) {
			case 0: return 0;
			case 1: return (s[0]);
			case 2: return (s[0]<<8 ) | (s[1]    );
			case 3: return (s[0]<<16) | (s[1]<<8 ) | (s[2]   );
			case 4: return (s[0]<<24) | (s[1]<<16) | (s[2]<<8) | (s[3]);
			default:return (s[0]<<24) | (s[1]<<16) | (s[2]<<8) | (s[3]);
			}			
		}

		/********************************************************************************************/
		tDWord cUtil::doFli (const tChar * s) {
			switch (strlen(s)) {
			case 0: return 0;
			case 1: return (s[0]);
			case 2: return (s[0]<<8 ) | (s[1]    );
			case 3: return (s[0]<<16) | (s[1]<<8 ) | (s[2]   );
			case 4: return (s[0]<<24) | (s[1]<<16) | (s[2]<<8) | (s[3]);
			default:return (s[0]<<24) | (s[1]<<16) | (s[2]<<8) | (s[3]);
			}			
		}

		/********************************************************************************************/
		string cUtil::doFli (const tDWord v) {			
			tChar s [5];
			s [0] = (v    ) & 0xff;
			s [1] = (v>>8 ) & 0xff;
			s [2] = (v>>16) & 0xff;
			s [3] = (v>>24) & 0xff;
			s [4] = '\0';
			return s;
		}

		/********************************************************************************************/
		string cUtil::tabs (const tInt tabCount) {
			string t;
			for (tInt i = tabCount ; i-->0;)
				t.append("    ");
			return t;
		}

		/********************************************************************************************/
		tVoid cUtil::printAll (log4cpp::Category & cat, const log4cpp::Priority::Value & priority, const string & what) {
			tInt pos0 = 0;
			tInt pos1 = what.find_first_of (';', pos0+1);
			while (pos1 != string::npos) {
				pos1++;
				cat.log (priority, what.substr(pos0,pos1-pos0));
				pos0 = pos1;
				pos1 = what.find_first_of (';', pos0+1);
			}
		}

		/********************************************************************************************/
		tVoid cUtil::printAll (log4cpp::Category & cat, const log4cpp::Priority::Value & priority, const char * stringFormat, ...) {
			tChar buf[3000];
			va_list va;
			va_start(va, stringFormat);
			vsprintf(buf, stringFormat, va);
			va_end(va);

			string what (buf);

			tInt pos0 = 0;
			tInt pos1 = what.find_first_of (';', pos0+1);
			while (pos1 != string::npos) {
				pos1++;
				cat.log (priority, what.substr(pos0,pos1-pos0));
				pos0 = pos1;
				pos1 = what.find_first_of (';', pos0+1);
			}
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof