/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <windows.h>
#include <iostream>

#include <caosGL/core/cTimer.h>

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cTimer
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		a general purpose high-resolution timer
		 *
		 */

	    static log4cpp::Category& cat = log4cpp::Category::getInstance ("sys.cTimer");
		/********************************************************************************************/
		cTimer::cTimer () { // 1193182
		    QueryPerformanceFrequency((LARGE_INTEGER*)&_freq);
			_delta = 0;
		}

		/********************************************************************************************/
		cTimer::~cTimer () {
		}

		/********************************************************************************************/
		tVoid cTimer::set (tFloat t) {
		    QueryPerformanceCounter((LARGE_INTEGER*)&_start);
			QueryPerformanceCounter((LARGE_INTEGER*)&_now);
			_delta = ((tFloat) t * _freq);
		}

		/********************************************************************************************/
		tVoid cTimer::start () {
		    QueryPerformanceCounter((LARGE_INTEGER*)&_start);
			_running = true;
		}

		/********************************************************************************************/
		tVoid cTimer::resume () {
			tLong other;
		    QueryPerformanceCounter((LARGE_INTEGER*)&other);
			_start = other - _now + _start;
			_running = true;
		}

		/********************************************************************************************/
		tVoid cTimer::stop () {
			QueryPerformanceCounter((LARGE_INTEGER*)&_now);
			_running = false;
		}

		/********************************************************************************************/
		const tFloat cTimer::elapsed () const {
			if (_running) {
				tLong now;
				QueryPerformanceCounter((LARGE_INTEGER*)&now);
				return ((tFloat) (now - _start + _delta)) / (tFloat) _freq;
			} else {
				return ((tFloat) (_now - _start + _delta)) / (tFloat) _freq;
			}
		}

		/********************************************************************************************/
		const tLong cTimer::frequency () const {
			return _freq;
		}

		/********************************************************************************************/
		const tFloat cTimer::resolution () const {
			return (tFloat) (1.0 / (tFloat) _freq);
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof