/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes

#include <caosGL/core/cArea.h>

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cArea
		 *<br> namespace:	caosGL::code
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		an area
		 *
		 */

		/********************************************************************************************/
		cArea::cArea (const tInt l, const tInt t, const tInt r, const tInt b) {
			_left = l;
			_top = t;
			_right = r;
			_bottom = b;
		}

		/********************************************************************************************/
		cArea::cArea (const cArea &area) {
			_left = area._left;
			_top = area._top;
			_right = area._right;
			_bottom = area._bottom;
		}

		/********************************************************************************************/
		cArea& cArea::operator = (const cArea &area) {
			_left = area._left;
			_top = area._top;
			_right = area._right;
			_bottom = area._bottom;
			return *this;
		}

		/********************************************************************************************/
		cArea::cArea () {
			_left = _top = _right = _bottom = 0;
		}

		/********************************************************************************************/
		cArea::~cArea () {}

		/********************************************************************************************/
		tVoid cArea::clip (const cArea & area) {
			if (_right > area._right)
				_right = area._right;
			if (_bottom > area._bottom)
				_bottom = area._bottom;
		}

		/********************************************************************************************/
		tVoid cArea::area (const tInt l, const tInt t, const tInt r, const tInt b) {
			_left = l;
			_top = t;
			_right = r;
			_bottom = b;
		}

		/********************************************************************************************/
		tVoid cArea::area (const cArea & area) {
			_left = area._left;
			_top = area._top;
			_right = area._right;
			_bottom = area._bottom;
		}

		/********************************************************************************************/
		tInt cArea::left () const {return _left;}

		/********************************************************************************************/
		tVoid cArea::left (const tInt l) {_left = l;}

		/********************************************************************************************/
		tInt cArea::top () const {return _top;}

		/********************************************************************************************/
		tVoid cArea::top (const tInt t) {_top = t;}

		/********************************************************************************************/
		tInt cArea::right () const {return _right;}

		/********************************************************************************************/
		tVoid cArea::right (const tInt r) {_right = r;}

		/********************************************************************************************/
		tInt cArea::bottom () const {return _bottom;}

		/********************************************************************************************/
		tVoid cArea::bottom (const tInt b) {_bottom = b;}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof