/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

#ifndef CAOSGL_GFX_CSTATE
#define CAOSGL_GFX_CSTATE

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes

namespace caosGL { 
	namespace gfx {
		/**
		 *<br> class:		cState
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		encapsulates openGL state changes
		 *
		 */

		class cStateSet;
		class CAOSGL_API cState {
		public:
			enum eState {
				// enable / disable
				oGL_ALPHA_TEST              	= 0,
				oGL_AUTO_NORMAL   				= 2,
				oGL_BLEND         				= 4,
				oGL_CLIP_PLANE0   				= 6,
				oGL_CLIP_PLANE1   				= 8,
				oGL_CLIP_PLANE2   				= 10,
				oGL_CLIP_PLANE3   				= 12,
				oGL_CLIP_PLANE4   				= 14,
				oGL_CLIP_PLANE5   				= 16,
				oGL_COLOR_MATERIAL				= 18,
				oGL_CULL_FACE     				= 20,
				oGL_DEPTH_TEST    				= 22,
				oGL_DITHER        				= 24,
				oGL_FOG							= 26,
				oGL_LIGHT0						= 28,
				oGL_LIGHT1						= 30,
				oGL_LIGHT2						= 32,
				oGL_LIGHT3						= 34,
				oGL_LIGHT4						= 36,
				oGL_LIGHT5						= 38,
				oGL_LIGHT6						= 40,
				oGL_LIGHT7						= 42,
				oGL_LIGHTING					= 44,
				oGL_LINE_SMOOTH					= 46,
				oGL_LINE_STIPPLE				= 48,
				oGL_LOGIC_OP					= 50,
				oGL_MAP1_COLOR_4				= 52,
				oGL_MAP1_INDEX					= 54,
				oGL_MAP1_NORMAL					= 56,
				oGL_MAP1_TEXTURE_COORD_1		= 58,
				oGL_MAP1_TEXTURE_COORD_2		= 60,
				oGL_MAP1_TEXTURE_COORD_3		= 62,
				oGL_MAP1_TEXTURE_COORD_4		= 64,
				oGL_MAP1_VERTEX_3				= 66,
				oGL_MAP1_VERTEX_4				= 68,
				oGL_MAP2_COLOR_4				= 70,
				oGL_MAP2_INDEX					= 72,
				oGL_MAP2_NORMAL					= 74,
				oGL_MAP2_TEXTURE_COORD_1		= 76,
				oGL_MAP2_TEXTURE_COORD_2		= 78,
				oGL_MAP2_TEXTURE_COORD_3		= 80,
				oGL_MAP2_TEXTURE_COORD_4		= 82,
				oGL_MAP2_VERTEX_3				= 84,
				oGL_MAP2_VERTEX_4				= 86,
				oGL_NORMALIZE					= 88,
				oGL_POINT_SMOOTH				= 90,
				oGL_POLYGON_SMOOTH				= 92,
				oGL_POLYGON_STIPPLE				= 94,
				oGL_SCISSOR_TEST				= 96,
				oGL_STENCIL_TEST				= 98,
				oGL_TEXTURE_1D					= 100,
				oGL_TEXTURE_2D					= 102,
				oGL_TEXTURE_GEN_Q				= 104,
				oGL_TEXTURE_GEN_R				= 106,
				oGL_TEXTURE_GEN_S				= 108,
				oGL_TEXTURE_GEN_T				= 110,
				oGL_LAST                    	= 112,
				// misc stuff		
			};	
			static tVoid apply (cStateSet & state);
			static cStateSet & getState ();
			static tVoid enable (eState state);
			static tVoid disable (eState state);
			static tBool isEnabled (eState state);
			static tVoid value (tBool & value);
			static tVoid value (tFloat & value);
			static tVoid value (tDWord & value);
	
		public:	
			static tVoid init ();	
	
		private:	
			static cStateSet stateSet;
		};
	}
}

#endif // CAOSGL_GFX_CSTATE

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof
