/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

#ifndef CAOSGL_GFX_CGROUP
#define CAOSGL_GFX_CGROUP

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cBaseNode.h>

#define cGroup_attribsFile <caosGL/gfx/cGroup.attribs>

namespace caosGL { 
	namespace gfx {
		/**
		 *<br> class:		cGroup
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	caosGL::gfx::cBaseNode
		 *<br> implements:	<none>
		 *<br> purpose:		The base node for grouping other objects. Two main clases extend this one
		 *					cTransform and cLayer.
		 *
		 */

		class CAOSGL_API cGroup : public cBaseNode {
			typedef cBaseNode super;
		public:
			cGroup (const string & n, cGroup * f);
			virtual ~cGroup ();

			virtual tBool addNode (cBaseNode * node);
			virtual tBool removeNode (const string & nodeName);

			virtual const cBaseNode * getNode (const string & nodeName) const;
			virtual const tNodeList * getNodes () const;

			virtual tVoid clear ();
			
			virtual tVoid printTree () const;

			// from cBaseNode
			virtual tBool compile  ();
			virtual tBool visit (tFloat t) = 0;
			virtual tVoid leave () = 0;
			virtual tBool init ();
			virtual const bool set (const tDWord key, const string & value);
			virtual const bool set (const tDWord key, const tFloat & value);
			virtual const bool get (const tDWord key, string & value) const;
			virtual const vector <tAttr> * getAttributeNames () const;
			virtual const string getTypeName () const = 0;
		protected:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cGroup_attribsFile
			#undef ATTRIB
		private:
			tNodeList _nodeList;
			virtual tVoid printTree (const tNodeList * nodeList, tInt tabCount) const;
		};
	}
}

#endif // CAOSGL_GFX_CGROUP

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof