/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

/**
 *<br> class:		c3DEngine
 *<br> namespace:	caosGL::gfx::threeD
 *<br> inherits:	caosGL::gfx::cBaseNode
 *<br> implements:	<none>
 *<br> purpose:		
 *
 */

#ifndef CAOSGL_GFX_C3DENGINE
#define CAOSGL_GFX_C3DENGINE

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cBaseNode.h>
#include <caosGL/gfx/iDrawable.h>
#include <caosGL/gfx/cCamera.h>
#include <caosGL/gfx/cLight.h>

// extern includes

#define c3DEngine_attribsFile <caosGL/gfx/c3DEngine.attribs>

using namespace caosGL::gfx;

namespace caosGL { 
	namespace gfx {
		/**
		 *<br> class:		c3DEngine
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	caosGL::gfx::cBaseNode
		 *<br> implements:	<none>
		 *<br> purpose:		Implements the functionality of a 3d engine. Basically, this engine sucks 
		 *                  big time. This is how it "works":
		 *<br>              - it constructs the scene as a tree.
		 *<br>              - at scene compile time, it extracts the cameras and lights, along with
		 *                    with their transform nodes.
		 *<br>              - at draw time, it first activates de camera, then the lights, and then 
		 *                    does 2 passes of the scene, first drawing the opaque objects, then
		 *                    the transparent ones.
		 *<br>              See? I told you it sucked!
		 *
		 */

		class CAOSGL_API c3DEngine : public cBaseNode, public iDrawable {
			typedef cBaseNode super;
		public:
			c3DEngine (const string & n, cGroup * f);
			virtual ~c3DEngine ();

			virtual tVoid setScene (cGroup * rN);

			// from iDrawable
			virtual tBool draw (const tFloat time);
			virtual tBool transparent () const;
			virtual tVoid transparent (const tBool trasnp);

			// from cBaseNode
			virtual tBool compile  ();
			virtual tBool visit (tFloat t);
			virtual tVoid leave ();
			virtual tBool init ();
			virtual const bool set (const tDWord key, const string & value);
			virtual const bool set (const tDWord key, const tFloat & value);
			virtual const bool get (const tDWord key, string & value) const;
			virtual const vector <tAttr> * getAttributeNames () const;
			virtual const string getTypeName () const;
			
		protected:
			tVoid loadCaos (const string & name);
			tBool compile (const tNodeList * nodeList);
			tBool traverse (tBool transparent);
			tBool traverse (const tNodeList * nodeList, tBool transparent, tFloat t);
			tBool findCameras ();
			tBool findCameras (const tNodeList * nodeList);
			tBool findLights ();
			tBool findLights (const tNodeList * nodeList);

			// attibutes..
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include c3DEngine_attribsFile
			#undef ATTRIB
			string file;
			cGroup * rootNode;
			map <string, cCamera *> cameras;
			vector <cLight *> lights;
			cCamera * camera;
			string cameraName;
			tBool _lighted;
		};
	}
}

#endif // CAOSGL_GFX_C3DENGINE

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof