//#define DEBUG 2   //for debug all change this and rebuild project

#ifndef AROS_MACHINE_H
#define AROS_MACHINE_H
#define _AMIGA
/*
     Copyright  1995-2001, The AROS Development Team. All rights reserved.
     $Id: machine.h,v 1.19 2005/10/110 18:04:46 bergers Exp $

     NOTE: This file must compile *without* any other header !

     Desc: machine.h include file for Aros/m68k for AmigaOS (AFA OS)
     Lang: english
*/
#define LC_LIBDEFS_FILE "libdefs_68k_afa.h"
/*above is necessary because aros is not build with the buildsystem under linux
  for every aros lib you want use you need this file in the current dir of AROS libsource 
  a default for this file for 68k layerslib and UAE look like this
  for other libs modify it
*/

 
/* 
#ifndef _LAYERS_LIBDEFS_H
#define _LAYERS_LIBDEFS_H

#define GM_UNIQUENAME(n) Layers_ ## n
#define LIBBASE          LayersBase
#define LIBBASETYPE      struct LayersBase
#define LIBBASETYPEPTR   struct LayersBase *
#define MOD_NAME_STRING  "layers.library"
#define VERSION_NUMBER   41
#define MAJOR_VERSION    41
#define REVISION_NUMBER  0
#define MINOR_VERSION    0
#define VERSION_STRING   "$VER: layers.library 41.0 (10.10.2005) \r\n"
#define COPYRIGHT_STRING ""
#define LIBEND           GM_UNIQUENAME(End)
#define LIBFUNCTABLE     GM_UNIQUENAME(FuncTable)
#define RESIDENTPRI      60
#define RESIDENTFLAGS    RTF_AUTOINIT|RTF_COLDSTART
#include "layers_intern.h"
#define GM_SYSBASE_FIELD(lh) (((LIBBASETYPEPTR)lh)->lb_SysBase)
#define GM_SEGLIST_FIELD(lh) (((LIBBASETYPEPTR)lh)->lb_SegList)


#endif * _LAYERS_LIBDEFS_H *

*/
#define EnableSetFunction 1 
/* Information generated by machine.c */
#define AROS_STACK_GROWS_DOWNWARDS 1 /* Stack direction */
#define AROS_BIG_ENDIAN            1 /* Big or little endian */
#define AROS_SIZEOFULONG           4 /* Size of an ULONG */
#define AROS_WORDALIGN             2 /* Alignment for WORD */
#define AROS_LONGALIGN             2 /* Alignment for LONG */
#define AROS_PTRALIGN              2 /* Alignment for PTR */
#define AROS_IPTRALIGN             2 /* Alignment for IPTR */
#define AROS_DOUBLEALIGN           2 /* Alignment for double */
#define AROS_WORSTALIGN            8 /* Worst case alignment */

#define AROS_GET_SYSBASE        extern struct ExecBase * SysBase;

/*
     How much do I have to add to sp to get the address of the first
     byte on the stack?
*/
#define SP_OFFSET 0

/*
     BCPL datatypes
*/
#define AROS_BPTR_TYPE  unsigned long
#define AROS_BSTR_TYPE  unsigned long
#define MKBADDR(a)	(((LONG)(a)) >> 2)
#define BADDR(a)	((APTR)((ULONG)(a) << 2))

#define __stackparm

#define ADD2INITLIB(a,b)
#define ADD2EXPUNGELIB(a,b) 

// is used  to set a AROS function to a amiga OS function
// example: SETFUNC(OpenDiskFont,Diskfont,DiskfontBase);
#define SETFUNC(a,b,c) extern APTR AROS_SLIB_ENTRY(a,b); \
offs=SetFunction(c,LVO ## a,&AROS_SLIB_ENTRY(a,b));

//the next defines tell aros not use the AROS protos.
//because AROS dos library have for locks and filehandles same funcs
//so AROS protos contain this:
//define Unlock Close
//define ExamineFh Examine
//which crash on all non AROS doslibs      
#define DEFINES_DOS_PROTOS_H

//next is need to make AROS binarycompatible to amigaos.
//node struct is diffrent by default on AROS
//to avoid overwritten this values from config.h using config.h is disabled
#define AROS_CONFIG_H 
 

#define AROS_FLAVOUR_NATIVE		1
#define AROS_FLAVOUR_STANDALONE		2
#define AROS_FLAVOUR_EMULATION		4
#define AROS_FLAVOUR_LINKLIB		8
#define AROS_FLAVOUR_BINCOMPAT		16 
#define AROS_FLAVOUR  (AROS_FLAVOUR_STANDALONE |  AROS_FLAVOUR_BINCOMPAT)
//unused defines from config.h are put to machine.h
//maybe they are need later...  
#define AROS_DEFAULT_WBWIDTH		800
#define AROS_DEFAULT_WBHEIGHT		600
#define AROS_DEFAULT_WBDEPTH		8

#define AROS_BOCHS_HACK			0
#define AROS_SERIAL_DEBUG		0

#define AROS_PALM_DEBUG_HACK	    	0

#define AROS_NESTING_SUPERVISOR     	0

#define AROS_MUNGWALL_DEBUG 	    	0
#define AROS_STACK_DEBUG    	    	0
#define AROS_MODULES_DEBUG		0
#define USE_XSHM	    	    	1
#define USE_VIDMODE			1

#define ENABLE_DBUS			0

// some usefull macros for post mortem asm debugging 
#define TRAP __asm__("trap #0"); 
#define ILLEGAL __asm__("illegal"); 





//#ifndef LC_LIBHEADERTYPEPTR
//#   define LC_LIBHEADERTYPEPTR	       struct LibHeader *
//#endif
//#ifndef LC_LIB_FIELD
//#   define LC_LIB_FIELD(libBase)       (libBase)->lh_LibNode
//#endif
//#ifndef LC_SYSBASE_FIELD
//#   define LC_SYSBASE_FIELD(libBase)   (libBase)->lh_SysBase
//#endif
//#ifndef LC_SEGLIST_FIELD
//#   define LC_SEGLIST_FIELD(libBase)   (libBase)->lh_SegList
//#endif
//#ifndef LC_RESIDENTNAME
//#   define LC_RESIDENTNAME     LC_BUILDNAME(ROMTag)
//#endif
//#ifndef LC_RESIDENTPRI
//#   define LC_RESIDENTPRI      0
//#endif
//#ifndef LC_RESIDENTFLAGS
//#   define LC_RESIDENTFLAGS    RTF_AUTOINIT
//#endif
//#ifndef LC_LIBBASESIZE
//#   define LC_LIBBASESIZE  sizeof (struct LibHeader)
//#endif 
// new end
 
/* Macros to test/set failure of AllocEntry() */
#define AROS_ALLOCENTRY_FAILED(memType) \
        ((struct MemList *)((IPTR)(memType) | 0x80ul<<(sizeof(APTR)-1)*8))
#define AROS_CHECK_ALLOCENTRY(memList) \
        (!((IPTR)(memList) & 0x80ul<<(sizeof(APTR)-1)*8))

/*
     One entry in a libraries' jumptable. For assembler compatibility, the
     field jmp should contain the code for an absolute jmp to a 32bit
     address. There are also a couple of macros which you should use to
     access the vector table from C.
*/
struct JumpVec
{
     unsigned short jmp;
     unsigned char vec[4];
};

/* Any jump to an unimplemented vector will cause an access to this address */
#define _aros_empty_vector              0xc0edbabe

/* Internal macros */
#define __AROS_ASMJMP                   0x4EF9
#define __AROS_SET_VEC(v,a)             (*(ULONG*)(v)->vec=(ULONG)(a))
#define __AROS_GET_VEC(v)               ((APTR)(*(ULONG*)(v)->vec))

/* Use these to acces a vector table */
#ifndef LIB_VECTSIZE
#define LIB_VECTSIZE                  (sizeof (struct JumpVec))
#endif

#define __AROS_GETJUMPVEC(lib,n)        ((struct JumpVec *)(((UBYTE *)lib)-(n*LIB_VECTSIZE)))
#define __AROS_GETVECADDR(lib,n)        (__AROS_GET_VEC(__AROS_GETJUMPVEC(lib,n)))
#define __AROS_SETVECADDR(lib,n,addr)   (__AROS_SET_VEC(__AROS_GETJUMPVEC(lib,n),(APTR)(addr)))
#define __AROS_INITVEC(lib,n)           __AROS_GETJUMPVEC(lib,n)->jmp = __AROS_ASMJMP, \
                                        __AROS_SETVECADDR(lib,n,_aros_empty_vector)

/*
     Find the next valid alignment for a structure if the next x bytes must
     be skipped.
*/
#define AROS_ALIGN(x)        (((x)+AROS_WORSTALIGN-1)&-AROS_WORSTALIGN)

/* Prototypes */
extern void _aros_not_implemented (char *);

/* How much stack do we need ? Lots :-) */
#define AROS_STACKSIZE  100000

/* The registers */
#define D0 "d0"
#define D1 "d1"
#define D2 "d2"
#define D3 "d3"
#define D4 "d4"
#define D5 "d5"
#define D6 "d6"
#define D7 "d7"
#define A0 "a0"
#define A1 "a1"
#define A2 "a2"
#define A3 "a3"
#define A4 "a4"
#define A5 "a5"
#define A6 "a6"

#ifndef __SASC
#define __d0 __asm("d0")
#define __d1 __asm("d1")
#define __d2 __asm("d2")
#define __d3 __asm("d3")
#define __d4 __asm("d4")
#define __d5 __asm("d5")
#define __d6 __asm("d6")
#define __d7 __asm("d7")

#define __a0 __asm("a0")
#define __a1 __asm("a1")
#define __a2 __asm("a2")
#define __a3 __asm("a3")
#define __a4 __asm("a4")
#define __a5 __asm("a5")
#define __a6 __asm("a6")
#endif

/* RawDoFmt hook */
#define RDFCALL(hook,data,dptr) ((void(*)(UBYTE __d0,APTR __a3))(hook))(data,dptr);

/* What to do with the library base in header, prototype and call */
#define __AROS_LH_BASE(basetype,basename)   register basetype basename __asm("a6")
#define __AROS_LP_BASE(basetype,basename)   register void * __asm("a6")
#define __AROS_LC_BASE(basetype,basename)   basename
#define __AROS_LD_BASE(basetype,basename)   register basetype __asm("a6")

/* How to transform an argument in header, prototype and call */
#define __AROS_LHA(type,name,reg)     register type name __asm(reg)
#define __AROS_LPA(type,name,reg)     register type __asm(reg)
#define __AROS_LCA(type,name,reg)     name
#define __AROS_LDA(type,name,reg)     register type __asm(reg)
#define __AROS_UFHA(type,name,reg)    register type name __asm(reg)
#define __AROS_UFPA(type,name,reg)    register type __asm(reg)
#define __AROS_UFCA(type,name,reg)    name
#define __AROS_UFDA(type,name,reg)    register type __asm(reg)

/* Prefix for library function in header, prototype and call */
#define __AROS_LH_PREFIX    /* eps */
#define __AROS_LP_PREFIX    /* eps */
#define __AROS_LC_PREFIX    /* eps */
#define __AROS_LD_PREFIX    /* eps */
#define __AROS_UFH_PREFIX   /* eps */
#define __AROS_UFP_PREFIX   /* eps */
#define __AROS_UFC_PREFIX   /* eps */
#define __AROS_UFD_PREFIX   /* eps */

/* if this is defined, all AROS_LP*-macros will expand to nothing. */

#define __AROS_USE_MACROS_FOR_LIBCALL

//below are some macros AROS use.If you dont use AROS includes activate it
//recommend is use amiga includes but hyperlayers use some aros struxt entry
//so using amigaos includes is not test.i use AROS includes for diskfont.library
//and hyperlayers.library 

//typedef unsigned long IPTR;


//#define NEWLIST(_l)                              \
//do                                               \
//{                                                \
//     struct List *l = (struct List *)(_l);        \
//                                                  \
//     l->lh_TailPred = (struct Node *)l;           \
//     l->lh_Tail     = 0;                          \
//     l->lh_Head     = (struct Node *)&l->lh_Tail; \
//} while (0)
//
//#define ADDHEAD(_l,_n)                                \
//do                                                    \
//{                                                     \
//     struct Node *n = (struct Node *)(_n);             \
//     struct List *l = (struct List *)(_l);             \
//                                                       \
//     n->ln_Succ          = l->lh_Head;                 \
//     n->ln_Pred          = (struct Node *)&l->lh_Head; \
//     l->lh_Head->ln_Pred = n;                          \
//     l->lh_Head          = n;                          \
//} while (0)
//
//#define ADDTAIL(_l,_n)                                    \
//do                                                        \
//{                                                         \
//     struct Node *n = (struct Node *)(_n);                 \
//     struct List *l = (struct List *)(_l);                 \
//                                                           \
//     n->ln_Succ              = (struct Node *)&l->lh_Tail; \
//     n->ln_Pred              = l->lh_TailPred;             \
//     l->lh_TailPred->ln_Succ = n;                          \
//     l->lh_TailPred          = n;                          \
//} while (0)
//
//#define REMOVE(_n)                        \
//do                                        \
//{                                         \
//     struct Node *n = (struct Node *)(_n); \
//                                           \
//     n->ln_Pred->ln_Succ = n->ln_Succ;     \
//     n->ln_Succ->ln_Pred = n->ln_Pred;     \
//} while (0)
//
//#ifdef __GNUC__
//#   define GetHead(_l)                                       \
//     ({                                                       \
//         struct List *l = (struct List *)(_l);                \
//                                                              \
//         l->lh_Head->ln_Succ ? l->lh_Head : (struct Node *)0; \
//     })
//
//#   define GetTail(_l)                                               \
//     ({                                                               \
//         struct List *l = (struct List *)(_l);                        \
//                                                                      \
//         l->lh_TailPred->ln_Pred ? l->lh_TailPred : (struct Node *)0; \
//     })
//
//#   define GetSucc(_n)                                       \
//     ({                                                       \
//         struct Node *n = (struct Node *)(_n);                \
//                                                              \
//         n->ln_Succ->ln_Succ ? n->ln_Succ : (struct Node *)0; \
//     })
//
//#   define GetPred(_n)                                       \
//     ({                                                       \
//         struct Node *n = (struct Node *)(_n);                \
//                                                          \
//         n->ln_Pred->ln_Pred ? n->ln_Pred : (struct Node *)0; \
//     })
//
//#else
//
//#   define GetHead(l) 
//        \
//     ( 
//         \
//         ((struct List *)(l))->lh_Head->ln_Succ ? ((struct List *)l)->lh_Head : (struct 
//Node *)0; \
//     )
//
//#   define GetTail(l) 
//                  \
//     ( 
//                   \
//         ((struct List *)(l))->lh_TailPred->ln_Pred ? ((struct List *)(l))->lh_TailPred : 
//(struct Node *)0; \
//     )
//
//#   define GetSucc(n) 
//      \
//     ( 
//       \
//         ((struct Node *)n)->ln_Succ->ln_Succ ? ((struct Node *)n)->ln_Succ : (struct Node 
//*)0; \
//     }
//
//#   define GetPred(n) 
//      \
//     ( 
//       \
//         ((struct Node *)n)->ln_Pred->ln_Pred ? ((struct Node *)n)->ln_Pred : (struct Node 
//*)0; \
//     }
//#endif
//
//#define REMTAIL(_l)                       \
//({                                        \
//     struct List *l = (struct List *)_l;   \
//     struct Node *n;                       \
//     if ((n=GetTail(l)))                   \
//     {                                     \
//         n->ln_Pred->ln_Succ = n->ln_Succ; \
//         n->ln_Succ->ln_Pred = n->ln_Pred; \
//     }                                     \
//     n;                                    \
//})
//
//
//#define ForeachNode(l,n)                       \
//for                                            \
//(                                              \
//     n=(void *)(((struct List *)(l))->lh_Head); \
//     ((struct Node *)(n))->ln_Succ;             \
//     n=(void *)(((struct Node *)(n))->ln_Succ)  \
//)
//
//#define ForeachNodeSafe(l,n,n2)                 \
//for                                             \
//(                                               \
//     n=(void *)(((struct List *)(l))->lh_Head);  \
//     (n2=(void *)((struct Node *)(n))->ln_Succ); \
//     n=(void *)n2                                \
//)
//
//#define SetNodeName(node,name)   \
//     (((struct Node *)(node))->ln_Name = (char *)(name))
//#define GetNodeName(node)        \
//     (((struct Node *)(node))->ln_Name)
//
//#define ListLength(list,count)     \
//do {                               \
//     struct Node * n;              \
//     count = 0;                    \
//     ForeachNode (list,n) count ++; \
//} while (0)
//
//
//
#endif /* AROS_MACHINE_H */
//



