@rem Command Line Options are -dontrun -dontbuild -debug -aros

@set StartAddress=$20000
@set UsePacker=1




@set launcher=runa500

@echo off
@set _oldpath=%cd%
cd /d %~dp0
call ..\toolchain\setpaths.bat

@set debug=0
@set dontrun=0
@set dontbuild=0

:ParseCommandLine
@if "%1" equ "" goto ParseCommandLineEnd
@if "%1" equ "-debug" set debug=1
@if "%1" equ "-debug" goto ParameterParsed
@if "%1" equ "-dontrun" set dontrun=1
@if "%1" equ "-dontrun" goto ParameterParsed
@if "%1" equ "-dontbuild" set dontbuild=1
@if "%1" equ "-dontbuild" goto ParameterParsed
@if "%1" equ "-aros" set launcher=runaros
@if "%1" equ "-aros" goto ParameterParsed

@echo Error: Unknown bat file parameter %1
@goto failed
:parameterParsed
@shift /1
@goto ParseCommandLine
:ParseCommandLineEnd

set DebugExt=
if %debug% NEQ 0 set DebugExt=_d
set OutDir=out%DebugExt%

@if %dontbuild% equ 1 goto dontBuild

if not exist %OutDir% md %OutDir%
if errorlevel 1 goto failed
del %OutDir%\* /s /q >NUL
if errorlevel 1 goto failed



echo.
echo BUILDING MAIN BOOTBLOCK

shallow -i ExampleBootblock.s -d
shallow -i UnpackBootblockWrapper.s -d
set ExtraParms=-pic 
if %usePacker% EQU 1 set ExtraParms=-DStartAddress=%StartAddress%

vasmm68k_mot_win32 -m68000 -spaces -Fbin -x -o %OutDir%\bb.bin ExampleBootblock.s -DUsePacker=%UsePacker% -DDebug=%Debug% %ExtraParms% -quiet
if errorlevel 1 goto failed
if not exist %OutDir%\bb.bin goto failed

if %usePacker% EQU 0 goto NoPacker
echo.
echo PACKING BOOTBLOCK
packfire %OutDir%\bb.bin %OutDir%\bbpacked.bin -b -t >nul
if errorlevel 1 goto failed
if not exist %OutDir%\bbpacked.bin goto failed

echo BUILDING UNPACKER BOOTBLOCK
del %OutDir%\bb.bin
vasmm68k_mot_win32 -m68000 -spaces -Fbin -pic -x -o %OutDir%\bb.bin UnpackBootBlockWrapper.s -DDebug=%Debug% -DStartAddress=%StartAddress% -quiet
if errorlevel 1 goto failed
if not exist %OutDir%\bb.bin goto failed

:NoPacker

echo.
CopyToAdf.exe emptydisk %OutDir%\bb%DebugExt%.adf -new
if errorlevel 1 goto failed
CopyToAdf.exe %OutDir%\bb.bin %OutDir%\bb%DebugExt%.adf -bootblock
if errorlevel 1 goto failed

:dontBuild
if %dontrun% equ 1 goto DontRun
if not exist %~dp0%OutDir%\bb%DebugExt%.adf goto failed
call ..\%launcher% %~dp0%OutDir%\bb%DebugExt%.adf
if errorlevel 1 goto failed
:DontRun

echo SUCCESS
cd /d %_oldpath%
exit /b 0

:failed
echo FAILED
cd /d %_oldpath%
exit /b 1
