@set oldpath=%cd%
@cd /d "%~dp0"

@if '%1' equ '' goto failed
@if '%2' equ '' goto failed
@if not exist dh0\c\assign goto FailedMissingCAndLibs
@if not exist dh0\c\makedir goto FailedMissingCAndLibs
@if not exist dh0\c\copy goto FailedMissingCAndLibs
@if not exist dh0\c\execute goto FailedMissingCAndLibs
@if not exist dh0\libs\datatypes.library goto FailedMissingCAndLibs
@if not exist dh0\libs\lowlevel.library goto FailedMissingCAndLibs

@if not exist dh0\t md dh0\t
@set InputFolder=%~dp1
@set InputFileName=%~nx1
@set "FileNameWithoutModPrefix=%InputFileName:*.=%"
@set P61Mode=TwoFiles_Delta
@if "%3" neq "" set P61Mode=%3
@rem if a file doesn't start with "mod." then
@if /i %inputfilename% NEQ mod.%FileNameWithoutModPrefix% set FileNameWithoutModPrefix=%InputFileName%
@set OutputFolder=%2
@set PrefixForSmpFile=smp
@rem It's simpler to just copy the mod-file twice than not copy anything for onefile
@if /i "%P61Mode:~0,3%" EQU "One" set PrefixForSmpFile=p61

@if '%InputFolder%' equ '' (
	echo Error: input path was incorrect. 
	goto Failed
)
@if '%FileNameWithoutModPrefix%' equ '' (
	echo Error: input path was incorrect. Must be full path to an existing mod file.
	goto Failed
)

@if '%OutputFolder%' equ '' (
	echo Error: No output folder given.
	goto Failed
)

@if not exist dh0\p61con\%P61Mode%.P61Aprefs (
	echo illegal P61 conversion mode %p61mode%.
	Goto Failed
)

@if not exist dh0\t md dh0\t
@if not exist dh0\t\p61cache md dh0\t\p61cache
@if not exist %InputFolder%%InputFileName%  (
	echo File %InputFolder%%InputFileName% not found
	goto Failed
)

@if not exist dh0\t\p61cache\%P61Mode%.%InputFileName% goto NoCacheMatch
@if not exist dh0\t\p61cache\p61.%P61Mode%.%FileNameWithoutModPrefix% goto NoCacheMatch
@if not exist dh0\t\p61cache\usecode.p61.%P61Mode%.%FileNameWithoutModPrefix% goto NoCacheMatch
@if not exist dh0\t\p61cache\%PrefixForSmpFile%.%P61Mode%.%FileNameWithoutModPrefix% goto NoCacheMatch
@fc /b %InputFolder%%InputFileName% dh0\t\p61cache\%P61Mode%.%InputFileName% >NUL
@if errorlevel 1 goto NoCacheMatch
@echo P61Cache Match Found for %InputFileName%
@goto P61CacheMatch
:NoCacheMatch
@echo Converting %InputFileName% to P61
@copy dh0\p61con\%P61Mode%.P61Aprefs dh0\s\p61a.prefs >NUL
@if exist "dh0\t\done.p61.%P61Mode%.%FileNameWithoutModPrefix%" rd dh0\t\done.p61.%P61Mode%.%FileNameWithoutModPrefix%
@if exist "dh0\t\p61cache\p61.%P61Mode%.%FileNameWithoutModPrefix%" del dh0\t\p61cache\p61.%P61Mode%.%FileNameWithoutModPrefix%
@if exist "dh0\t\p61cache\usecode.p61.%P61Mode%.%FileNameWithoutModPrefix%" del dh0\t\p61cache\usecode.p61.%P61Mode%.%FileNameWithoutModPrefix%
@if exist "dh0\t\p61cache\%PrefixForSmpFile%.%P61Mode%.%FileNameWithoutModPrefix%" del dh0\t\p61cache\%PrefixForSmpFile%.%P61Mode%.%FileNameWithoutModPrefix%

@copy %InputFolder%%InputFileName% dh0\t\p61cache\%P61Mode%.%InputFileName% /y >NUL

@echo /|set /p =assign ENV: RAM:>"dh0\t\p61startscripit.batch
@copy /b dh0\t\p61startscripit.batch +toolchain\AmigaCarriageReturn.bin dh0\t\p61startscripit.batch >NUL
@echo /|set /p =cd dh0:p61con>>"dh0\t\p61startscripit.batch
@copy /b dh0\t\p61startscripit.batch +toolchain\AmigaCarriageReturn.bin dh0\t\p61startscripit.batch >NUL
@echo /|set /p =dh0:tools/scripit/scripit -v scripitp61con %P61Mode%.%InputFileName% P61.%P61Mode%.%FileNameWithoutModPrefix%>>"dh0\t\p61startscripit.batch
@call toolchain\startwinuae.bat a4000_60 KICK31 "execute dh0:t/p61startscripit.batch"
@if errorlevel 1 goto FailedWinUAELaunch

@Echo Waiting for WinUAE to finish converting p61.%FileNameWithoutModPrefix%
:Waiting
@PING 127.0.0.1 -n 2 >NUL
@if not exist "dh0\t\done.p61.%P61Mode%.%FileNameWithoutModPrefix%" goto Waiting
@rd dh0\t\done.p61.%P61Mode%.%FileNameWithoutModPrefix%
@echo Done Converting p61.%FileNameWithoutModPrefix%

:P61CacheMatch
@copy dh0\t\p61cache\p61.%P61Mode%.%FileNameWithoutModPrefix% %OutputFolder%\p61.%FileNameWithoutModPrefix%  >NUL
@if NOT EXIST %OutputFolder%\p61.%FileNameWithoutModPrefix% goto Failed
@copy dh0\t\p61cache\usecode.p61.%P61Mode%.%FileNameWithoutModPrefix% %OutputFolder%\usecode.%FileNameWithoutModPrefix%.i  >NUL
@if NOT EXIST %OutputFolder%\usecode.%FileNameWithoutModPrefix%.i goto Failed
@copy dh0\t\p61cache\%PrefixForSmpFile%.%P61Mode%.%FileNameWithoutModPrefix% %OutputFolder%\%PrefixForSmpFile%.%FileNameWithoutModPrefix%  >NUL
@if NOT EXIST %OutputFolder%\%PrefixForSmpFile%.%FileNameWithoutModPrefix% goto Failed

@cd /d %oldpath%
@goto Success

:Failed
@echo Usage: ConvertModToP61 InputPath  OutputFolder [Conversion Mode]
@echo input path and output folder must be relative to the root path, or absolute
@echo Valid conversion modes are:
@for /f %%f in ('dir /b dh0\p61con\*.p61aprefs') do @echo %%~nf
@goto FailedNoError
:FailedMissingCAndLibs
@echo Failed to convert %1 because you don't have the dh0\C and dh0\Libs folders copied over from the workbench 3.1 disk
:FailedWinUAELaunch
:FailedNoError
@cd /d %oldpath%
@exit /b 1
:Success
@exit /b 0
