;
; *** Listing 11-9 ***
;
; Counts the number of times the letter 'A'
; appears in a byte-sized array, using non-string
; instructions.
;
	jmp	Skip
;
ByteArray	label	byte
	db	'ARRAY CONTAINING THE LETTER ''A'' 4 TIMES'
ARRAY_LENGTH	equ	($-ByteArray)
;
; Counts the number of occurrences of the specified byte
; in the specified byte-sized array.
;
; Input:
;	AL = byte of which to count occurrences
;	CX = array length (0 means 64K)
;	DS:DI = array to count byte occurrences in
;
; Output:
;	DX = number of occurrences of the specified byte
;
; Registers altered: CX, DX, DI
;
; Note: Does not handle arrays that are longer than 64K
;	bytes or cross segment boundaries.
;
ByteCount:
	sub	dx,dx		;set occurrence counter to 0
	dec	di		;compensate for the initial
				; upcoming INC DI
	and	cx,cx		;64K long?
	jnz	ByteCountLoop	;no
	dec	cx		;yes, so handle first byte
				; specially, since JCXZ will
				; otherwise conclude that
				; we're done right away
	inc	di		;point to first byte
	cmp	[di],al		;is this byte the value
				; we're looking for?
	jz	ByteCountCountOccurrence
				;yes, so count it
ByteCountLoop:
	jcxz	ByteCountDone	;done if we've checked all
				; the bytes in the array
	dec	cx		;count off the byte we're
				; about to check
	inc	di		;point to the next byte to
				; check
	cmp	[di],al		;see if this byte contains
				; the value we're counting
	jnz	ByteCountLoop	;no match
ByteCountCountOccurrence:
	inc	dx		;count this occurrence
	jmp	ByteCountLoop	;check the next byte, if any
ByteCountDone:
	ret
;
Skip:
	call	ZTimerOn
	mov	al,'A'		;byte of which we want a
				; count of occurrences
	mov	di,offset ByteArray
				;array we want a count for
	mov	cx,ARRAY_LENGTH	;# of bytes to check
	call	ByteCount	;get the count
	call	ZTimerOff
