;
; *** Listing 7-6 ***
;
; Adds one far array to another far array by temporarily
; switching segments in order to allow the use of the most
; efficient possible instructions within the loop.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
Array1	db	ARRAY_LENGTH dup (1)
Array2	db	ARRAY_LENGTH dup (2)
;
; Adds one byte-sized array to another byte-sized array.
; C-callable.
;
; Input: parameters on stack as in AddArraysParms
;
; Output: none
;
; Registers altered: AL, BX, CX, ES
;
; Direction flag cleared
;
AddArraysParms	struc
	dw	?	;pushed BP
	dw	?	;return address
FarPtr1	dd	?	;pointer to array to be added to
FarPtr2	dd	?	;pointer to array to add to the
			; other array
AddArraysLength	dw ?	;# of bytes to add
AddArraysParms	ends
;
AddArrays	proc	near
	push	bp		;save caller's BP
	mov	bp,sp		;point to stack frame
	push	si		;save register used by many
				; C compilers for register
				; variables
	push	ds		;save normal DS, since we're
				; going to switch data
				; segments for the duration
				; of the loop
	mov	cx,[bp+AddArraysLength]
				;get the length to add
	les	bx,[bp+FarPtr1]	;point to the array to add
				; to
	lds	si,[bp+FarPtr2]	;point to the array to add
				; from
	cld			;make LODSB increment SI
AddArraysLoop:
	lodsb			;get the array element to
				; add
	add	es:[bx],al	;add to the other array
	inc	bx		;point to the next byte of
				; the array to add to
	loop	AddArraysLoop
	pop	ds		;restore normal DS
	pop	si		;restore register used by
				; many C compilers for
				; register variables
	pop	bp		;restore caller's BP
	ret
AddArrays	endp
;
Skip:
	call	ZTimerOn
	mov	ax,ARRAY_LENGTH
	push	ax	;pass the length to add
	push	ds	;pass segment of Array2
	mov	ax,offset Array2
	push	ax	;pass offset of Array2
	push	ds	;pass segment of Array1
	mov	ax,offset Array1
	push	ax	;pass offset of Array1
	call	AddArrays
	add	sp,10	;clear the parameters
	call	ZTimerOff
