;
; *** Listing 7-17 ***
;
; Performs fast, compact bit-doubling of a byte in AL
; to a word in AX by using two nibble look-ups. Overall
; code length and performance are improved by
; using base indexed addressing (bx+si) rather than base
; direct addressing (bx+DoubleNibbleTable). Even though
; an additional 3-byte MOV instruction is required to load
; SI with the offset of DoubleNibbleTable, each access to
; DoubleNibbleTable is 2 bytes shorter thanks to the
; elimination of mod-reg-rm displacements.
;
; Macro to double each bit in a byte.
;
; Input:
;	AL = byte to bit-double
;
; Output:
;	AX = bit-doubled word
;
; Registers altered: AX, BX, CL, SI
;
DOUBLE_BYTE	macro
	mov	bl,al	;move the byte to look up to BL
	sub	bh,bh	; and make a word out of the value
	mov	cl,4	;make a look-up pointer out of the
	shr	bx,cl	; upper nibble of the byte
	mov	si,offset DoubledNibbleTable
	mov	ah,[si+bx]
			;look up the doubled upper nibble
	mov	bl,al	;get the byte to look up again,
	and	bl,0fh	; and make a pointer out of the
			; lower nibble this time
	mov	al,[si+bx]
			;look up the doubled lower nibble
	endm
;
	jmp	Skip
DOUBLED_VALUE=0
DoubledNibbleTable	label	byte
	db	000h, 003h, 00ch, 00fh
	db	030h, 033h, 03ch, 03fh
	db	0c0h, 0c3h, 0cch, 0cfh
	db	0f0h, 0f3h, 0fch, 0ffh
;
Skip:
	call	ZTimerOn
BYTE_TO_DOUBLE=0
	rept	100
	mov	al,BYTE_TO_DOUBLE
	DOUBLE_BYTE
BYTE_TO_DOUBLE=BYTE_TO_DOUBLE+1
	endm
	call	ZTimerOff
