    				 /*-----------------------------------------------------+
					  |				         ClockU3D.cpp					|
					  |														|
					  |	   Une classe ki permet d'avoir un timer un temps	|
					  |			 soit peu + precis ke le clock()			|
					  |														|
					  | 	U2^PoPsy TeAm 2000								|
					  +-----------------------------------------------------*/

#include "u3d3.h"

//----------------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//									+-------------------------+
//									|   Variables Globales	  |
//									+-------------------------+
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------------------------------

double	ClockU3D::TimeForOneTick	= 0.0	;
double	ClockU3D::BaseTime			= 0.0	;
U32		ClockU3D::lowPart			= 0		;
U32		ClockU3D::highPart			= 0		;
static	BOOL PerfTimer				= FALSE	;


//----------------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//									+---------------------+
//									|    Class ClockU3D	  |
//									+---------------------+
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------------------------------
void ClockU3D::Initialise()
{
	U32				tmp1,tmp2		;
	U32				tmp3,tmp4		;
	clock_t			start,fin		;
	LARGE_INTEGER	Btime,Btime1	;

	//----------------------- voix si ya un good timer !!
	if( QueryPerformanceFrequency( &Btime ) )	
	{
		PerfTimer = TRUE	;

		TimeForOneTick = 1. / Btime.LowPart	;	// temps d'1 seul cycle !

		QueryPerformanceCounter( &Btime1 )	;
		lowPart = Btime1.LowPart			;
		highPart = Btime1.HighPart			;

		#ifdef _DEBUG
			CString	cstmp																;
			cstmp.Format( "<U3D> Perf Timer Found at %f Khz\n", (float)Btime.LowPart/1000. )	;
			DebugOutput( (LPCSTR)cstmp )												;
		#endif
	}
	//----------------------- sinon ben tente la mesure avec un clock() ( moins precis )
	else
	{
		PerfTimer = FALSE	;

		start = clock()			;
		while( start==clock() )	;	// attend un changement paskeu pas tres precis le clock()

		//--------------------- recupere cycle d'horloge du procs
		__asm{
				rdtsc
				mov tmp1, eax
				mov tmp2, edx
		}

		//-------------------- attend 1000 milisecondes
		fin = start								;
		while( fin<(start+1000) ) fin=clock()	;

		//--------------------- recupere et calcul le nombre de cycle d'horloge pour 1000 milisecondes
		__asm{
				rdtsc
				mov tmp3, eax
				mov tmp4, edx
				sub eax, tmp1
				sbb edx, tmp2
				mov tmp1, eax
				mov tmp2, edx
		}

		lowPart = tmp3				;
		highPart = tmp4				;
		BaseTime = 0.0				;
		TimeForOneTick = 1. / tmp1 	;	// temps d'1 seul cycle !

		#ifdef _DEBUG
			CString	cstmp																			;
			cstmp.Format( "<U3D> No PerfTimer!!! Using RDTSC with a Procs at %d Mhz\n", (int)ceil(tmp1) )	;
			DebugOutput( (LPCSTR)cstmp )															;
		#endif
	}


}
//----------------------------------------------------------------------------------------------------------
double ClockU3D::GetTime()
{
	U32				tmp1,tmp2	;
	U32				tmp3,tmp4	;
	LARGE_INTEGER	Btime		;

	if( PerfTimer )
	{
		QueryPerformanceCounter( &Btime )	;
		
		tmp1 = Btime.LowPart - lowPart		;
		tmp2 = Btime.HighPart - highPart	;
		lowPart = Btime.LowPart				;
		highPart = Btime.HighPart			;
	}
	else
	{
		tmp1 = lowPart	;
		tmp2 = highPart	;

		__asm{
				rdtsc
				mov tmp3, eax
				mov tmp4, edx
				sub eax, tmp1
				sbb edx, tmp2
				mov tmp1, eax
				mov tmp2, edx
		}

		lowPart = tmp3		;
		highPart = tmp4		;
	}

	BaseTime += TimeForOneTick*(double)tmp1	;

	return BaseTime	;
}
//----------------------------------------------------------------------------------------------------------
