// bs3View.cpp : implementation of the CAlexView class
//

#include "stdafx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAlexView

extern ULONG cbformat;	

IMPLEMENT_DYNCREATE(CAlexView, CScrollView)

BEGIN_MESSAGE_MAP(CAlexView, CScrollView)
	//{{AFX_MSG_MAP(CAlexView)
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_KEYDOWN()
	ON_WM_DESTROY()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP		
END_MESSAGE_MAP()


CAlexView::CAlexView()
{
	alexdc=NULL;
	xmemdc=NULL;
	
	mb=0;
	
}

CAlexView::~CAlexView()
{
	InitBMP(NULL,0,0);
	delete alexdc;	
}

BOOL CAlexView::PreCreateWindow(CREATESTRUCT& cs)
{
	// Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.style|=WS_CLIPCHILDREN|WS_CLIPSIBLINGS;

	SetScrollSizes(MM_TEXT, CSize(100,100));
	

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CAlexView drawing

void CAlexView::InitBMP(CDC *dc, int ww, int hh)
{
	if ((GetWindowLong(m_hWnd,GWL_STYLE)&WS_VISIBLE)==0)
	{
		dc=0;
		ww=0;
		hh=0;
	}
	if (alexdc)
	{
		if (xmemdc) xmemdc->SelectObject((CBitmap*)0);

		//delete alexdc;
		//alexdc=NULL;		
	}
	if (xmemdc)
	{
		xmemdc->DeleteDC();
		delete xmemdc;
		xmemdc=NULL;
	}	

	if (ww==0 && hh==0 && dc)
	{
	
		RECT r;
		GetClientRect(&r);
		ww=w=r.right-r.left;
		hh=h=r.bottom-r.top;
	}
	w=ww;
	h=hh;
	
	if (!dc) 
	{
		//InitButtons();
		return;
	}
	
	if (!font) font=CreateFont(-12,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,"Lucida Console");
	if (!boldfont) boldfont=CreateFont(-12,0,0,0,FW_DONTCARE,0,0,FW_BOLD,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,"Arial");

	xmemdc=new CDC;
	xmemdc->CreateCompatibleDC(dc);
	if (!alexdc)
	{	
		alexdc=new AlexDC(xmemdc->m_hDC,w,h,NCX1,NCY1,NCX2, NCY2);
	}
	else
	{
		alexdc->Set(xmemdc->m_hDC,w,h,NCX1,NCY1,NCX2, NCY2);
	}
	xmemdc->SelectObject((HBITMAP)alexdc->hb);
	xmemdc->SelectObject(font);
	xmemdc->SetBkMode(TRANSPARENT);
	xmemdc->SetTextAlign(TA_CENTER);	
	Redraw();
	//InitButtons();
	
}

void CAlexView::Redraw()
{
	if (alexdc)
	{

		CPoint p = GetDeviceScrollPosition();
		alexdc->SetOrigin(p.x,p.y);
	
		alexdc->FillRect(p.x,p.y,alexdc->w+p.x,alexdc->h+p.y,C32TO8(GetBKCol()));
		//alexdc->FillRect(p.x,p.y+p.y-64,alexdc->w+p.x-256,alexdc->h+p.y,C32TO8(BKCOL));
	}
}

void CAlexView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!xmemdc) InitBMP(pDC,0,0);
	Redraw();
	Blt(pDC,0,0,w,h);
}

void CAlexView::OnInitialUpdate()
{
	
	CScrollView::OnInitialUpdate();
	
}


/////////////////////////////////////////////////////////////////////////////
// CAlexView diagnostics

#ifdef _DEBUG
void CAlexView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CAlexView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

CDocument* CAlexView::GetDocument() // non-debug version is inline
{
	//ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CBs3Doc)));
	return (CDocument*)m_pDocument;
}

/////////////////////////////////////////////////////////////////////////////
// CAlexView message handlers

BOOL CAlexView::OnEraseBkgnd(CDC* pDC) 
{
	return -1;
}

void CAlexView::OnSize(UINT nType, int cx, int cy) 
{
	CScrollView::OnSize(nType, cx, cy);
	
	CalcWndSize();
	
}



BOOL CAlexView::OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll) 
{
	
	int rv = CScrollView::OnScroll(nScrollCode, nPos, bDoScroll);
	//InvalidateRect(NULL);
	return rv;
}


void CAlexView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CScrollView::OnLButtonDblClk(nFlags, point);
}


void CAlexView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	SetCapture();
	point+=GetScrollPosition();
	
	cx=point.x;
	cy=point.y;
	mx=point.x;
	my=point.y;
	mb|=1;
	CScrollView::OnLButtonDown(nFlags, point);
}

void CAlexView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	point+=GetScrollPosition();
	mx=point.x;
	my=point.y;
	mb&=~1;
	ReleaseCapture();
	
	CScrollView::OnLButtonUp(nFlags, point);
}

void CAlexView::OnMouseMove(UINT nFlags, CPoint point) 
{
	point+=GetScrollPosition();
	mx=point.x;
	my=point.y;
	CScrollView::OnMouseMove(nFlags, point);
}

void CAlexView::OnRButtonDblClk(UINT nFlags, CPoint point) 
{	
	CScrollView::OnRButtonDblClk(nFlags, point);
}

void CAlexView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	SetCapture();
	CPoint p=point;
	ClientToScreen(&p);
	point+=GetScrollPosition();
	
	cx=point.x;
	cy=point.y;
	mx=point.x;
	my=point.y;
	mb|=2;

	CScrollView::OnRButtonDown(nFlags, point);
}

void CAlexView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	point+=GetScrollPosition();
	mx=point.x;
	my=point.y;

	
	ReleaseCapture();
	mb&=~2;
	
	CScrollView::OnRButtonUp(nFlags, point);
}


void CAlexView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CAlexView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
}


void CAlexView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
}
