///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// Text mode demo compo 5 invitation demo
// Copyright (c) 2002 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////
//
// Ladies and Gentlebeings, 
//
// This is probably the most horrible pile of garbage I've ever released.
//
// Done in under 20 hours over the span of three days, I'm more or less
// satisfied with it, apart from the source release naturally.
//
// The colorful asciiart thingy (TFX_AsciiArt2) is unfinished; it only
// works on one output blitter (160x100->80x50), although it would be easy
// to make it work on all of them. The colors are more or less unbalanced
// so you may need to do some heavy tweaking on it to get it look decent.
//
// I originally meant this invitation to include some cool ANSI art by lum,
// but then I found that Microsoft, in their infinite wisdom, have BROKEN
// THE GOD DAMN PALETTE in textmode when running win32 console code. I could
// have made the palette work by doing a registry patch but I feel that's
// unhealthy.
//
// On the palette thingy - I enabled the 'clean' palette use and well, it 
// works better on this broken palette. I could have copied the color values
// from the console settings as well but I think it works well enough now.
//
// Other unfinished things - I ported part of the fatmap2 package to truecolor,
// some of the fillers are still in 8bit with assembler inner loops.
//
// As for the quality of the code, well.. tons and tons of copypaste code,
// globals here and there, leaks memory like a drunkard in a street fight,
// and so on.. don't take this as an example of whatever, this is really
// a horrible, horrible, fast hack. But it might contain some routines
// that help you.
//
// Libs needed 
// - cfl3 (included) by yours truly.
// - fatmap2 (included in hacked form) by Mats Byggmastar, hacked by me.
// - FMOD (not included, you may need to figure out the include and lib paths)
//        by Firelight Multimedia, leech it from www.fmod.org.
// - DirectX8 SDK (not included), used d3dx math (so call me lazy).
//
// That's about it. Feel free to use or abuse this source as you wish,
// as long as you don't bug me about it.
//
// Happy hacking,
//                Sol
//            aka
//                Jari Komppa, 2002   
//                http://iki.fi/sol
//
// ps. Do note that this is a "win32 console" application, 
//     not "win32 application" - kbhit() and stuff work better
//     this way.

// Includes
#include <windows.h> // sleep()
#include <conio.h>   // console IO (kbhit etc)
#include <math.h>    // sqrt, pow
#include <fmod.h>    // fmod.
#include "pcxload.h" // loading pcxes.
#include "cfl.h"     // ..from a CFL.
#include "textfx.h"  // textmode "graphics" output
#include "misc.h"    // fatmap2
#include "SimpleFontPrinter.h" // gPrinter

// Effect externs
extern void flower(int tick, int *fb);
extern void metaobjs(int tick, int *fb);
extern void chaos(int tick, int *fb);
extern void chaos2(int tick, int *fb); // copy paste coding..
extern void fadetoblack(int val, int * fb);
extern void do3d(int tick, int *fb);
extern void do3d2(int tick, int *fb); // copy paste coding forever..
extern void do3d3(int tick, int *fb); // copy paste coding forever and ever..

// Global data
SimpleFontPrinter *gPrinter = NULL; // our printer object
int blendmode = 0;  // blend mode, for printer and flat filler (see printer for info)
int blendvalue = 0; // blend value, for printer and flat filler (see printer for info)
char *gIntroPic_t = NULL, 
     *gIntroPic_m = NULL, 
     *gIntroPic_d = NULL, 
     *gIntroPic_c = NULL, 
     *gIntroPic_5 = NULL; // intro piccies
CFL *cfl = NULL; // cfl lib
int *fb = NULL; // framebuffer

// These are needed for those routines in fatmap2 that I didn't port yet,
// or didn't port properly.. which is, pretty much all of them
char WritePagePtr[160*100];
int  WritePageWidth = 160;



// this is handy if you want to port the rest of the fatmap2 fillers..
void wp2fb(int *fb)
{
    for (int i = 0; i < 160*100; i++)
        fb[i] = WritePagePtr[i] *  0x010101;
}



// simple backface checking, from fatmap2 package
int backface(vertexuvfloat * vtx)
{
    return (vtx[0].x - vtx[1].x) * (vtx[2].y - vtx[1].y) -
        (vtx[2].x - vtx[1].x) * (vtx[0].y - vtx[1].y) < 0.0;
}


// the main loop..
void demomain()
{
    TFX_BlockColor bc; // block-color output, what we use most of the time
    TFX_AsciiArt2 aa2; // and colorful ascii-art that is used in one effect.
    int effectmode = 0;  // effect mode - which part is running
    int effectvalue = 0; // effect value - mostly used as a counter in the effect
    int effectoffset = 0;// effect offset - the tick that the effect starts
    int outputmode = 0;// output mode - which output filter to use
    int tick = 0;      // current tick
    int frame = 0;     // current frame (@25fps, fixed)

    TFX_SetTitle("TMDC5 invitation - press Alt-Enter for fullscreen - ESC quits");

    // dump out 'loading' in the top left corner..
    {
        char temp[] = "Loading..";
        for (int i = 0; i < sizeof(temp); i++)
            TFX_FrameBuffer[i] = (short)(temp[i] | 0x0f00);
        TFX_Present();
    }

    // now, we SHOULD be doing tons of error-checking..
    cfl = CFL::create("tmdc5.cfl");    
    FSOUND_Init(44100, 1, 0);
    fb=new int[160*100];
    memset(fb,0,160*100*4);
    int * realfb = fb;
    int * textlayer = new int[160 * 100];
    
    gIntroPic_t = loadpcx("intro_t.pcx");
    gIntroPic_m = loadpcx("intro_m.pcx");
    gIntroPic_d = loadpcx("intro_d.pcx");
    gIntroPic_c = loadpcx("intro_c.pcx");
    gIntroPic_5 = loadpcx("intro_5.pcx");
    
    gPrinter = SimpleFontPrinter::create("fona_copperplate.pcx");
    
    bc.BuildLUT();
    aa2.BuildLUT();
    
    FSOUND_STREAM * tune = FSOUND_Stream_OpenFile("tmdc2002.mp3",0,0);
    FSOUND_Stream_Play(0, tune);

    // ..but we didn't, so there.

    // this is handy when tweaking some part 3 minutes away from the
    // beginning:
    //FSOUND_Stream_SetTime(tune, 60000);

    // this is handy when tweaking new effects:
/*
    while(!_kbhit())
    {
        do3d3(GetTickCount() / 40, fb);
        bc.Dump2x(fb,TFXQuad(0,0,160,100),160,0,0);
        TFX_Present();
    }
    return;
*/

    // the real main loop:
    while(!_kbhit()) // loop exits on any key press
    {        
        // check if we're looped (normal demo would probably quit)
        if (tick > 260000)
        {
            // looped
            tick = 0;
            frame = 0;
            FSOUND_Stream_SetTime(tune, 0);
        }

        // FPS cap
        while (tick >= FSOUND_Stream_GetTime(tune)) 
        {
            Sleep(0);
        }

        // frame skip
        int current_tick = FSOUND_Stream_GetTime(tune);
        while (tick < current_tick)
        {
            // demo events; nothing really heavy. These are run
            // for each frame even if we skip 3 minutes of the demo.            
            switch (frame)
            {
            case 0:
                effectmode = 0;
                effectvalue = 0;
                outputmode = 0;
                break;
            case (16 * 25):
                effectmode = 1;
                effectvalue = 0;
                effectoffset = frame;
                break;
            case (32 * 25):
                effectmode = 2;
                outputmode = 2;
                effectoffset = frame;
                effectvalue = 0;
                break;
            case (32 * 25 + 14):
                effectvalue = 1;
                effectoffset = frame;
                break;
            case (33 * 25 + 14):
                effectvalue = 2;
                effectoffset = frame;
                break;
            case (34 * 25 + 14):
                effectvalue = 3;
                effectoffset = frame;
                break;
            case (35 * 25 + 14):
                effectvalue = 4;
                effectoffset = frame;
                break;
            case (36 * 25 + 14):
                effectvalue = 5;
                effectoffset = frame;
                break;
            case (37 * 25 + 14):
                effectvalue = 6;
                effectoffset = frame;
                break;
            case (38 * 25 + 14):
                effectvalue = 7;
                effectoffset = frame;
                break;
            case (39 * 25 + 14):
                effectvalue = 8;
                effectoffset = frame;
                break;
            case (40 * 25 + 14):
                effectvalue = 9;
                effectoffset = frame;
                break;
            case (41 * 25 + 14):
                effectvalue = 10;
                effectoffset = frame;
                break;
            case (32 * 25 + 22):
                effectvalue = 0;
                effectoffset = frame;
                break;
            case (33 * 25 + 28):
                effectvalue = 0;
                break;
            case (34 * 25 + 22):
                effectvalue = 0;
                break;
            case (35 * 25 + 28):
                effectvalue = 0;
                break;
            case (36 * 25 + 22):
                effectvalue = 0;
                break;
            case (37 * 25 + 28):
                effectvalue = 0;
                break;
            case (38 * 25 + 22):
                effectvalue = 0;
                break;
            case (39 * 25 + 28):
                effectvalue = 0;
                break;
            case (40 * 25 + 22):
                effectvalue = 0;
                break;
            case (41 * 25 + 28):
                effectvalue = 0;
                effectmode = 3;
                break;
            case (42 * 25 + 14):
                effectvalue = 1 << 16;
                break;
            case (43 * 25 + 14):
            case (44 * 25 + 14):
            case (45 * 25 + 14):
            case (46 * 25 + 14):
            case (47 * 25 + 14):
                effectvalue = 2 << 16;
                break;
            case (48 * 25 + 14):
                effectvalue = 3 << 16;
                break;
            case (49 * 25 + 14):
            case (50 * 25 + 14):
            case (51 * 25 + 14):
            case (52 * 25 + 14):
            case (53 * 25 + 14):
            case (54 * 25 + 14):
            case (55 * 25 + 14):
                effectvalue = 4 << 16;
                break;
            case (56 * 25):
                effectmode = 4;
                effectvalue = 0;
                break;
            case (80 * 25):
                effectmode = 5;
                effectvalue = 0;
                effectoffset = frame;
                break;
            case (80 * 25 + 13):
            case (81 * 25 + 13):
            case (82 * 25 + 13):
            case (83 * 25 + 13):
            case (84 * 25 + 13):
            case (85 * 25 + 13):
            case (86 * 25 + 13):
            case (87 * 25 + 13):
            case (88 * 25 + 13):
            case (89 * 25 + 13):
            case (90 * 25 + 13):
            case (91 * 25 + 13):
            case (92 * 25 + 13):
            case (93 * 25 + 13):
            case (94 * 25 + 13):
            case (95 * 25 + 13):
            case (96 * 25 + 13):
            case (97 * 25 + 13):
            case (98 * 25 + 13):
            case (99 * 25 + 13):
            case (100 * 25 + 13):
            case (101 * 25 + 13):
            case (102 * 25 + 13):
            case (103 * 25 + 13):
            case (104 * 25 + 13):
            case (105 * 25 + 13):
            case (106 * 25 + 13):
            case (107 * 25 + 13):
            case (108 * 25 + 13):
            case (109 * 25 + 13):
            case (110 * 25 + 13):
                effectvalue++;
                break;
            case (112 * 25):
                effectvalue = 0;
                outputmode = 0;
                effectmode = 6;
                effectoffset = frame;
                break;
            case (128 * 25):
                effectvalue = 0;
                outputmode = 2;
                effectmode = 7;
                break;
            case (152 * 25):
                effectvalue = 0;
                effectmode = 8;
                effectoffset = frame;
                break;                
            case (155 * 25):
                effectvalue = 1;
                effectoffset = frame;
                break;
            case (157 * 25):
                effectvalue = 2;
                effectoffset = frame;
                break;
            case (159 * 25):
                effectvalue = 3;
                effectoffset = frame;
                break;
            case (162 * 25):
                effectvalue = 4;
                effectoffset = frame;
                break;
            case (166 * 25):
                effectvalue = 5;
                effectoffset = frame;
                break;
            case (168 * 25):
                effectvalue = 6;
                effectoffset = frame;
                break;
            case (171 * 25):
                effectvalue = 7;
                effectoffset = frame;
                break;
            case (176 * 25):
                effectmode = 9;
                effectoffset = frame;
                break;        
            case (224 * 25):
                effectmode = 0;
                outputmode = 0;
                effectvalue = 0xff;
                memset(fb,0,160*100*4);
                break;
            }
            if (frame > 0 && frame < (16 * 25))
            {
                effectvalue = (frame * 0xff) / (16 * 25);
            }
            if (effectoffset == 16*25)
            {
                effectvalue = ((frame - effectoffset) * 0xff) / (16 * 25);                
            }
            if (effectmode == 3 || effectmode == 4 || effectmode == 7)
                effectvalue++;
            if (frame > (4*60*25) && frame < ((4*60+16) * 25))
            {
                effectvalue = 0xff - (((frame - 4*60*25) * 0xff) / (16 * 25));
            }
            tick += (1000/25);        
            frame++;
        }

        // rendering; done once every rendering loop. 
        // Includes tons of stupid code (like all those shadow printers
        // done with two print calls that I could have functionalized, but didn't).
        switch (effectmode)
        {
        case 0:
            flower((int)(frame * 0.75f) + 6500,fb);
            fadetoblack(effectvalue, fb);
            break;
        case 1:
            flower((int)(frame * 0.75f) + 6500,fb);
            memcpy(textlayer,fb,160*100*4);
            fb = textlayer;
            gPrinter->print(fb,(effectvalue) - 110-2,40,"Once again..",3,(0x80 - abs(effectvalue - 0x7f)) * 2);
            gPrinter->print(fb,(effectvalue) - 110,40,"Once again..",1,(0x80 - abs(effectvalue - 0x7f)) * 2);
            break;
        case 2:
            chaos(frame,fb);
            if (effectvalue != 0)
            {
                char * piccy = NULL;
                switch (effectvalue)
                {
                case 1:
                case 2:
                    piccy = gIntroPic_t;
                    break;
                case 3:
                case 4:
                    piccy = gIntroPic_m;
                    break;
                case 5:
                case 6:
                    piccy = gIntroPic_d;
                    break;
                case 7:
                case 8:
                    piccy = gIntroPic_c;
                    break;
                case 9:
                case 10:
                    piccy = gIntroPic_5;
                    break;
                }
                if (effectvalue & 1)
                {
                    for (int i = 0; i < 160*100; i++)
                        if (piccy[i] == 0)
                            fb[i] = 0xffffff;
                }
                else
                {
                    for (int i = 0; i < 160*100; i++)
                        if (piccy[i] == 0)
                            fb[i] = 0;
                        memcpy(textlayer,fb,160*100*4);
                        fb = textlayer;
                        switch (effectvalue)
                        {
                        case 2:
                            gPrinter->print(fb,46,61,"Text",3,0xff - (frame - effectoffset) * 16);
                            gPrinter->print(fb,45,60,"Text",1,0xff - (frame - effectoffset) * 16);
                            break;
                        case 4:
                            gPrinter->print(fb,46,61,"Mode",3,0xff - (frame - effectoffset) * 16);
                            gPrinter->print(fb,45,60,"Mode",1,0xff - (frame - effectoffset) * 16);
                            break;
                        case 6:
                            gPrinter->print(fb,46,61,"Demo",3,0xff - (frame - effectoffset) * 16);
                            gPrinter->print(fb,45,60,"Demo",1,0xff - (frame - effectoffset) * 16);
                            break;
                        case 8:
                            gPrinter->print(fb,36,61,"Compo",3,0xff - (frame - effectoffset) * 16);
                            gPrinter->print(fb,35,60,"Compo",1,0xff - (frame - effectoffset) * 16);
                            break;
                        case 10:
                            gPrinter->print(fb,51,61,"Five",3,0xff - (frame - effectoffset) * 16);
                            gPrinter->print(fb,50,60,"Five",1,0xff - (frame - effectoffset) * 16);
                            break;
                        }
                }
            }
            break;
        case 3:          
            chaos(frame,fb);
            memcpy(textlayer,fb,160*100*4);
            fb = textlayer;
            {
                int v = effectvalue & 0xffff;
                v = (int)sqrt(v * 10);                        
                if (effectvalue > 0x0ffff)
                {
                    gPrinter->print(fb,11 + v,9,"Start",3,0xff);
                    gPrinter->print(fb,10 + v,8,"Start",1,0xff);
                }
                if (effectvalue > 0x1ffff)
                {
                    gPrinter->print(fb,11 + v,27,"11.11.2002",3,0xff);
                    gPrinter->print(fb,10 + v,26,"11.11.2002",1,0xff);
                }
                if (effectvalue > 0x2ffff)
                {
                    gPrinter->print(fb,11 + v,51,"Deadline",3,0xff);
                    gPrinter->print(fb,10 + v,50,"Deadline",1,0xff);
                }
                if (effectvalue > 0x3ffff)
                {
                    gPrinter->print(fb,11 + v,69,"12.12.2002",3,0xff);
                    gPrinter->print(fb,10 + v,68,"12.12.2002",1,0xff);
                }
            }
            break;
        case 4:
            metaobjs(frame,fb);
            gPrinter->print(fb,160 - effectvalue+1,12,"Text Mode Demo Competition 5",3,0xff);
            gPrinter->print(fb,160 - effectvalue,8,"Text Mode Demo Competition 5",0,0xff);
            gPrinter->print(fb,200 - effectvalue*2+1,41,"http://www.tAAt.fi/tmdc/         http://www.tAAt.fi/tmdc/",3,0xff);
            gPrinter->print(fb,200 - effectvalue*2,37,"http://www.tAAt.fi/tmdc/         http://www.tAAt.fi/tmdc/",0,0xff);
            gPrinter->print(fb,240 - effectvalue*3+1,72,"Remember: it's all about impresing people, baby! Full software rendering power all the way..",3,0xff);
            gPrinter->print(fb,240 - effectvalue*3,68,"Remember: it's all about impresing people, baby! Full software rendering power all the way..",0,0xff);
            break;
        case 5:
            if (effectvalue & 1)
                do3d(frame,fb);
            else
                do3d2(frame,fb); // 32 * 25 frames
            gPrinter->print(fb,240 - (frame - effectoffset)*3,80,
                "Textmode gives you tons of CPU power per pixel "
                "while having some unique restrictions you have to beat   -   "
                "Can YOU make textmode look GOOD?"
                ,1,0xaf);
            break;        
        case 6:
            if (effectvalue == 0)
            {
                memset(fb,0,160*100*4);
                effectvalue++;
            }
            flower((int)pow(frame-effectoffset,0.9),fb);
            break;
        case 7:
            metaobjs(frame,fb);
            gPrinter->print(fb,160 - (int)(effectvalue*1.2f+1),12,"Prize information    Prize information",3,0xff);
            gPrinter->print(fb,160 - (int)(effectvalue*1.2f),8,"Prize information    Prize information",0,0xff);
            gPrinter->print(fb,360 - (int)(effectvalue*2.8f+1),41,"tAAt T-Shirts      DemoDVD      Tickets to altparty2003      TMDC diplomas",3,0xff);
            gPrinter->print(fb,360 - (int)(effectvalue*2.8f),37,"tAAt T-Shirts      DemoDVD      Tickets to altparty2003      TMDC diplomas",0,0xff);
            gPrinter->print(fb,560 - (int)(effectvalue*5+1),72,"Top-3 will receive a free entry to altparty2003 where the prize-giving ceremony will be held! (Those that can't make it will receive their prizes in the mail)",3,0xff);
            gPrinter->print(fb,560 - (int)(effectvalue*5),68,"Top-3 will receive a free entry to altparty2003 where the prize-giving ceremony will be held! (Those that can't make it will receive their prizes in the mail)",0,0xff);
            break;
        case 8:
            chaos2(frame,fb);
            memcpy(textlayer,fb,160*100*4);
            fb = textlayer;
            if (effectvalue > 1 && effectvalue < 7)
            {
                gPrinter->print(fb,30,8,"Credits",2,128);
                gPrinter->print(fb,30,8,"Credits",2,128);
                gPrinter->print(fb,30,8,"Credits",2,128);
            }
            if (effectvalue == 1)
            {
                int v = frame - effectoffset;
                if (v > 32) v = 32;
                gPrinter->print(fb,30 - ((32 - v) >> 1),8,"Credits",2,v*4);
                gPrinter->print(fb,30 + ((32 - v) >> 1),8,"Credits",2,v*4);
                gPrinter->print(fb,30,8,"Credits",2,v*4);
            }
            if (effectvalue > 2 && effectvalue < 4)
            {
                gPrinter->print(fb,10,40,"Code",2,128);  
                gPrinter->print(fb,10,40,"Code",2,128);  
                gPrinter->print(fb,10,40,"Code",2,128);  
            }
            if (effectvalue == 2)
            {
                int v = frame - effectoffset;
                if (v > 32) v = 32;
                gPrinter->print(fb,10 - ((32 - v) >> 1),40,"Code",2,v*4);
                gPrinter->print(fb,10 + ((32 - v) >> 1),40,"Code",2,v*4);
                gPrinter->print(fb,10,40,"Code",2,v*4);
            }
            if (effectvalue == 3)
            {
                int v = frame - effectoffset;
                if (v > 32) v = 32;
                gPrinter->print(fb,90 - ((32 - v) >> 1),60,"Sol",2,v*4);
                gPrinter->print(fb,90 + ((32 - v) >> 1),60,"Sol",2,v*4);
                gPrinter->print(fb,90,60,"Sol",2,v*4);
            }
            if (effectvalue == 4)
            {
                int v = frame - effectoffset;
                if (v > 32) v = 32;
                v = 32 - v;
                gPrinter->print(fb,10 - ((32 - v) >> 1),40,"Code",2,v*4);
                gPrinter->print(fb,10 + ((32 - v) >> 1),40,"Code",2,v*4);
                gPrinter->print(fb,10,40,"Code",2,v*4);
                gPrinter->print(fb,90 - ((32 - v) >> 1),60,"Sol",2,v*4);
                gPrinter->print(fb,90 + ((32 - v) >> 1),60,"Sol",2,v*4);
                gPrinter->print(fb,90,60,"Sol",2,v*4);
            }

            if (effectvalue == 5)
            {
                int v = frame - effectoffset;
                if (v > 32) v = 32;
                gPrinter->print(fb,10 - ((32 - v) >> 1),40,"Music",2,v*4);
                gPrinter->print(fb,10 + ((32 - v) >> 1),40,"Music",2,v*4);
                gPrinter->print(fb,10,40,"Music",2,v*4);
            }
            if (effectvalue == 6)
            {
                gPrinter->print(fb,10,40,"Music",2,128);  
                gPrinter->print(fb,10,40,"Music",2,128);  
                gPrinter->print(fb,10,40,"Music",2,128);  
            }
            if (effectvalue == 6)
            {
                int v = frame - effectoffset;
                if (v > 32) v = 32;
                gPrinter->print(fb,70 - ((32 - v) >> 1),60,"Teque",2,v*4);
                gPrinter->print(fb,70 + ((32 - v) >> 1),60,"Teque",2,v*4);
                gPrinter->print(fb,70,60,"Teque",2,v*4);
            }
            if (effectvalue == 7)
            {
                int v = frame - effectoffset;
                if (v > 32) v = 32;
                v = 32 - v;
                gPrinter->print(fb,10 - ((32 - v) >> 1),40,"Music",2,v*4);
                gPrinter->print(fb,10 + ((32 - v) >> 1),40,"Music",2,v*4);
                gPrinter->print(fb,10,40,"Music",2,v*4);
                gPrinter->print(fb,70 - ((32 - v) >> 1),60,"Teque",2,v*4);
                gPrinter->print(fb,70 + ((32 - v) >> 1),60,"Teque",2,v*4);
                gPrinter->print(fb,70,60,"Teque",2,v*4);
                gPrinter->print(fb,30 - ((32 - v) >> 1),8,"Credits",2,v*4);
                gPrinter->print(fb,30 + ((32 - v) >> 1),8,"Credits",2,v*4);
                gPrinter->print(fb,30,8,"Credits",2,v*4);
            }
            break;
        case 9:
            do3d3(frame,fb);
            gPrinter->print(fb, 302 - (frame - effectoffset) / 2,2,"(80 faces glenz ^_^)",3,0xff);
            gPrinter->print(fb, 300 - (frame - effectoffset) / 2,0,"(80 faces glenz ^_^)",2,0xff);
            gPrinter->print(fb, 162 - (int)((frame - effectoffset)*2.5f),79,"For latest information about the contest (including up to date prize information etc) please check the TMDC site at http://www.tAAt.fi/tmdc/ - any questions can be mailed to tmdc@tAAt.fi.",3,0xff);
            gPrinter->print(fb, 160 - (int)((frame - effectoffset)*2.5f),77,"For latest information about the contest (including up to date prize information etc) please check the TMDC site at http://www.tAAt.fi/tmdc/ - any questions can be mailed to tmdc@tAAt.fi.",1,0xff);
            break;
                        
        }

        // and dump to screen.
        switch (outputmode)
        {
        case 0:
            aa2.Dump2x(fb,TFXQuad(0,0,160,100),160,0,0);
            break;
            /*
        case 1:
            aa.Dump2x(fb,TFXQuad(0,0,160,100),160,0,0);
            break;
            */
        case 2:
            bc.Dump2x(fb,TFXQuad(0,0,160,100),160,0,0);
            break;
        }
        fb = realfb;

        // debug information printer:
/*       
        {
            char temp[80];
            sprintf(temp,"tick: %6d frame: %4d", tick, frame);
            for (int i = 0; i < 80; i++)
                TFX_FrameBuffer[i] = temp[i] | 0x1f00;
        }
*/        
        // blit out.
        TFX_Present();
   }
   // close fmod. Should be done in exitfunc as someone might close the
   // window.
   FSOUND_Close();
}