#ifndef BLENDFUNCS_H
#define BLENDFUNCS_H

static int blend_additive(int tgt, int src, int v)
{
    if (v > 0xff) v = 0xff;
    if (v < 0) v = 0;
    int b = (tgt >> 0) & 0xff;
    int g = (tgt >> 8) & 0xff;
    int r = (tgt >> 16) & 0xff;
    b += ((((src >> 0) & 0xff) * v) >> 8) & 0xff;
    g += ((((src >> 8) & 0xff) * v) >> 8) & 0xff;
    r += ((((src >> 16) & 0xff) * v) >> 8) & 0xff;
    if (b > 0xff) b = 0xff;
    if (g > 0xff) g = 0xff;
    if (r > 0xff) r = 0xff;
    return (r << 16) + (g << 8) + b;
}

static int blend_invmul(int tgt, int src, int v)
{
    if (v > 0xff) v = 0xff;
    if (v < 0) v = 0;
    int b = (tgt >> 0) & 0xff;
    int g = (tgt >> 8) & 0xff;
    int r = (tgt >> 16) & 0xff;
    b *= 0x100 - (((((src >> 0) & 0xff) * v) >> 8) & 0xff);
    g *= 0x100 - (((((src >> 8) & 0xff) * v) >> 8) & 0xff);
    r *= 0x100 - (((((src >> 16) & 0xff) * v) >> 8) & 0xff);
    b >>= 8;
    g >>= 8;
    r >>= 8;
    return (r << 16) + (g << 8) + b;
}

static int blend_fade(int tgt, int src, int v)
{
    if (v > 0xff) v = 0xff;
    if (v < 0) v = 0;
    int b = ((((tgt >> 0) & 0xff) * (0xff - v)) >> 8) & 0xff;
    int g = ((((tgt >> 8) & 0xff) * (0xff - v)) >> 8) & 0xff;
    int r = ((((tgt >> 16) & 0xff) * (0xff - v)) >> 8) & 0xff;
    b += ((((src >> 0) & 0xff) * v) >> 8) & 0xff;
    g += ((((src >> 8) & 0xff) * v) >> 8) & 0xff;
    r += ((((src >> 16) & 0xff) * v) >> 8) & 0xff;
    return (r << 16) + (g << 8) + b;
}


#endif // BLENDFUNCS_H