
; DOS extender type

;PMODE	 = 1
;WATCOM  = 1

ifndef (PMODE or VISUALC or WATCOM)	  ; something, to make it compile
PMODE = 1
endif

macro   @uvcopy  dest, src
        push    eax
        mov     eax,[0+&src]
        mov     [&dest],eax
        mov     eax,[4+&src]
        mov     [4+&dest],eax
        pop     eax
ENDM

macro   @shadecopy  dest, src
        push    eax
        mov     eax,[0+&src]
        mov     [&dest],eax
        pop     eax
ENDM

MACRO   @movd   dest, src
ifdef (WATCOM or VISUALC)
;	 ASSUME  DS:nothing
        mov     [dword ds:&dest], &src
;	 ASSUME  DS:_TEXT
elseifdef PMODE
        mov     [dword ds:&dest], &src
endif
ENDM

MACRO   @movb   dest, src
ifdef (WATCOM or VISUALC)
;	 ASSUME  DS:nothing
        mov     [byte ds:&dest], &src
;	 ASSUME  DS:_TEXT
elseifdef PMODE
        mov     [byte ds:&dest], &src
endif
ENDM

MACRO   @addd   dest, src
ifdef (WATCOM or VISUALC)
;	 ASSUME  DS:nothing
        add     [dword ds:&dest],&src
;	 ASSUME  DS:_TEXT
elseifdef PMODE
        add     [dword ds:&dest], &src
endif
ENDM

MACRO   @addb   dest, src
ifdef (WATCOM or VISUALC)
;	 ASSUME  DS:nothing
        add     [byte ds:&dest],&src
;	 ASSUME  DS:_TEXT
elseifdef PMODE
        add     [byte ds:&dest], &src
endif
ENDM

MACRO   @start_code
; for watcom extender (dos4g / pmode/w)
ifdef (WATCOM or VISUALC)
SEGMENT _TEXT page public use32
	ASSUME	CS:_TEXT, DS:_TEXT, SS:_TEXT

elseifdef PMODE ; for trans pmode..
SEGMENT code32 page public use32
        ASSUME  CS:code32, DS:code32, SS:code32
endif
ENDM

MACRO   @end_code
;ENDS
ENDM

MACRO   @start_data
;ifdef (WATCOM or VISUALC)
;SEGMENT _TEXT page public use32
;elseifdef PMODE
;SEGMENT code32 page public use32
;endif
ENDM

MACRO   @end_data
ENDS
ENDM

MACRO   @biossetgfx mode
ifdef PMODE
        mov     [v86r_ax],&mode
        mov     al,10h
        int     33h
elseifdef WATCOM
        mov     ax,&mode
        int     10h
endif
ENDM

MACRO	@biosgetkey
ifdef PMODE
        mov     [v86r_ah],0
        mov     al,16h
        int     33h
endif
ifdef WATCOM
	xor	ah,ah
	int	16h
endif
ENDM

MACRO   @biosgetkhit
ifdef PMODE
        mov     [v86r_ah],1
        mov     al,16h
        int     33h
endif
ifdef WATCOM
	mov	ah,1
	int	16h
endif
ENDM



MACRO   @rlp reg, what
ifdef PMODE
        mov     &reg, &what
        sub     &reg, [_code32a]
elseifdef WATCOM
        mov     &reg, &what
endif
ENDM

MACRO   @cmul reg, mult
if &mult eq 1
elseif &mult eq 2
        lea     &reg,[&reg*2]
elseif &mult eq 3
        lea     &reg,[&reg*2+&reg]
elseif &mult eq 4
        lea     &reg,[&reg*4]
elseif &mult eq 5
        lea     &reg,[&reg*4+&reg]
elseif &mult eq 6
        lea     &reg,[&reg*2+&reg]
        shl     &reg,1
elseif &mult eq 7
elseif &mult eq 8
        lea     &reg,[&reg*8]
elseif &mult eq 9
        lea     &reg,[&reg*8+&reg]
elseif &mult eq 10
        lea     &reg,[&reg*4+&reg]
        shl     &reg,1
elseif &mult eq 12
        lea     &reg,[&reg*2+&reg]
        shl     &reg,2
elseif &mult eq 14
elseif &mult eq 16
        shl     &reg,4
elseif &mult eq 24
	lea	&reg,[&reg*2+&reg]
	shl	&reg,3
elseif &mult eq 160
        lea     &reg,[&reg*4+&reg]
        shl     &reg,5
elseif &mult eq 320
        lea     &reg,[&reg*4+&reg]
        shl     &reg,6
elseif &mult eq 48
	lea	&reg,[&reg*2+&reg]
	shl	&reg,4
else
	no joha o perkele
endif
ENDM


MACRO   @rdtsc
ifndef VISUALC
	db 0FH,31H
endif
ENDM

MACRO   @wrmsr
ifndef VISUALC
;	 local @X
	db 0Fh,30h
endif
ENDM

MACRO   @cstart
ifndef VISUALC
        mov     ecx,10h
        xor     eax,eax
        xor     edx,edx
        @wrmsr
endif
ENDM

MACRO   @cread
ifndef VISUALC
        @rdtsc
endif
ENDM


; parameters to watcom reg calling convention. (eg cdecl to watcom)
MACRO	@start_proc
	push	ebp
	mov	ebp,esp
	pushad
ifdef VISUALC
	mov	eax,[dword ebp+8]
	mov	edx,[dword ebp+8+4]
	mov	ebx,[dword ebp+8+8]
	mov	ecx,[dword ebp+8+12]
endif
ifndef hoax
error perkele
endif
ENDM

MACRO	@end_proc
hoax = 1
	mov	[esp+28],eax
	popad
	pop	ebp
ENDM

MACRO	@abs	reg
	mov	edx,eax
	sar	edx,31
	xor	eax,edx
	sbb	eax,0
ENDM



