#ifndef _WINDOW_H_
#define _WINDOW_H_

#include <windows.h>

class TWindow {
protected:

public:
  bool created;  
  HWND		hWnd;     	  // Window handle.
  HDC			hDC;          // Device context
	HGLRC		hRC;          // GL Rendering Context
  HINSTANCE	hInstance;  // Application handle.
  bool fullscreen;      // Fullscreen Window flag.
  bool active;		      // Window Active Flag.
  char title[256];
  char keys[256];
  int width;
  int height;
  int bits;

  TWindow(HINSTANCE	hInstance = NULL);
  
  virtual bool create(char* title, int width, int height, int bits, bool fullscreenflag);
  virtual bool show();
  virtual void close();
  virtual void resize();
  virtual bool wndProc(HWND, UINT, WPARAM, LPARAM, bool &);
  virtual void update();
	virtual bool initGL();

};

extern TWindow *WinD;

#endif