/********************************************************************************
Proyecto Jaguar
  Interface de Sonido.
    
  1 - 30/10/00
********************************************************************************/
#include <windows.h>
#include "soundsystem.h"


#ifdef  __SOUNDSYSTEM_USE_MINIFMOD_
  #include "minifmod_file_callbacks.h"
#endif

TSoundSystem::TSoundSystem() {            // Setup
//	log = new TLog("soundsystem.log");
	freq=44100;
}

void TSoundSystem::setup() {            // Setup
  // I'll finish this some day
}

void TSoundSystem::init() {            // Setup
#ifdef __SOUNDSYSTEM_USE_BASS_
  BASS_Init(-1, freq, 0, GetForegroundWindow());
//  log->log("TSoundSystem->Init->BASS_Init returned: %d", BASS_Init(-1, freq, 0, GetForegroundWindow()));
#endif
#ifdef __SOUNDSYSTEM_USE_MINIFMOD_
 	FSOUND_File_SetCallbacks(memopen, memclose, memread, memseek, memtell);
  FSOUND_Init(freq, 1);
#endif
}


int TSoundSystem::load(char *fileName, int type) { // Carga la musica (pero no la reproduce)
  modType=type;
#ifdef __SOUNDSYSTEM_USE_BASS_
  if(modfile||stream) {
    BASS_Stop();
    if(modfile) BASS_MusicFree(modfile);
    if(stream) BASS_StreamFree(stream);
  }
	HRSRC		rec;
	HGLOBAL		handle;
  void *in;


  if((int)fileName<1024) {
  	rec = FindResource(NULL, fileName, RT_RCDATA);
  	handle = LoadResource(NULL, rec);
		
  	in = (void *)LockResource(handle);
    if(modType==TMODTYPE_MODULE) {
      modfile=BASS_MusicLoad(TRUE, (void *)in, 0, 0, BASS_MUSIC_LOOP);
      BASS_Start();
      return (int)modfile;
    } else {
      stream=BASS_StreamCreateFile(TRUE, (void *)in, 0, 0, FALSE);
      BASS_Start();
      return (int)stream;
    }
  } else {
    if(modType==TMODTYPE_MODULE) {
      modfile=BASS_MusicLoad(FALSE, (void *)fileName, 0, 0, FALSE);
      BASS_Start();
      return (int)modfile;
    } else {
      stream=BASS_StreamCreateFile(FALSE, (void *)fileName, 0, 0, FALSE);
  //    log->log("TSoundSystem->Load->BASS_StreamCreateFile returned: %d", stream);
  //    log->log("BASS_Start() returned: %d",BASS_Start());
      BASS_Start();
      return (int)stream;
    }
  }
#endif

#ifdef __SOUNDSYSTEM_USE_MINIFMOD_
  if((int)fileName<1024) 
  	FSOUND_File_SetCallbacks(memopen, memclose, memread, memseek, memtell);
  else
  	FSOUND_File_SetCallbacks(fileopen, fileclose, fileread, fileseek, filetell);
  
  // ignore modType, only XM's allowed in MiniFmod
	mod = FMUSIC_LoadSong(fileName, NULL);

  return 1;
#endif
} 

void TSoundSystem::play() { // Reproduce la musica
#ifdef __SOUNDSYSTEM_USE_BASS_
  if(modType==TMODTYPE_MODULE) {
    BASS_MusicPlay(modfile);
  } else {
    BASS_StreamPlay(stream, TRUE, 0);
  }
#endif
#ifdef __SOUNDSYSTEM_USE_MINIFMOD_
	FMUSIC_PlaySong(mod);
#endif
} 

void TSoundSystem::stop() {             // Para la musica
#ifdef __SOUNDSYSTEM_USE_BASS_
  BASS_Stop();
#endif
#ifdef __SOUNDSYSTEM_USE_MINIFMOD_
	FMUSIC_FreeSong(mod);
#endif
}

void TSoundSystem::getInfo(TSoundInfo *info) {          // Coge informacion del modulo (se hara una estructura)
  // Habra que hacerlo algun dia ;) - Jcl 30/10/00
};

void TSoundSystem::close() {             // Para la musica
  stop();
#ifdef __SOUNDSYSTEM_USE_BASS_
  BASS_Free();
#endif
#ifdef __SOUNDSYSTEM_USE_MINIFMOD_
	FSOUND_Close();
#endif
}

TSoundSystem::~TSoundSystem() {
  close();
//	delete log;
}
