#ifndef _STATEMACHINE_H_
#define _STATEMACHINE_H_


#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

#define MAX_OGL_CAPABILITIES 255

class TGLState {
  static GLuint *stateList;
  static int top;  
  static int maxPositions;
public:
  static void initStatus()
  {
    for (int i = 0; i < MAX_OGL_CAPABILITIES * 2; i+=2) {
      stateList[i] = 0;
    }
    top=0;
  }
  static void enable(GLenum cap)
  {
    bool found = false;
    for (int i = 0; i < top * 2; i += 2)
      if (stateList[i] == cap)
      {
        found = true;
        break;
      }
    if (found && (!stateList[i + 1]))
    {
      stateList[i + 1] = 1;
      glEnable(cap);
    }
    if (!found)
    {
      stateList[top * 2] = cap;
      stateList[(top * 2) + 1] = 1;
      glEnable(cap);
      top = top + 1;
    }
  }

  static void disable(GLenum cap)
  {    
    bool found = false;
    for (int i = 0; i < top * 2; i += 2)
      if (stateList[i] == cap)
      {
        found = true;
        break;
      }
    if (found && stateList[i + 1])
    {
      stateList[i + 1] = 0;
      glDisable(cap);
    }
    if (!found)
    {
      stateList[top * 2] = cap;
      stateList[(top * 2) + 1] = 1;
      glEnable(cap);
      top = top + 1;
    }
  }

};

#endif