#ifndef _SCENEFACTORY_H_
#define _SCENEFACTORY_H_

#include "Scene.h"
#include "List.h"
#include "TextureRepository.h"

//class TDemo;

class TSceneFactory {
  TList<TScene*>*scenes;
  TNode<TScene*>*currentScene;
  TList<TScene*>*runScenes;
public:
  //TDemo *demo;
  TTextureRepository *sharedTextures;
  TScene *otherScene; // next scene that getScene will have been returned. 

  TSceneFactory();

  void setupRunScenes(__int32 time);  
  TScene *getNextOfRunScenes();

  TScene *getScene(char *name);
  void registerScene(TScene *scene);

  TScene *setupScenes(); // return scene failed or NULL if success.
  TScene *setupScenes(int reason); // return scene failed or NULL if success.
  void freeScenes();
};

#endif