#include <stdio.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
  FILE *in;
  FILE *out;
  int ballbitmap [15*15*3+1];
  int counter=0;
  int colormap    [15*15+1];
  int bcfcolormap [15*15+1];
  int bfcolormap  [15*15+1];
  int bcolormap   [15*15+1];

  // open raw data

  in = fopen ("../../includes/BALL.RAW","rb");    // open ball
  while(feof(in)==0) {
      ballbitmap[counter]=fgetc(in);
      counter++;
  }
  counter--;                           // don't count eof-char
  fclose(in);                          // close stream

  //decode colors

  int R,G,B,color;

  for (counter=0;counter<15*15;counter++){
    R=ballbitmap[counter*3];
    G=ballbitmap[counter*3+1];
    B=ballbitmap[counter*3+2];
    // if R,G,B values differ > 15, we assume it's background color.
    if ( abs(R-G)>15 || abs(R-B)>15 || abs(G-B)>15 || (R+G+B==0) ) {
      bcfcolormap[counter]=bfcolormap[counter]=bcolormap[counter]=color=0;
    }//if
    else {
      // now we check what grey value we're dealing with..
      color = int((R+G+B)/256)+1;
    }//else
    colormap[counter]=color;
    // fill colormaps
    bcolormap[counter]=bfcolormap[counter]=bcfcolormap[counter]=0;
    if (color==1) {bcolormap[counter]=1; bfcolormap[counter]=1;}
    if (color!=0) {bcfcolormap[counter]=1;}
    if (color==3) {bfcolormap[counter]=1;}
  }//for

  // write output!
  bcfcolormap [15*15]=0;

  out=fopen("../../sources/balldata.txt","w");
  int shift,row,sprite;
  int nybble,byte;
  for (sprite=0;sprite<3;sprite++){
    if (sprite==1){ for(counter=0;counter<15*15;counter++){bcfcolormap[counter]=bfcolormap[counter];}}
    if (sprite==2){ for(counter=0;counter<15*15;counter++){bcfcolormap[counter]=bcolormap[counter];}}
    for (shift=0;shift<8;shift++){
      fprintf(out,"*=ballsprite%i",sprite+1);
      if(shift==0){fputs("a",out);}
      if(shift==1){fputs("b",out);}
      if(shift==2){fputs("c",out);}
      if(shift==3){fputs("d",out);}
      if(shift==4){fputs("e",out);}
      if(shift==5){fputs("f",out);}
      if(shift==6){fputs("g",out);}
      if(shift==7){fputs("h",out);}
      fputs("\n",out);
      for (row=0;row<15;row++){
        for (byte=0;byte<3;byte++){
          if (byte==0){fputs   ("        .byte (($",out);}
          if (byte==1){fprintf (out,"00>>(%i+16))&255),(($",shift);}
          if (byte==2){fprintf (out,"00>>(%i+8))&255),(($",shift);}
          for (nybble=0;nybble<4;nybble++){
            color=bcfcolormap[row*15+nybble*4]*8+bcfcolormap[row*15+1+nybble*4]*4+bcfcolormap[row*15+2+nybble*4]*2;
            if (nybble!=3) {color+=bcfcolormap[row*15+nybble*4+3];}
            if (color== 0){fputs("0",out);}
            if (color== 1){fputs("1",out);}
            if (color== 2){fputs("2",out);}
            if (color== 3){fputs("3",out);}
            if (color== 4){fputs("4",out);}
            if (color== 5){fputs("5",out);}
            if (color== 6){fputs("6",out);}
            if (color== 7){fputs("7",out);}
            if (color== 8){fputs("8",out);}
            if (color== 9){fputs("9",out);}
            if (color==10){fputs("a",out);}
            if (color==11){fputs("b",out);}
            if (color==12){fputs("c",out);}
            if (color==13){fputs("d",out);}
            if (color==14){fputs("e",out);}
            if (color==15){fputs("f",out);}
          }//for
        }//for
        fprintf (out,"00>>(%i))&255)\n",shift);
      }//for
    }//for
  }//for sprite
  fclose(out);
  return 0;
}
