Code	segment
;------------------------------------------------------------------------------
;(C) Antti Kangas
;Emai: scorpion@phoenix.oulu.fi
;      	        @zombie.oulu.fi
;        gigolo@otitsun.oulu.fi
;-----------------------------------------------------------------------------
INCLUDE		VGADATA1.INC	;Various tables tp quicken routines a bit/lot
INCLUDE		LETTERS.INC	;"Compressed" Data of the font used 
;-----------------------------------------------------------------------------
VGA_SEGMENT	equ	0a000h	;Address of VGA-memory start
SO_INDEX	equ 	03c0h	;Some fucking Index register
SC_INDEX	equ	03c4h	;Sequence Controller Index register
GC_INDEX	equ	03ceh	;Graphics Controller Index register
CRTC_INDEX	equ	03d4h	;CRT Controller Index register 
MAX_SCAN_LINE	equ	9	;Maximum Scan Line reg  -index-  in CRTC
START_ADDRESS_HIGH equ	0ch	;Start Address High reg -index-  in CRTC
START_ADDRESS_LOW  equ	0dh     ;Start Address Low reg  -index-  in CRTC
UNDERLINE	equ	014h	;Underline Location reg -index-  in CRTC
MODE_CONTROL	equ	017h	;Mode Control register  -index-  in CRTC
SCREEN_WIDTH	equ	320	;# of pixels across screen
SCREEN_HEIGHT	equ	400	;# of scan lines on screen
;--------------------------------------------
processpageHI	db 	00h
count		dw	?
addx		dw	?
deltax  	dw    	?		;deltax   (line)
deltay 		dw	?		;deltay   (line)
color		db	?
xmuut		dw	?
teksti		db	'lame simulation v1.0',256 dup (' ')
onko		dw	0000h
rotat		dw	0000h
varit		db	1536 dup (' ')
tmpnum		dw	?
tmpchar		db	6 dup (' '),'$'
multiply	dw	?
xcoord		dw	?
textcount	dw	?
;-------------------------------------
	assume cs:Code
	public Set320by400mode
	public Textmode
	public Putpixel
	public Getpixel
	public Setcolor
	public Rectangle
	public Cline
	public Showpage
	public Procpage
	public Cbar
	public Txy
	public Tpd
	public StartAdd
	public Xpan
	public setRGBpalette
	public RotateRGB
	public fade
SET_STACK	macro
	push bp
	mov bp,sp
	endm
GET_OUT 	macro
	mov sp,bp
	pop bp
	endm
CONSTANT_TO_INDEXED_REGISTER	macro	ADDRESS, INDEX, VALUE
	mov	dx,ADDRESS
	mov	ax,(VALUE shl 8) + INDEX
	out	dx,ax
	endm
;------------------------------------------------------------------------------
Set320By400Mode	proc	near
	mov	ax,0013h  ;AH = 0 means mode set, AL = 13h selects
			; 256-color graphics mode
	int	10h	;BIOS video interrupt
	mov	dx,SC_INDEX
	mov	al,4
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 08h	;turn off chain 4
	or	al,04h		;turn off odd/even
	out	dx,al
	mov	dx,GC_INDEX
	mov	al,5
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 10h	;turn off odd/even
	out	dx,al
	dec	dx
	mov	al,6
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 02h	;turn off chain
	out	dx,al
	CONSTANT_TO_INDEXED_REGISTER SC_INDEX,2,0fh
	mov	ax,VGA_SEGMENT
	mov	es,ax
	sub	di,di
	mov	ax,di
	mov	cx,8000h	;# of words in 64K
	cld
	rep	stosw		;clear all of display memory
	mov	dx,CRTC_INDEX
	mov	al,MAX_SCAN_LINE
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 1fh	;set maximum scan line = 0
	out	dx,al
	dec	dx
	mov	al,UNDERLINE
	out	dx,al
	inc	dx
	in	al,dx
	and	al,not 40h	;turn off doubleword
	out	dx,al
	dec	dx
	mov	al,MODE_CONTROL
	out	dx,al
	inc	dx
	in	al,dx
	or	al,40h	
	out	dx,al   
	ret
Set320By400Mode	endp
;----------------------------------
fade	proc	near
	SET_STACK
	mov	al,[bp+6]
	mov	ah,0	
	mov	dx,3
	mul 	dx
	mov	si,ax
	mov	al,[bp+4]
	mov	ah,0
	mov	dx,3
	mul	dx
	mov	di,ax
	sub 	di,si
	clc
	adc	di,3
uuhaka:	Call	WaitVsync
	mov	al,[bp+6]
	mov	dx,3c8h
	out	dx,al
	mov	dx,3c9h
	push	si
	mov	cx,di
	mov	onko,0
abcd:	mov	al,varit[si]
	out	dx,al
	inc	si
	loop    abcd
	pop	si
	push	si
	mov	cx,di
bcde:	cmp	varit[si],0
	jz	suur
	dec	varit[si]
	dec	onko
suur:	inc	onko
	inc	si
	loop 	bcde
	pop	si
	cmp	onko,di
	jnz	uuhaka
	GET_OUT
	ret 	4
fade	endp
;----------------------------------
rotateRGB	proc	near
	SET_STACK
	mov	ax,[bp+04]
	clc
	add	rotat,ax
	cmp	rotat,768
	jb	eizzz
	sub	rotat,768
eizzz:	mov	si,rotat
	mov	dx,3c8h
	mov	al,1
	out 	dx,al
	Call	WaitVsync
	mov	dx,3c9h
	mov	cx,765
uusiksi:mov	al,varit[si]
	out	dx,al
	inc	si
	loop	uusiksi
	GET_OUT
	ret	2
rotateRGB	endp
;-----------------------------------------------------------------------------
setRGBpalette proc near
	SET_STACK
	;call	WaitVsync
	mov	al,[bp+10]
	mov	ah,0	
	mov	dx,3
	mul 	dx
	mov	si,ax
	mov	al,[bp+10]
	mov	dx,3c8h
	out     dx,al
	mov	dx,3c9h
	mov	al,[bp+08]
	out	dx,al
	mov	varit[si],al
	mov	varit+768[si],al
	mov	al,[bp+06]
	out	dx,al
	mov	varit+1[si],al
	mov	varit+769[si],al
	mov	al,[bp+04]
	out	dx,al
	mov	varit+2[si],al
	mov	varit+770[si],al
	GET_OUT
	ret 8
setRGBpalette endp
;-----------------------------------------------------------------------------
Textmode proc	near
	mov ax,0003h
	int 10h
	mov ah,4ch
	int 21h
	ret
Textmode endp
;----------------------------------------------------------------------------; 	
;Draws a line ( x0,y0,x1,y1,color)
Cline	proc	near
	SET_STACK
	mov	ax,VGA_SEGMENT
	mov	es,ax
	mov 	bl,[bp+04]	;color
	mov 	color,bl
	mov 	si,[bp+12]	;x0
	mov 	di,[bp+10]	;y0
	mov 	cx,[bp+08]	;x1	
	mov 	dx,[bp+06]	;y1
	mov	addx,1
	cmp	dx,di
	jge	eiva
	xchg	si,cx
	xchg	dx,di
eiva:	sub	cx,si
	jge	eile
	neg	cx
	neg	addx	
eile:	mov	deltax,cx
	sub	dx,di
	mov	deltay,dx
	cmp	cx,0
	jnz	eivert
	cmp	dx,0
	jnz	vertical
kikka:	call	dot
	GET_OUT
	ret	10
eivert:	cmp	dx,0
	jz	horizontal
	jmp	eisuora
;------------------------- Draws a horizontal line --------------------
horizontal:
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	ah,planetable[si]
	mov	dx,3c4h		
	out 	dx,ax		
	mov	bh,0
	cmp	addx,1
	jnz	Xdown
HRZ1:	mov     ah,color
	mov	es:[di],ah	
	inc	si
	mov	bl,addXtable[si]
	add 	di,bx
	mov	ah,planetable[si]
	out 	dx,ax
	loop	HRZ1
	GET_OUT
	ret	10
Xdown:	mov     ah,color
	mov	es:[di],ah	
	dec	si
	mov	bl,subXtable[si]
	sub 	di,bx
	mov	ah,planetable[si]
	out 	dx,ax
	loop	Xdown
	GET_OUT
	ret 	10
;-------------------------- Draws a vertical line -----------------------
vertical:	
	mov	cx,dx
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	ah,planetable[si]
	mov	dx,3c4h		
	out 	dx,ax		
	mov     dl,color
VERTL:	mov	es:[di],dl	;draw the pixel
	add	di,80
	loop	VERTL
	GET_OUT
	ret	10
;-------------------------------------------------------------------------
eisuora:cmp	cx,dx
	jg	xbig
	jmp	ybig
;---------------------- Draws a line where DeltaX > DeltaY ---------------
xbig:	
	mov 	bx,0
	mov	count,cx
	mov	cl,rowlotable[di]
	mov	ch,rowhitable[di]
	add	cl,divideby4table[si]
	adc	ch,processpageHI
	mov	di,cx
	mov	al,2
	mov	dx,3c4h
	mov	ch,0
	cmp	addx,1
	jz	Xadd
ldloop:		
	mov	ah,planetable[si]
	out 	dx,ax		
	mov     cl,color
	mov	es:[di],cl	;draw the pixel
	mov	cl,addXtable[si]
	sub	di,cx
	dec	si
	dec	count
	jz 	outta
	add	bx,deltay
	cmp	bx,deltax
	jle	ldloop
	sub	bx,deltax
	add 	di,80
	jmp     ldloop
outta:	GET_OUT
	ret	10
Xadd:		
	mov	ah,planetable[si]
	out 	dx,ax		
	mov     cl,color
	mov	es:[di],cl	;draw the pixel
	inc	si
	mov	cl,addXtable[si]
	add	di,cx
	dec	count
	jz 	outta
	add	bx,deltay
	cmp	bx,deltax
	jle	Xadd
	sub	bx,deltax
	add 	di,80
	jmp     Xadd
;---------------------- Draws a line where DeltaY > DeltaX ----------------
ybig:	
	mov 	bx,0
	mov	count,dx
	mov	cl,rowlotable[di]
	mov	ch,rowhitable[di]
	add	cl,divideby4table[si]
	adc	ch,processpageHI
	mov	di,cx
	mov	al,2
	mov	dx,3c4h
	mov	ch,0
	mov	ah,planetable[si]
	out	dx,ax
	mov	cl,color
	cmp	addx,1
	jz	XaddY
Ydloop:		
	mov	es:[di],cl	;draw the pixel
	add	di,80
	dec	count
	jz 	poistu
	add	bx,deltax
	cmp	bx,deltay
	jle	Ydloop
	sub	bx,deltay
	mov	cl,addXtable[si]
	sub	di,cx
	dec	si
	mov	ah,planetable[si]
	out	dx,ax
	mov	cl,color
	jmp     Ydloop
XaddY:		
	mov	es:[di],cl	;draw the pixel
	add	di,80
	dec	count
	jz 	poistu
	add	bx,deltax
	cmp	bx,deltay
	jle	XaddY
	sub	bx,deltay
	inc	si
	mov	ah,planetable[si]
	out	dx,ax
	mov	cl,addXtable[si]
	add	di,cx
	mov	cl,color
	jmp     XaddY
poistu: GET_OUT
	ret	10
Cline 	endp
;-------- Draws a pixel ------------------------------------------------------
Putpixel 	proc	near
	SET_STACK
	mov	ax,VGA_SEGMENT
	mov 	es,ax
	mov 	bl,[bp+06]
	mov 	bh,[bp+04]
	cmp  	bl,bh
	jz	pois
	mov 	color,bl
	mov 	si,[bp+10]
	mov	di,[bp+08]
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	ah,planetable[si]
	mov	dx,3c4h		
	out 	dx,ax		
	mov     dl,color
	mov	es:[di],dl	;draw the pixel
pois:	GET_OUT
	ret	8
Putpixel	endp
;-----------------------------------------------------------------------------
WaitVSync	proc	near
	mov	dx,03dah
WaitNotVSyncLoop:
	in	al,dx
	and	al,8
	jnz	WaitNotVSyncLoop
WaitVSyncLoop:
	in	al,dx
	and	al,8
	jz	WaitVSyncLoop
	ret
WaitVSync	endp
;---------------------------------------------------------------------------
StartAdd    	proc 	near
	SET_STACK
	mov	si,[bp+04]
	mov	ah,rowhitable[si]
	mov	al,0
	add	ax,START_ADDRESS_HIGH
	mov	dx,CRTC_INDEX
	out 	dx,ax
	mov	ah,rowlotable[si]
	mov	al,0
	add	ax,START_ADDRESS_LOW
	mov	dx,CRTC_INDEX
	out 	dx,ax
	GET_OUT
	ret 	2
StartAdd	endp
;---------------------------------------------------------------
Xpan	proc	near
	SET_STACK
	call	WaitVsync
	mov	ah,[bp+04]
	sal	ah,1
	sal	ah,1
	sal	ah,1
	sal	ah,1
	sal	ah,1
	mov	al,8
	mov	dx,3d4h
	out	dx,ax
	GET_OUT
	ret 2
Xpan	endp
;---------------------------------------------------------------
Showpage	proc	near
	SET_STACK
	mov	ax,[bp+04]
	cmp 	ax,0
	jnz	sivu1
	Call 	WaitVSync
	CONSTANT_TO_INDEXED_REGISTER CRTC_INDEX,START_ADDRESS_HIGH,00h
	jmp ulost
sivu1:	
	Call   WaitVsync
	CONSTANT_TO_INDEXED_REGISTER CRTC_INDEX,START_ADDRESS_HIGH,7dh
ulost:	GET_OUT
	ret	2
Showpage        endp
;-----------------------------------------------------------------------------
Procpage	proc	near
	SET_STACK
	mov	ax,[bp+04]
	cmp	ax,0
	jz	nolla
	mov	ah,7dh
nolla:	mov	processpageHI,ah
	GET_OUT
	ret	2
Procpage	endp
;------------DRAWS A PIXEL IN X=SI,Y=DI,COLOR from variable COLOR--------------
Dot	proc	near
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	ah,planetable[si]
	mov	dx,3c4h		
	out 	dx,ax		
	mov     dl,color
	mov	es:[di],dl	;draw the pixel
	ret
Dot	endp
;------------READS THE PIXEL IN X=SI,Y=DI-------------------------------
Getpixel	proc	near
	SET_STACK
	mov	ax,VGA_SEGMENT
	mov	es,ax
	mov 	si,[bp+06]
	mov	di,[bp+04]
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,4
	mov	ah,readplane[si]
	mov	dx,3ceh		
	out 	dx,ax		
	mov	al,es:[di]
	mov	ah,0
	GET_OUT
	ret	4
Getpixel	endp
;----------------------------------------------------------------------
;Draws a filled bar using a neat cheat if width >8
Cbar	proc	near
	SET_STACK
	mov	ax,VGA_SEGMENT
	mov	es,ax
	mov 	bl,[bp+04]	;color
	mov 	color,bl
	mov 	si,[bp+12]	;x0
	mov 	di,[bp+10]	;y0
	mov 	dx,[bp+08]	;x1	
	mov 	cx,[bp+06]	;y1
	cmp	dx,si
	jge	eixw
	xchg	dx,si
eixw:	cmp	cx,di
	jge	eiyw
	xchg	cx,di
eiyw:	push	dx
	sub	dx,si
	inc	dx
	mov	xmuut,dx
	sub	cx,di
	inc	cx
	cmp	dx,8
	jg	Special
Pikkubar:	
	mov	bx,dx
	pop	dx
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	dx,3c4h
Fuck:	mov	ah,planetable[si]
	out 	dx,ax		
	mov     ah,color
	push	cx
	push	di
Tinyl:	mov	es:[di],ah	
	add 	di,80
	loop	Tinyl	
	pop	di
	inc	si
	mov	ch,0
	mov	cl,addXtable[si]
	add	di,cx
	pop	cx
	dec	bx	
	jnz	Fuck
	GET_OUT
	ret	10
Special:	
	pop	dx
	push 	cx
	push	si
	mov	ah,0
	mov	al,substart[si]
	mov	si,dx
	add	al,subend[si]
	sub	xmuut,ax	
eipas:	mov	al,2
	mov	ah,Pendtable[si]
	mov	bl,rowlotable[di]
	mov	bh,rowhitable[di]
	add	bh,processpageHI
	mov	dh,0
	mov	dl,divideby4table[si]	
	add	dx,bx
	mov	di,dx
	mov	dx,3c4h
	out	dx,ax
	mov     ah,color
Loop1:	mov	es:[di],ah	;draw the pixel
	add	di,80
	loop	Loop1
	pop	si
	mov	ch,0
	mov	cl,divideby4table[si]
	add	cx,bx
	mov	di,cx
	mov	ah,Pstarttable[si]
	out	dx,ax
	pop	cx
	push	cx
	push	di
	mov     ah,color
Loop2:	mov	es:[di],ah	;draw the pixel
	add	di,80
	loop	Loop2
	mov	ah,15
	out	dx,ax
	pop	di
	pop	cx
	mov	si,xmuut
	mov	bl,divideby4table[si]
	mov	ah,color
	mov	dx,di
Xlop1:	
	inc	dx
	push	cx
	mov	di,dx
Ylop1:	mov	es:[di],ah
	add	di,80
	loop	Ylop1
	pop	cx
	dec 	bl
	jnz	Xlop1
	GET_OUT
	ret	10
Cbar	endp
;-----------------------------------------------------------------------------
Setcolor 	proc	near
	SET_STACK
	mov	al,[bp+04]
	mov	color,al
	GET_OUT
	ret
Setcolor	endp
;-----------------------------------------------------------------------------
Rectangle	proc	near
	SET_STACK
	mov	ax,VGA_SEGMENT
	mov	es,ax
	
	mov	dx,[bp+04]
	mov	cx,[bp+06]
	mov	di,[bp+08]
	mov	si,[bp+10]
	cmp	cx,si
	jge	eiRECxw
	xchg	cx,si
eiRECxw:cmp	dx,di
	jge	eiRECyw
	xchg	dx,di
eiRECyw:sub	dx,di
	inc	dx
	mov	deltay,dx
	sub	cx,si
	inc	cx
	mov	deltax,cx
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	dx,3c4h		
	mov	bh,0
REC1:	inc	si
	mov	bl,addXtable[si]
	add 	di,bx
	mov	ah,planetable[si]
	out 	dx,ax
	mov     ah,color
	mov	es:[di],ah	
	loop	REC1
	mov	cx,deltay
	mov	ah,color
REC2:	add	di,80
	mov	es:[di],ah
	loop	REC2
	mov	cx,deltax
REC3:	dec	si
	mov	bl,subXtable[si]
	sub 	di,bx
	mov	ah,planetable[si]
	out 	dx,ax
	mov     ah,color
	mov	es:[di],ah	
	loop	REC3
	mov	cx,deltay
	mov	ah,color
REC4:	sub	di,80
	mov	es:[di],ah
	loop	REC4
	GET_OUT
	ret	8
Rectangle	endp
;-----------------------------------------------------------------------------
;-------- Puts a 16-bit positive integer into the Graphic-Screen 320by400 ----
;-------- Format: Tpd(x0,y0,digit,col:word) ----------------------------------  
Tpd 	proc	near
	SET_STACK
	mov	ax,VGA_SEGMENT
	mov	es,ax			
	mov	ax,[bp+06]
	mov	tmpnum,ax
	mov	cx,4
ag:	mov	ax,tmpnum
	and 	ax,0fh
	add	al,30h
	cmp	al,39h
	jle	asc
	add	al,07h
asc:	mov	si,cx
	mov	tmpchar[si],al
	ror	tmpnum,1
	ror	tmpnum,1
	ror	tmpnum,1
	ror	tmpnum,1
	loop	ag
	mov	al,[bp+04]
	mov	color,al
	mov	si,[bp+10]
	mov	di,[bp+08]
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	ah,planetable[si]
	mov	dx,3c4h		
	out 	dx,ax			;Adjusts plane
	mov	bl,1
	mov	xcoord,si
Kiekka:	mov	bh,0
	mov	si,bx
	mov	cl,tmpchar[si]
	mov	bh,color
	mov	ch,0
	sub	cl,32
	shl	cx,1
	shl	cx,1
	shl	cx,1
	mov	multiply,cx
	mov	si,cx
	mov	ch,0
	test	letterdata[si],128
	jz	lei00
	mov	es:[di],bh
lei00:	test 	letterdata+1[si],128
	jz	lei01
	mov	es:[di+80],bh
lei01:	test 	letterdata+2[si],128
	jz	lei02
	mov	es:[di+160],bh
lei02:	test 	letterdata+3[si],128
	jz	lei03
	mov	es:[di+240],bh
lei03:	test 	letterdata+4[si],128
	jz	lei04
	mov	es:[di+320],bh
lei04:	test 	letterdata+5[si],128
	jz	lei05
	mov	es:[di+400],bh
lei05:	test 	letterdata+6[si],128
	jz	lei06
	mov	es:[di+480],bh
lei06:	mov	si,xcoord
	mov	ah,planetable+1[si]
	mov	cl,addXtable+1[si]
	out	dx,ax
	add	di,cx
	mov	si,multiply
	test	letterdata[si],64
	jz	lei10
	mov	es:[di],bh
lei10:	test 	letterdata+1[si],64
	jz	lei11
	mov	es:[di+80],bh
lei11:	test 	letterdata+2[si],64
	jz	lei12
	mov	es:[di+160],bh
lei12:	test 	letterdata+3[si],64
	jz	lei13
	mov	es:[di+240],bh
lei13:	test 	letterdata+4[si],64
	jz	lei14
	mov	es:[di+320],bh
lei14:	test 	letterdata+5[si],64
	jz	lei15
	mov	es:[di+400],bh
lei15:	test 	letterdata+6[si],64
	jz	lei16
	mov	es:[di+480],bh
lei16:	mov	si,xcoord
	mov	ah,planetable+2[si]
	out	dx,ax
	mov	cl,addXtable+2[si]
	add	di,cx
	mov	si,multiply
	test	letterdata[si],32
	jz	lei20
	mov	es:[di],bh
lei20:	test 	letterdata+1[si],32
	jz	lei21
	mov	es:[di+80],bh
lei21:	test 	letterdata+2[si],32
	jz	lei22
	mov	es:[di+160],bh
lei22:	test 	letterdata+3[si],32
	jz	lei23
	mov	es:[di+240],bh
lei23:	test 	letterdata+4[si],32
	jz	lei24
	mov	es:[di+320],bh
lei24:	test 	letterdata+5[si],32
	jz	lei25
	mov	es:[di+400],bh
lei25:	test 	letterdata+6[si],32
	jz	lei26
	mov	es:[di+480],bh
lei26:	mov	si,xcoord
	mov	ah,planetable+3[si]
	out	dx,ax
	mov	cl,addXtable+3[si]
	add	di,cx
	mov	si,multiply
	test	letterdata[si],16
	jz	lei30
	mov	es:[di],bh
lei30:	test 	letterdata+1[si],16
	jz	lei31
	mov	es:[di+80],bh
lei31:	test 	letterdata+2[si],16
	jz	lei32
	mov	es:[di+160],bh
lei32:	test 	letterdata+3[si],16
	jz	lei33
	mov	es:[di+240],bh
lei33:	test 	letterdata+4[si],16
	jz	lei34
	mov	es:[di+320],bh
lei34:	test 	letterdata+5[si],16
	jz	lei35
	mov	es:[di+400],bh
lei35:	test 	letterdata+6[si],16
	jz	lei36
	mov	es:[di+480],bh
lei36:	mov	si,xcoord
	mov	ah,planetable+4[si]
	out	dx,ax
	mov	cl,addXtable+4[si]
	add	di,cx
	mov	si,multiply
	test	letterdata[si],8
	jz	lei40
	mov	es:[di],bh
lei40:	test 	letterdata+1[si],8
	jz	lei41
	mov	es:[di+80],bh
lei41:	test 	letterdata+2[si],8
	jz	lei42
	mov	es:[di+160],bh
lei42:	test 	letterdata+3[si],8
	jz	lei43
	mov	es:[di+240],bh
lei43:	test 	letterdata+4[si],8
	jz	lei44
	mov	es:[di+320],bh
lei44:	test 	letterdata+5[si],8
	jz	lei45
	mov	es:[di+400],bh
lei45:	test 	letterdata+6[si],8
	jz	lei46
	mov	es:[di+480],bh
lei46:	mov	si,xcoord
	mov	ah,planetable+5[si]
	out	dx,ax
	mov	cl,addXtable+5[si]
	add	di,cx
	mov	si,multiply
	test	letterdata[si],4
	jz	lei50
	mov	es:[di],bh
lei50:	test 	letterdata+1[si],4
	jz	lei51
	mov	es:[di+80],bh
lei51:	test 	letterdata+2[si],4
	jz	lei52
	mov	es:[di+160],bh
lei52:	test 	letterdata+3[si],4
	jz	lei53
	mov	es:[di+240],bh
lei53:	test 	letterdata+4[si],4
	jz	lei54
	mov	es:[di+320],bh
lei54:	test 	letterdata+5[si],4
	jz	lei55
	mov	es:[di+400],bh
lei55:	test 	letterdata+6[si],4
	jz	lei56
	mov	es:[di+480],bh
lei56:	mov	si,xcoord
	mov	ah,planetable+6[si]
	out	dx,ax
	mov	cl,addXtable+6[si]
	add	di,cx
	mov	si,multiply
	test	letterdata[si],2
	jz	lei60
	mov	es:[di],bh
lei60:	test 	letterdata+1[si],2
	jz	lei61
	mov	es:[di+80],bh
lei61:	test 	letterdata+2[si],2
	jz	lei62
	mov	es:[di+160],bh
lei62:	test 	letterdata+3[si],2
	jz	lei63
	mov	es:[di+240],bh
lei63:	test 	letterdata+4[si],2
	jz	lei64
	mov	es:[di+320],bh
lei64:	test 	letterdata+5[si],2
	jz	lei65
	mov	es:[di+400],bh
lei65:	test 	letterdata+6[si],2
	jz	lei66
	mov	es:[di+480],bh
lei66:	mov	si,xcoord
	mov	cl,addXtable+7[si]
	add	cl,addXtable+8[si]
	add 	di,cx
	mov	ah,planetable+8[si]
	out	dx,ax
	add	xcoord,8
	inc	bl
	cmp	bl,4
	jg	Naa
	jmp	Kiekka
Naa:	GET_OUT
	ret	8
Tpd	endp
;-----------------------------------------------------------------------------
;-------- Format: Txy(text:string;x0,y0,col:word) ----------------------------  
Txy	proc	near	
	SET_STACK
	mov	ax,VGA_SEGMENT
	mov	es,ax			
	mov	al,[bp+04]
	mov	color,al
	mov	si,[bp+08]
	mov	di,[bp+06]
	mov	dl,rowlotable[di]
	mov	dh,rowhitable[di]
	add	dl,divideby4table[si]
	adc 	dh,processpageHI
	mov	di,dx
	mov	al,2
	mov	ah,planetable[si]
	mov	dx,3c4h		
	out 	dx,ax			;Adjusts plane
	mov	textcount,0
TextKiekka:
	push	si
	mov	si,textcount
	mov	bl,teksti[si]
	cmp	bl,96
	jl	eipikku
	sub	bl,32
eipikku:pop	si
	mov	bh,0
	sub	bl,32
	shl	bx,1
	shl	bx,1
	shl	bx,1
	mov	ch,0
	mov	cl,color
	test	letterdata[bx],128
	jz	ei00
	mov	es:[di],cl
ei00:	test 	letterdata+1[bx],128
	jz	ei01
	mov	es:[di+80],cl
ei01:	test 	letterdata+2[bx],128
	jz	ei02
	mov	es:[di+160],cl
ei02:	test 	letterdata+3[bx],128
	jz	ei03
	mov	es:[di+240],cl
ei03:	test 	letterdata+4[bx],128
	jz	ei04
	mov	es:[di+320],cl
ei04:	test 	letterdata+5[bx],128
	jz	ei05
	mov	es:[di+400],cl
ei05:	test 	letterdata+6[bx],128
	jz	ei06
	mov	es:[di+480],cl
ei06:	mov	cl,addXtable+1[si]
	add	di,cx
	mov	ah,planetable+1[si]
	out	dx,ax
	mov	cl,color
	test	letterdata[bx],64
	jz	ei10
	mov	es:[di],cl
ei10:	test 	letterdata+1[bx],64
	jz	ei11
	mov	es:[di+80],cl
ei11:	test 	letterdata+2[bx],64
	jz	ei12
	mov	es:[di+160],cl
ei12:	test 	letterdata+3[bx],64
	jz	ei13
	mov	es:[di+240],cl
ei13:	test 	letterdata+4[bx],64
	jz	ei14
	mov	es:[di+320],cl
ei14:	test 	letterdata+5[bx],64
	jz	ei15
	mov	es:[di+400],cl
ei15:	test 	letterdata+6[bx],64
	jz	ei16
	mov	es:[di+480],cl
ei16:	mov	cl,addXtable+2[si]
	add	di,cx
	mov	ah,planetable+2[si]
	out	dx,ax
	mov	cl,color
	test	letterdata[bx],32
	jz	ei20
	mov	es:[di],cl
ei20:	test 	letterdata+1[bx],32
	jz	ei21
	mov	es:[di+80],cl
ei21:	test 	letterdata+2[bx],32
	jz	ei22
	mov	es:[di+160],cl
ei22:	test 	letterdata+3[bx],32
	jz	ei23
	mov	es:[di+240],cl
ei23:	test 	letterdata+4[bx],32
	jz	ei24
	mov	es:[di+320],cl
ei24:	test 	letterdata+5[bx],32
	jz	ei25
	mov	es:[di+400],cl
ei25:	test 	letterdata+6[bx],32
	jz	ei26
	mov	es:[di+480],cl
ei26:	mov	cl,addXtable+3[si]
	add	di,cx
	mov	ah,planetable+3[si]
	out	dx,ax
	mov	cl,color
	test	letterdata[bx],16
	jz	ei30
	mov	es:[di],cl
ei30:	test 	letterdata+1[bx],16
	jz	ei31
	mov	es:[di+80],cl
ei31:	test 	letterdata+2[bx],16
	jz	ei32
	mov	es:[di+160],cl
ei32:	test 	letterdata+3[bx],16
	jz	ei33
	mov	es:[di+240],cl
ei33:	test 	letterdata+4[bx],16
	jz	ei34
	mov	es:[di+320],cl
ei34:	test 	letterdata+5[bx],16
	jz	ei35
	mov	es:[di+400],cl
ei35:	test 	letterdata+6[bx],16
	jz	ei36
	mov	es:[di+480],cl
ei36:	mov	cl,addXtable+4[si]
	add	di,cx
	mov	ah,planetable+4[si]
	out	dx,ax
	mov	cl,color
	test	letterdata[bx],8
	jz	ei40
	mov	es:[di],cl
ei40:	test 	letterdata+1[bx],8
	jz	ei41
	mov	es:[di+80],cl
ei41:	test 	letterdata+2[bx],8
	jz	ei42
	mov	es:[di+160],cl
ei42:	test 	letterdata+3[bx],8 
	jz	ei43
	mov	es:[di+240],cl
ei43:	test 	letterdata+4[bx],8 
	jz	ei44
	mov	es:[di+320],cl
ei44:	test 	letterdata+5[bx],8 
	jz	ei45
	mov	es:[di+400],cl
ei45:	test 	letterdata+6[bx],8 
	jz	ei46
	mov	es:[di+480],cl
ei46:	mov	cl,addXtable+5[si]
	add	di,cx
	mov	ah,planetable+5[si]
	out	dx,ax
	mov	cl,color
	test	letterdata[bx],4
	jz	ei50
	mov	es:[di],cl
ei50:	test 	letterdata+1[bx],4
	jz	ei51
	mov	es:[di+80],cl
ei51:	test 	letterdata+2[bx],4
	jz	ei52
	mov	es:[di+160],cl
ei52:	test 	letterdata+3[bx],4
	jz	ei53
	mov	es:[di+240],cl
ei53:	test 	letterdata+4[bx],4
	jz	ei54
	mov	es:[di+320],cl
ei54:	test 	letterdata+5[bx],4
	jz	ei55
	mov	es:[di+400],cl
ei55:	test 	letterdata+6[bx],4
	jz	ei56
	mov	es:[di+480],cl
ei56:	mov	cl,addXtable+6[si]
	add	di,cx
	mov	ah,planetable+6[si]
	out	dx,ax
	mov	cl,color
	test	letterdata[bx],2
	jz	ei60
	mov	es:[di],cl
ei60:	test 	letterdata+1[bx],2
	jz	ei61
	mov	es:[di+80],cl
ei61:	test 	letterdata+2[bx],2
	jz	ei62
	mov	es:[di+160],cl
ei62:	test 	letterdata+3[bx],2
	jz	ei63
	mov	es:[di+240],cl
ei63:	test 	letterdata+4[bx],2
	jz	ei64
	mov	es:[di+320],cl
ei64:	test 	letterdata+5[bx],2
	jz	ei65
	mov	es:[di+400],cl
ei65:	test 	letterdata+6[bx],2
	jz	ei66
	mov	es:[di+480],cl
ei66:	mov	cl,addXtable+7[si]
	add	cl,addXtable+8[si]
	add 	di,cx
	mov	ah,planetable+8[si]
	out	dx,ax
	add	si,8
	inc	textcount
	cmp	textcount,20
	jge	txtNaa
	jmp	TextKiekka
txtNaa:	GET_OUT
	ret	6
Txy	endp
;-----------------------------------------------------------------------------
Code 	ends
end