
/*
 *      Gouraud filler
 *
 *      This source is part of the fatmap2.txt document by
 *      Mats Byggmastar, mri@penti.sit.fi
 *      17.4.1997 Jakobstad, Finland
 *
 *      Companies with self respect are encouraged to contact me if
 *      any of this code is to be used as part of a commercial product.
 *
 *		modified by memon
 *		- added dithering
 *		- added nx buffer rendering
 */

#include "render.h"
#include "gouraud.h"


extern  char*   outBuffer;
extern  char*   nzBuffer;
extern  char*   trBuffer;
extern  int     bufferWidth, bufferHeight;


static c_DVERTEX * max_vtx;                   // Max y vertex (ending vertex)
static c_DVERTEX * start_vtx, * end_vtx;      // First and last vertex in array
static c_DVERTEX * right_vtx, * left_vtx;     // Current right and left vertex

static long right_height, left_height;
static long right_x, right_dxdy, left_x, left_dxdy;

static long left_i, left_didy;
static long didx_frac, didx_whole, _didx;

static long left_nz, left_dnzdy;
static long dnzdx_frac, dnzdx_whole, _dnzdx;


inline long fxCeil(long x)
{
    x +=  0xffff;
    return (x >> 16);
}


long imul16(long x, long y)        // (x * y) >> 16
{
	long retVal;
	__asm {
		mov	eax, x
		mov edx, y
		imul edx
		shrd eax, edx, 16
		mov retVal, eax
	}
	return retVal;
}


void inner_i(char * dst, int width, long i)
{
	__asm {
		mov edi, dst
		mov ecx, width
		mov eax, i

		push  ebp
		mov   edx, eax
		add   eax, 8000h
		rol   eax, 16
		rol   edx, 16
		mov   bl, al
		mov   bh, dl
		mov   esi, [_didx]
		shl   esi, 16
		mov   dl, byte ptr [_didx+2]
		lea   edi, [edi+ecx]
		xor   ecx, -1
		inc   ecx
	next:
		mov   [edi+ecx], bl
		add   eax, esi
		adc   bl, dl
		inc   ecx
		jz    end
		mov   [edi+ecx], bh
		add   edx, esi
		adc   bh, dl
		inc   ecx
		jnz   next
	end:
		pop   ebp
	}
}


void
inner_nz(void * dst, int width, long nz)
{
	unsigned short* d = (unsigned short*)dst;
	do {
		*d++ = nz >> 16;
		nz += _dnzdx;
	} while( --width );
/*
	__asm {
		mov edi, dst
		mov ecx, width
		mov ebx, nz

		rol   ebx, 16
		mov   edx, [dnzdx_frac]
		mov   al, bl
		mov   ah, byte ptr [dnzdx_whole]
	next:
		mov   [edi], al
		add   ebx, edx
		adc   al, ah
//		inc   edi
		add   edi, 2
		dec   ecx
		jnz   next
	}
*/
}


static
void
RightSection( void )
{
    // Walk backwards trough the vertex array

    c_DVERTEX * v2, * v1 = right_vtx;
    if(right_vtx > start_vtx) v2 = right_vtx-1;     
    else                      v2 = end_vtx;         // Wrap to end of array
    right_vtx = v2;

    // v1 = top vertex
    // v2 = bottom vertex 

    // Calculate number of scanlines in this section

    right_height = fxCeil(v2->y) - fxCeil(v1->y);
    if(right_height <= 0) return;

	float invHeight = 65536.0f / (float)(v2->y - v1->y);
    long height = v2->y - v1->y;
    right_dxdy  = (long)((float)(v2->x - v1->x) * invHeight);

    // Prestep initial values

    long prestep = (fxCeil(v1->y) << 16) - v1->y;
    right_x = v1->x + imul16(prestep, right_dxdy);
}

static
void
LeftSection( void )
{
    // Walk forward trough the vertex array

    c_DVERTEX * v2, * v1 = left_vtx;
    if(left_vtx < end_vtx) v2 = left_vtx+1;
    else                   v2 = start_vtx;      // Wrap to start of array
    left_vtx = v2;

    // v1 = top vertex
    // v2 = bottom vertex 

    // Calculate number of scanlines in this section

    left_height = fxCeil(v2->y) - fxCeil(v1->y);
    if(left_height <= 0) return;

	float invHeight = 65536.0f / (float)(v2->y - v1->y);
    left_dxdy = (float)(v2->x - v1->x) * invHeight;
    left_didy = (float)(v2->i - v1->i) * invHeight;
    left_dnzdy = (float)(v2->nz - v1->nz) * invHeight;
    // Prestep initial values

    long prestep = (fxCeil(v1->y) << 16) - v1->y;
    left_x = v1->x + imul16(prestep, left_dxdy);
    left_i = v1->i + imul16(prestep, left_didy);
    left_nz = v1->nz + imul16(prestep, left_dnzdy);
}


void DrawGouraudPoly(c_DVERTEX * vtx, int vertices, long didx, long dnzdx)
{
    start_vtx = vtx;        // First vertex in array

    // Search trough the vtx array to find min y, max y
    // and the location of these structures.

    c_DVERTEX * min_vtx = vtx;
    max_vtx = vtx;

    long min_y = vtx->y;
    long max_y = vtx->y;

    vtx++;

    for(int n=1; n<vertices; n++) {
        if(vtx->y < min_y) {
            min_y = vtx->y;
            min_vtx = vtx;
        }
        else
        if(vtx->y > max_y) {
            max_y = vtx->y;
            max_vtx = vtx;
        }
        vtx++;
    }

    // OK, now we know where in the array we should start and
    // where to end while scanning the edges of the polygon

    left_vtx  = min_vtx;    // Left side starting vertex
    right_vtx = min_vtx;    // Right side starting vertex
    end_vtx   = vtx-1;      // Last vertex in array

    // Search for the first usable right section

    do {
        if(right_vtx == max_vtx) return;
        RightSection();
    } while(right_height <= 0);

    // Search for the first usable left section

    do {
        if(left_vtx == max_vtx) return;
        LeftSection();
    } while(left_height <= 0);

    char*  destptr_i = outBuffer + fxCeil(min_y) * bufferWidth;
//    char*  destptr_nz = nzBuffer + fxCeil(min_y) * bufferWidth;
    short*  destptr_nz = ((short*)nzBuffer) + fxCeil(min_y) * bufferWidth;

    _didx = didx * 2;

    didx_frac  = didx << 16;
    didx_whole = didx >> 16;

    dnzdx_frac  = dnzdx << 16;
    dnzdx_whole = dnzdx >> 16;

	_dnzdx = dnzdx;

    for ( ; ; )
    {
        long x1 = fxCeil(left_x);
        long width = fxCeil(right_x) - x1;

        if ( width > 0 ) {

            // Prestep
            long prestep = (x1 << 16) - left_x;
            long i = left_i + imul16( prestep, didx );
            long nz = left_nz + imul16( prestep, dnzdx );

            inner_i( destptr_i + x1, width, i );
            inner_nz( destptr_nz + x1, width, nz );
        }

        destptr_i  += bufferWidth;
        destptr_nz += bufferWidth;

        // Scan the right side

        if(--right_height <= 0) {               // End of this section?
            do {
                if(right_vtx == max_vtx) return;
                RightSection();
            } while(right_height <= 0);
        }
        else 
            right_x += right_dxdy;

        // Scan the left side

        if(--left_height <= 0) {                // End of this section?
            do {
                if(left_vtx == max_vtx) return;
                LeftSection();
            } while(left_height <= 0);
        }
        else {
            left_x += left_dxdy;
            left_i += left_didy;
            left_nz += left_dnzdy;
        }
    }
}

