
void
smoothMoreInner( unsigned short* src, int width )
{
	int w = width;
	while( --width ) {
		int	a = (int)(*src) * 4;
		a += (int)*(src - w);
		a += (int)*(src - 1);
		a += (int)*(src + 1);
		a += (int)*(src + w);
		a >>= 3;
		*src = a;
		src++;
	}
}

void
smoothMore( int width, int height, char* buffer )
{
  unsigned short*  bptr;
  
  bptr = (unsigned short*)buffer + width + 1;

  for ( int i = 1; i < (height - 1); i++ ) {
    smoothMoreInner( bptr, width );
    bptr += width;
  }
}



void
edgeInner( unsigned short* src, char* dst, int width )
{
	int w = width;
	while( --width ) {
		int	a = (int)(*src) * 8;
		a -= (int)*(src - w - 1);
		a -= (int)*(src - w);
		a -= (int)*(src - w + 1);
		a -= (int)*(src - 1);
		a -= (int)*(src + 1);
		a -= (int)*(src + w - 1);
		a -= (int)*(src + w);
		a -= (int)*(src + w + 1);
		if( a < 0 ) a = -a;
		a >>= 9;
		if( a > 15 ) a = 15;
		a &= 0xe;
		*dst = (char)(unsigned char)a;
		src++;
		dst++;
	}
}

void
edge( int width, int height, char* buffer, char* out )
{
  unsigned short*  bptr;
  char*  optr;
  
  bptr = (unsigned short*)buffer + width + 1;
  optr = out + width + 1;

  for ( int i = 1; i < (height - 1); i++ ) {
    edgeInner( bptr, optr, width );
    bptr += width;
    optr += width;
  }
}
