//----------------------------------------------------------------------------
// These classes handle the VGA card in mode 13h (320x200, 256 colors).
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// TYPE  scr_xy_t
//----------------------------------------------------------------------------
// Defines a point in screen coordinates.  Used by WIN_poly ().
//----------------------------------------------------------------------------

typedef struct
{
   int             x;
   int             y;
}
scr_xy_t;

typedef scr_xy_t *    scr_xy_p_t;
typedef scr_xy_p_t *  scr_xy_p_p_t;

//----------------------------------------------------------------------------
// CLASS  vga_t
//----------------------------------------------------------------------------

class              vga_t
{
public:

   // Check to see if there is a VGA display adapter.  Returns true if there
   // is, false if there isn't.

   boolean         exists ( void );

   // Save the current video mode and switch to mode 13h.

   void            start  ( void );

   // Restore the previous video mode.

   void            end    ( void );

   // Fill the entire screen buffer with the given color.

   void            clear  ( int color );

   // Copy the drawing buffer into screen memory.

   void            update ( void );
};

//----------------------------------------------------------------------------
// CLASS  win_t
//----------------------------------------------------------------------------
// This class defines a rectangular region of the screen into which drawings
// will be clipped.  Drawing occurs on the left and top edges, but not on the
// right or bottom edges.
//----------------------------------------------------------------------------

class              win_t
{
public:

   int             x1;    /* Left   */
   int             y1;    /* Top    */
   int             x2;    /* Right  */
   int             y2;    /* Bottom */

   //-------------------------------------------------------------------------
   // Resize the clipping window to the given coordinates.
   //-------------------------------------------------------------------------

   void            resize ( int x1, int y1, int x2, int y2 );

   //-------------------------------------------------------------------------
   // Fill the window with the given color.
   //-------------------------------------------------------------------------

   void            clear  ( int color );

   //-------------------------------------------------------------------------
   // Draw a point.
   //-------------------------------------------------------------------------

   void            point  ( int x, int y, int color );

   //-------------------------------------------------------------------------
   // Draw a line.
   //-------------------------------------------------------------------------

   void            line   ( int x1, int y1, int x2, int y2, int color );

   //-------------------------------------------------------------------------
   // Draw a filled rectangle.
   //-------------------------------------------------------------------------

   void            rect
   (
      int          x1,
      int          y1,
      int          x2,
      int          y2,
      int          color
   );

   //-------------------------------------------------------------------------
   // Draw a filled convex polygon.  Points must be listed in clockwise order.
   //-------------------------------------------------------------------------

   void            convex_poly
   (
      int          nr_points,
      scr_xy_p_t   point_list,
      int          color
   );

   //-------------------------------------------------------------------------
   // Draw a filled vertical trapezoid.
   //-------------------------------------------------------------------------

   void            v_trapezoid
   (
      int          x1,
      int          y1_t,
      int          y1_b,
      int          x2,
      int          y2_t,
      int          y2_b,
      int          color
   );
};

//----------------------------------------------------------------------------

extern vga_t       vga;
