;             Ss.
; ----- SSS -----cp850-
;             ~S
;   .s'~ ^~s.           .s'~ ^~s.
;  .SS       'SS.        .SS       'SS.
;  SSS  ----  :SS  ----  SSS  ----  :SS
;  S".      .SSS        SSS.      ."S
;      s.   .sSS'        'SSs.   .s
;       "*sS*            *Ss*"  Ss.
; .sS.        .s~^    ^~s.       .SSS
;  SSs.    .s"  .   ^~s. "s.    .sSS'
;    '*Ss*"  sS       'SS. "*sS*'
;             SSS  ----  :SS
;             SSS.      .SSS
; --- SSS s.   .sSS' -rac^dug-
;             "S  "*sS*

      DOSSEG              ;assembler directives for .com linking, in particular
     .286                 ;this means that the screen output is the program
     .MODEL tiny          ;itself. See the respective macro ClearPalBios for
     .CODE                ;for this particular detail.
      ORG 100h

     INCLUDE mode13h.asm
     INCLUDE clearpal.asm
     INCLUDE text.asm
     INCLUDE colcycle.asm
     INCLUDE retrace.asm
     INCLUDE textmode.asm
     INCLUDE terminat.asm

     NumColors   = 30h
     NumRows     = 19h
     NumColumns  = 28h
     PaletteStep = 08h
     SkipMode    = 01h
     KeyPort     = 60h

Main:
     Mode13h              ;destroys ax
     ClearPalBios         ;destroys ax, bx, cx, dx (bx, cx, dx set to 00h)
     
     CreateText NumRows NumColumns PaletteStep SkipMode

     xor  ax, ax          ;contains the palette index to start with
ColorCycling:             ;color cycling loop starts here
     ColorCycle NumColors ;destroys cx, dx

     push ax
     WaitRetrace          ;destroys al, dx
     in   al, KeyPort     ;read keyboard,
     dec  al              ;if escape (scancode 1) is pressed,
     je   Termination     ;then terminate
     pop  ax

     inc  ax              ;increment palette starting index
     jmp  ColorCycling
Termination:
     Textmode             ;destroys ax
     Terminate

     END Main
