/*

	Math Library

	M3D_math.c

*/

#include "M3D_math.h"


float	*M3Dsin;
float	*M3Dcos;

/*

	General routines

*/

int		init_math (void)
{
	int		i;
	
	if ((M3Dsin = (float *)malloc(3600 * sizeof(float))) == NULL) {
		printf("Out of Memory! (math)\n");
		return (0);
	}
	if ((M3Dcos = (float *)malloc(3600 * sizeof(float))) == NULL) {
		printf("Out of Memory! (math)\n");
		return (0);
	}
	
	for (i = 0; i < 3600; i ++) {
		M3Dsin[i] = (float)sin(((float)i * 3.141528) / 1800);
		M3Dcos[i] = (float)cos(((float)i * 3.141528) / 1800);
	}
	
	return 1;
}


float	fsin (int a)
{
	while (a > 3600) a -= 3600;
	while (a < 0) a += 3600;
	
	return (M3Dsin[a]);
}


float	fcos (int a)
{
	while (a > 3600) a -= 3600;
	while (a < 0) a += 3600;
	
	return (M3Dcos[a]);
}


/*

	Matrix operations

*/

void	init_matrix (M3Dmatrix matrix)
{

	matrix[0][0] = 1.0; matrix[0][1] = 0.0; matrix[0][2] = 0.0; matrix[0][3] = 0.0; 
	matrix[1][0] = 0.0; matrix[1][1] = 1.0; matrix[1][2] = 0.0; matrix[1][3] = 0.0; 
	matrix[2][0] = 0.0; matrix[2][1] = 0.0; matrix[2][2] = 1.0; matrix[2][3] = 0.0; 
	matrix[3][0] = 0.0; matrix[3][1] = 0.0; matrix[3][2] = 0.0; matrix[3][3] = 1.0; 

}

void	copy_matrix (M3Dmatrix dest, M3Dmatrix source)
{

	memcpy(dest, source, sizeof(M3Dmatrix));

}

/*
void	mult_matrix_matrix (M3Dmatrix mat1, M3Dmatrix mat2, M3Dmatrix result)
{

	result[0][0] = mat1[0][0]*mat2[0][0] + mat1[0][1]*mat2[1][0] + mat1[0][2]*mat2[2][0] + mat1[0][3]*mat2[3][0];
	result[0][1] = mat1[0][0]*mat2[0][1] + mat1[0][1]*mat2[1][1] + mat1[0][2]*mat2[2][1] + mat1[0][3]*mat2[3][1];
	result[0][2] = mat1[0][0]*mat2[0][2] + mat1[0][1]*mat2[1][2] + mat1[0][2]*mat2[2][2] + mat1[0][3]*mat2[3][2];
	result[0][3] = mat1[0][0]*mat2[0][3] + mat1[0][1]*mat2[1][3] + mat1[0][2]*mat2[2][3] + mat1[0][3]*mat2[3][3];

	result[1][0] = mat1[1][0]*mat2[0][0] + mat1[1][1]*mat2[1][0] + mat1[1][2]*mat2[2][0] + mat1[1][3]*mat2[3][0];
	result[1][1] = mat1[1][0]*mat2[0][1] + mat1[1][1]*mat2[1][1] + mat1[1][2]*mat2[2][1] + mat1[1][3]*mat2[3][1];
	result[1][2] = mat1[1][0]*mat2[0][2] + mat1[1][1]*mat2[1][2] + mat1[1][2]*mat2[2][2] + mat1[1][3]*mat2[3][2];
	result[1][3] = mat1[1][0]*mat2[0][3] + mat1[1][1]*mat2[1][3] + mat1[1][2]*mat2[2][3] + mat1[1][3]*mat2[3][3];

	result[2][0] = mat1[2][0]*mat2[0][0] + mat1[2][1]*mat2[1][0] + mat1[2][2]*mat2[2][0] + mat1[2][3]*mat2[3][0];
	result[2][1] = mat1[2][0]*mat2[0][1] + mat1[2][1]*mat2[1][1] + mat1[2][2]*mat2[2][1] + mat1[2][3]*mat2[3][1];
	result[2][2] = mat1[2][0]*mat2[0][2] + mat1[2][1]*mat2[1][2] + mat1[2][2]*mat2[2][2] + mat1[2][3]*mat2[3][2];
	result[2][3] = mat1[2][0]*mat2[0][3] + mat1[2][1]*mat2[1][3] + mat1[2][2]*mat2[2][3] + mat1[2][3]*mat2[3][3];

	result[3][0] = mat1[3][0]*mat2[0][0] + mat1[3][1]*mat2[1][0] + mat1[3][2]*mat2[2][0] + mat1[3][3]*mat2[3][0];
	result[3][1] = mat1[3][0]*mat2[0][1] + mat1[3][1]*mat2[1][1] + mat1[3][2]*mat2[2][1] + mat1[3][3]*mat2[3][1];
	result[3][2] = mat1[3][0]*mat2[0][2] + mat1[3][1]*mat2[1][2] + mat1[3][2]*mat2[2][2] + mat1[3][3]*mat2[3][2];
	result[3][3] = mat1[3][0]*mat2[0][3] + mat1[3][1]*mat2[1][3] + mat1[3][2]*mat2[2][3] + mat1[3][3]*mat2[3][3];

}
*/

void	translate (M3Dmatrix matrix, float x, float y, float z)
{

	M3Dmatrix	tmatrix;
	M3Dmatrix	matrix1;

	tmatrix[0][0] = 1.0; tmatrix[0][1] = 0.0; tmatrix[0][2] = 0.0; tmatrix[0][3] = 0.0; 
	tmatrix[1][0] = 0.0; tmatrix[1][1] = 1.0; tmatrix[1][2] = 0.0; tmatrix[1][3] = 0.0; 
	tmatrix[2][0] = 0.0; tmatrix[2][1] = 0.0; tmatrix[2][2] = 1.0; tmatrix[2][3] = 0.0; 
	tmatrix[3][0] = x  ; tmatrix[3][1] = y  ; tmatrix[3][2] = z  ; tmatrix[3][3] = 1.0; 

	mult_matrix_matrix(matrix, tmatrix, matrix1);
	copy_matrix(matrix, matrix1);

}


void	scale (M3Dmatrix matrix, float s)
{

	M3Dmatrix	smatrix;
	M3Dmatrix	matrix1;

	smatrix[0][0] = s  ; smatrix[0][1] = 0.0; smatrix[0][2] = 0.0; smatrix[0][3] = 0.0; 
	smatrix[1][0] = 0.0; smatrix[1][1] = s  ; smatrix[1][2] = 0.0; smatrix[1][3] = 0.0; 
	smatrix[2][0] = 0.0; smatrix[2][1] = 0.0; smatrix[2][2] = s  ; smatrix[2][3] = 0.0; 
	smatrix[3][0] = 0.0; smatrix[3][1] = 0.0; smatrix[3][2] = 0.0; smatrix[3][3] = 1.0; 

	mult_matrix_matrix(matrix, smatrix, matrix1);
	copy_matrix(matrix, matrix1);

}


void	rotate_XYZ (M3Dmatrix matrix, int x, int y, int z)
{

	M3Dmatrix	xmatrix, ymatrix, zmatrix, matrix1, matrix2;
	float	sinx, siny, sinz, cosx, cosy, cosz;

	sinx = fsin(x);
	siny = fsin(y);
	sinz = fsin(z);
	cosx = fcos(x);
	cosy = fcos(y);
	cosz = fcos(z);

	xmatrix[0][0] = 1.0; xmatrix[0][1] = 0.0;  xmatrix[0][2] = 0.0;  xmatrix[0][3] = 0.0; 
	xmatrix[1][0] = 0.0; xmatrix[1][1] = cosx; xmatrix[1][2] =-sinx; xmatrix[1][3] = 0.0; 
	xmatrix[2][0] = 0.0; xmatrix[2][1] = sinx; xmatrix[2][2] = cosx; xmatrix[2][3] = 0.0; 
	xmatrix[3][0] = 0.0; xmatrix[3][1] = 0.0;  xmatrix[3][2] = 0.0;  xmatrix[3][3] = 1.0; 

	ymatrix[0][0] = cosy; ymatrix[0][1] = 0.0; ymatrix[0][2] = siny; ymatrix[0][3] = 0.0; 
	ymatrix[1][0] = 0.0;  ymatrix[1][1] = 1.0; ymatrix[1][2] = 0.0;  ymatrix[1][3] = 0.0; 
	ymatrix[2][0] =-siny; ymatrix[2][1] = 0.0; ymatrix[2][2] = cosy; ymatrix[2][3] = 0.0; 
	ymatrix[3][0] = 0.0;  ymatrix[3][1] = 0.0; ymatrix[3][2] = 0.0;  ymatrix[3][3] = 1.0; 

	zmatrix[0][0] = cosz; zmatrix[0][1] =-sinz; zmatrix[0][2] = 0.0; zmatrix[0][3] = 0.0; 
	zmatrix[1][0] = sinz; zmatrix[1][1] = cosz; zmatrix[1][2] = 0.0; zmatrix[1][3] = 0.0; 
	zmatrix[2][0] = 0.0;  zmatrix[2][1] = 0.0;  zmatrix[2][2] = 1.0; zmatrix[2][3] = 0.0; 
	zmatrix[3][0] = 0.0;  zmatrix[3][1] = 0.0;  zmatrix[3][2] = 0.0; zmatrix[3][3] = 1.0; 

	mult_matrix_matrix(matrix,  xmatrix, matrix1);
	mult_matrix_matrix(matrix1, ymatrix, matrix2);
	mult_matrix_matrix(matrix2, zmatrix, matrix);

}


void	rotate_YXZ (M3Dmatrix matrix, int x, int y, int z)
{

	M3Dmatrix	xmatrix, ymatrix, zmatrix, matrix1, matrix2;
	float	sinx, siny, sinz, cosx, cosy, cosz;

	sinx = fsin(x);
	siny = fsin(y);
	sinz = fsin(z);
	cosx = fcos(x);
	cosy = fcos(y);
	cosz = fcos(z);

	xmatrix[0][0] = 1.0; xmatrix[0][1] = 0.0;  xmatrix[0][2] = 0.0;  xmatrix[0][3] = 0.0; 
	xmatrix[1][0] = 0.0; xmatrix[1][1] = cosx; xmatrix[1][2] =-sinx; xmatrix[1][3] = 0.0; 
	xmatrix[2][0] = 0.0; xmatrix[2][1] = sinx; xmatrix[2][2] = cosx; xmatrix[2][3] = 0.0; 
	xmatrix[3][0] = 0.0; xmatrix[3][1] = 0.0;  xmatrix[3][2] = 0.0;  xmatrix[3][3] = 1.0; 

	ymatrix[0][0] = cosy; ymatrix[0][1] = 0.0; ymatrix[0][2] = siny; ymatrix[0][3] = 0.0; 
	ymatrix[1][0] = 0.0;  ymatrix[1][1] = 1.0; ymatrix[1][2] = 0.0;  ymatrix[1][3] = 0.0; 
	ymatrix[2][0] =-siny; ymatrix[2][1] = 0.0; ymatrix[2][2] = cosy; ymatrix[2][3] = 0.0; 
	ymatrix[3][0] = 0.0;  ymatrix[3][1] = 0.0; ymatrix[3][2] = 0.0;  ymatrix[3][3] = 1.0; 

	zmatrix[0][0] = cosz; zmatrix[0][1] =-sinz; zmatrix[0][2] = 0.0; zmatrix[0][3] = 0.0; 
	zmatrix[1][0] = sinz; zmatrix[1][1] = cosz; zmatrix[1][2] = 0.0; zmatrix[1][3] = 0.0; 
	zmatrix[2][0] = 0.0;  zmatrix[2][1] = 0.0;  zmatrix[2][2] = 1.0; zmatrix[2][3] = 0.0; 
	zmatrix[3][0] = 0.0;  zmatrix[3][1] = 0.0;  zmatrix[3][2] = 0.0; zmatrix[3][3] = 1.0; 

	mult_matrix_matrix(matrix,  ymatrix, matrix1);
	mult_matrix_matrix(matrix1, xmatrix, matrix2);
	mult_matrix_matrix(matrix2, zmatrix, matrix);

}


/*

	Vector operations

*/

void	vector_copy (M3Dvector *dest, M3Dvector *source)
{
	memcpy(dest, source, sizeof(M3Dvector));
}


float	vector_dot (M3Dvector *a, M3Dvector *b)
{
	return (a->x * b->x + a->y * b->y + a->z * b->z);
}


float	vector_distance (M3Dvector *a, M3Dvector *b)
{

	float	xd, yd, zd;
	
	xd = a->x - b->x;
	yd = a->y - b->y;
	zd = a->z - b->z;

	return (float)(sqrt(xd*xd + yd*yd + zd*zd));

}


float	vector_magnitude (M3Dvector *a)
{
	return (float)(sqrt(a->x*a->x + a->y*a->y + a->z*a->z));
}


#define	MED_CONST	(11/32)
#define	MIN_CONST	(1/4)
float	approx_vector_magnitude (M3Dvector *a)
{
	float	maxc, medc, minc, tmp;
	
	maxc = fabs(a->x);
	medc = fabs(a->y);
	minc = fabs(a->z);
	
	if (maxc < medc) {
		tmp = medc;
		medc = maxc;
		maxc = tmp;
	}
	if (maxc < minc) {
		tmp = minc;
		minc = maxc;
		maxc = tmp;
	}
	if (medc < minc) {
		tmp = minc;
		minc = medc;
		medc = tmp;
	}
	
	return (maxc + medc * MED_CONST + minc * MIN_CONST);
}


void	vector_add (M3Dvector *a, M3Dvector *b, M3Dvector *result)
{
	result->x = a->x + b->x;
	result->y = a->y + b->y;
	result->z = a->z + b->z;
}


void	vector_sub (M3Dvector *a, M3Dvector *b, M3Dvector *result)
{
	result->x = a->x - b->x;
	result->y = a->y - b->y;
	result->z = a->z - b->z;
}


void	vector_normalize (M3Dvector *a)
{
	float	mag, ratio;
	
	mag = vector_magnitude(a);
	
	if (mag == 0)
		return;
		
	ratio = 1/mag;

	a->x *= ratio;
	a->y *= ratio;
	a->z *= ratio;
}


void	approx_vector_normalize (M3Dvector *a)
{
	float	mag, ratio;
	
	mag = approx_vector_magnitude(a);
	
	if (mag == 0)
		return;
		
	ratio = 1/mag;

	a->x *= ratio;
	a->y *= ratio;
	a->z *= ratio;
}


void	vector_cross (M3Dvector *a, M3Dvector *b, M3Dvector *result)
{

	float	x1, y1, z1;
	float	x2, y2, z2;
	
	x1 = a->x;
	y1 = a->y;
	z1 = a->z;

	x2 = b->x;
	y2 = b->y;
	z2 = b->z;

	result->x = y1 * z2 - z1 * y2;
	result->y = z1 * x2 - x1 * z2;
	result->z = x1 * y2 - y1 * x2;
}
