/*

	3D Studio Loader

	M3D_3Dsl.c
*/

/* This code is based on Javier Arevalo's source (3dsrdr12.c). */

#include "M3D_3DSl.h"


/*

	Load .3DS file

*/

char	*name;
char	tmp_name[20];
int		tmp_num_vertices;
int		tmp_num_polys;
int		last_chunk;
float	Rf, Gf, Bf;
unsigned char	Rb, Gb, Bb;

#pragma pack(2)

typedef struct {
	unsigned short	id;
	unsigned long	len;
} t_chunk_header, *p_chunk_header;

#pragma pack()

enum {
	CHUNK_RGBF      = 0x0010,
	CHUNK_RGBB      = 0x0011,
	CHUNK_PRCI		= 0x0030,
	CHUNK_PRCF		= 0x0031,

	CHUNK_PRJ       = 0xC23D,
	CHUNK_MLI       = 0x3DAA,

	CHUNK_MAIN		= 0x4D4D,
		CHUNK_OBJMESH		= 0x3D3D,
			CHUNK_BKGCOLOR		= 0x1200,
			CHUNK_AMBCOLOR		= 0x2100,
			CHUNK_OBJBLOCK		= 0x4000,
				CHUNK_TRIMESH		= 0x4100,
					CHUNK_VERTLIST		= 0x4110,
					CHUNK_FACELIST		= 0x4120,
					CHUNK_FACEMAT		= 0x4130,
					CHUNK_MAPLIST		= 0x4140,
					CHUNK_SMOOLIST		= 0x4150,
					CHUNK_TRMATRIX		= 0x4160,
				CHUNK_LIGHT			= 0x4600,
					CHUNK_SPOTLIGHT		= 0x4610,
				CHUNK_CAMERA		= 0x4700,
				CHUNK_HIERARCHY		= 0x4F00,
		CHUNK_VIEWPORT		= 0x7001,
		CHUNK_MATERIAL		= 0xAFFF,
			CHUNK_MATNAME		= 0xA000,
			CHUNK_AMBIENT		= 0xA010,
			CHUNK_DIFFUSE		= 0xA020,
			CHUNK_SPECULAR		= 0xA030,
			CHUNK_TEXTURE		= 0xA200,
			CHUNK_BUMPMAP		= 0xA230,
			CHUNK_MAPFILE		= 0xA300,
		CHUNK_KEYFRAMER		= 0xB000,
			CHUNK_AMBIENTKEY	= 0xB001,
			CHUNK_TRACKINFO		= 0xB002,
				CHUNK_TRACKOBJNAME	= 0xB010,
				CHUNK_TRACKPIVOT	= 0xB013,
				CHUNK_TRACKPOS		= 0xB020,
				CHUNK_TRACKROTATE	= 0xB021,
				CHUNK_TRACKSCALE	= 0xB022,
				CHUNK_OBJNUMBER		= 0xB030,
			CHUNK_TRACKCAMERA	= 0xB003,
				CHUNK_TRACKFOV		= 0xB023,
				CHUNK_TRACKROLL		= 0xB024,
			CHUNK_TRACKCAMTGT	= 0xB004,
			CHUNK_TRACKLIGHT	= 0xB005,
			CHUNK_TRACKLIGTGT	= 0xB006,
			CHUNK_TRACKSPOTL	= 0xB007,
			CHUNK_FRAMES		= 0xB008,
};

/* forward declaration. */
void	chunk_reader(FILE *f, int ind, long p);

void	skip_reader(FILE *f, int ind, long p) {
}

void	RGBf_reader (FILE *f, int ind, long p)
{
	float	c[3];
	if (fread(&c, sizeof(c), 1, f) != 1) return;
/*	printf("%*s    Red: %f, Green: %f, Blue: %f\n", ind, "", c[0], c[1], c[2]);*/
	
	if (last_chunk == CHUNK_LIGHT) {
		light_list[num_lights - 1].color.R = (char)(c[0] * 255);
		light_list[num_lights - 1].color.G = (char)(c[1] * 255);
		light_list[num_lights - 1].color.B = (char)(c[2] * 255);
		last_chunk = 0;
	}
}

void	RGBb_reader (FILE *f, int ind, long p)
{
	unsigned char	c[3];
	if (fread(&c, sizeof(c), 1, f) != 1) return;
/*	printf("%*s    Red: %d, Green: %d, Blue: %d\n", ind, "", c[0], c[1], c[2]);*/

	if (last_chunk == CHUNK_LIGHT) {
		light_list[num_lights - 1].color.R = c[0];
		light_list[num_lights - 1].color.G = c[1];
		light_list[num_lights - 1].color.B = c[2];
		last_chunk = 0;
	}
	if (last_chunk == CHUNK_AMBIENT) {
		material_list[num_materials - 1].ambient.R = c[0];
		material_list[num_materials - 1].ambient.G = c[1];
		material_list[num_materials - 1].ambient.B = c[2];
		last_chunk = 0;
	}
	if (last_chunk == CHUNK_DIFFUSE) {
		material_list[num_materials - 1].diffuse.R = c[0];
		material_list[num_materials - 1].diffuse.G = c[1];
		material_list[num_materials - 1].diffuse.B = c[2];
		last_chunk = 0;
	}
	if (last_chunk == CHUNK_SPECULAR) {
		material_list[num_materials - 1].specular.R = c[0];
		material_list[num_materials - 1].specular.G = c[1];
		material_list[num_materials - 1].specular.B = c[2];
		last_chunk = 0;
	}
}


void	perc_int_reader (FILE *f, int ind, long p)
{
	unsigned short	c;

	if (fread(&c, sizeof(c), 1, f) != 1) return;
	
	printf("%d %%\n",c);
}

void	perc_float_reader (FILE *f, int ind, long p)
{
	float	c;

	if (fread(&c, sizeof(c), 1, f) != 1) return;
	
	printf("%f %%\n",c);
}

void	ASCIIZ_reader (FILE *f, int ind, long p)
{
	int		c, i;

	i = 0;

	/* Read ASIIZ name */
	while ( (c = fgetc(f)) != EOF && c != '\0' && i < 16) {
		name[i] = (char)c;							/* name is global pointer that points whre ever it should point. */
/*		putchar(c);*/
		i ++;
	}
	name[i] = '\0';
/*	printf("\"\n");*/
}

void	obj_block_reader (FILE *f, int ind, long p)
{

	object_list[num_objects].pivot.x = 0;
	object_list[num_objects].pivot.y = 0;
	object_list[num_objects].pivot.z = 0;
	object_list[num_objects].pivot.w = 1;
	
	object_list[num_objects].rotate_x = 0;
	object_list[num_objects].rotate_y = 0;
	object_list[num_objects].rotate_z = 0;

	object_list[num_objects].visible = TRUE;

	/* this is for asciiz-reader */
	name = object_list[num_objects].name;

	/* Read ASCIIZ object name */
/*	printf("%*sObject name \"", ind, "");*/
	ASCIIZ_reader(f, ind, p);
	
	/* Just in case */
	name = tmp_name;
	
	num_objects++;
	tmp_num_vertices = num_vertices;
	tmp_num_polys = num_polys;
	
	/* Read rest of the chunks inside this one. */
	chunk_reader(f, ind, p);
}

void	vert_list_reader (FILE *f, int ind, long p)
{
	unsigned short	nv;
	float			c[3];

	if (fread(&nv, sizeof(nv), 1, f) != 1) return;
/*	printf("%*sVertices: %d\n", ind, "", nv);*/

	object_list[num_objects - 1].vertex_base = num_vertices;
	object_list[num_objects - 1].num_vertices = nv;

	while (nv-- > 0) {
		if (fread(&c, sizeof(c), 1, f) != 1) return;
/*		printf("%*s    X: %f, Y: %f, Z: %f\n", ind, "", c[0], c[1], c[2]);*/
		add_vertex(c[0], c[1], c[2]);
	}
}

void	face_list_reader (FILE *f, int ind, long p)
{
	unsigned short	nv;
	unsigned short	c[3];
	unsigned short	flags;

	if (fread(&nv, sizeof(nv), 1, f) != 1) return;
/*	printf("%*sFaces: %d\n", ind, "", nv);*/

	object_list[num_objects - 1].poly_base = num_polys;
	object_list[num_objects - 1].num_polys = nv;
	tmp_num_polys = num_polys;

	while (nv-- > 0) {
		if (fread(&c, sizeof(c), 1, f) != 1) return;
		if (fread(&flags, sizeof(flags), 1, f) != 1) return;

		add_polygon(c[0] + tmp_num_vertices, c[1] + tmp_num_vertices, c[2] + tmp_num_vertices);
			
/*		printf("%*s  A %d, B %d, C %d, 0x%X:", ind, "", c[0], c[1], c[2], flags);
		printf(" AB %d BC %d CA %d UWrap %d VWrap %d\n",
			(flags & 0x04) != 0, (flags & 0x02) != 0, (flags & 0x01) != 0,
			(flags & 0x08) != 0, (flags & 0x10) != 0);*/
	}
	/* Read rest of chuck inside this one. */
	chunk_reader(f, ind, p);
}

int		find_material (char *name)
{
	int		i, mat;

	mat = -1;
	
	for (i = 0; i < num_materials; i ++ ) {
		if (strcmp(material_list[i].name, name) == 0)
			mat = i;
	}
	
	return mat;
}

void	face_mat_reader (FILE *f, int ind, long p)
{
	unsigned short	n, nf;
	int				material_num;
	char			mat_name[17];

	/* Read ASCIIZ material name */
/*	printf("%*sMaterial name for faces: \"", ind, "");*/
	name = mat_name;
	ASCIIZ_reader(f, ind, p);
	name = tmp_name;

	material_num = find_material(mat_name);

	if (fread(&n, sizeof(n), 1, f) != 1) return;
/*	printf("%*sFaces with this material: %d\n", ind, "", n);*/
	while (n-- > 0) {
		if (fread(&nf, sizeof(nf), 1, f) != 1) return;
/*			printf("%*s    Face %d\n", ind, "", nf);*/
		poly_list[nf + tmp_num_polys].material = material_num;
	}
}

void	map_list_reader (FILE *f, int ind, long p)
{
	unsigned short	nv;
	float			c[2];

	if (fread(&nv, sizeof(nv), 1, f) != 1) return;
/*	printf("%*sVertices: %d\n", ind, "", nv);*/
	while (nv-- > 0) {
		if (fread(&c, sizeof(c), 1, f) != 1) return;
/*		printf("%*s    U: %f, V: %f\n", ind, "", c[0], c[1]);*/
	}
}

void	smoo_list_reader (FILE *f, int ind, long p)
{
	unsigned long	s;
	int				i;

	while (ftell(f) < p) {
		if (fread(&s, sizeof(s), 1, f) != 1) return;
/*		printf("%*sSmoothing groups: ", ind, "");*/
		for (i = 0; i < 32; i++) {
/*			if (s & (1 << i))
				printf("%d, ", i + 1);*/
		}
/*		printf("\n");*/
    }
}

void	tr_matrix_reader (FILE *f, int ind, long p)
{
/*	int		start, end, i;*/
	float	rot[9];
	float	trans[3];

	if (fread(&rot, sizeof(rot), 1, f) != 1) return;
    
/*	printf("%*sRotation matrix:\n", ind, "");
	printf("%*s    %f, %f, %f\n", ind, "", rot[0], rot[1], rot[2]);
	printf("%*s    %f, %f, %f\n", ind, "", rot[3], rot[4], rot[5]);
	printf("%*s    %f, %f, %f\n", ind, "", rot[6], rot[7], rot[8]);*/

	if (fread(&trans, sizeof(trans), 1, f) != 1) return;
/*	printf("%*sTranslation matrix: %f, %f, %f\n", ind, "", trans[0], trans[1], trans[2]);*/

	/* move object's pivot where it should be */
/*	start = object_list[num_objects - 1].vertex_base;
	end = object_list[num_objects - 1].vertex_base + object_list[num_objects - 1].num_vertices;

	for (i = start; i < end; i ++) {
		vertex_list[i].local.x -= trans[0];
		vertex_list[i].local.y -= trans[1];
		vertex_list[i].local.z -= trans[2];
	}
	
	object_list[num_objects - 1].pivot.x = trans[0];
	object_list[num_objects - 1].pivot.y = trans[1];
	object_list[num_objects - 1].pivot.z = trans[2];*/
}

void	light_reader (FILE *f, int ind, long p)
{
	float	c[3];

	num_objects --;
	
	if (fread(&c, sizeof(c), 1, f) != 1) return;
/*	printf("%*s    X: %f, Y: %f, Z: %f\n", ind, "", c[0], c[1], c[2]);*/

	add_light(c[0], c[1], c[2]);

	last_chunk = CHUNK_LIGHT;

	/* Read rest of chunks inside this one. */
    chunk_reader(f, ind, p);
}

void	spot_light_reader (FILE *f, int ind, long p)
{
	float	c[5];
	
	if (fread(&c, sizeof(c), 1, f) != 1) return;
/*	printf("%*s    Target X: %f, Y: %f, Z: %f; Hotspot %f, Falloff %f\n", ind, "", c[0], c[1], c[2], c[3], c[4]);*/

	light_list[num_lights - 1].target.x = c[0];
	light_list[num_lights - 1].target.y = c[1];
	light_list[num_lights - 1].target.z = c[2];
	light_list[num_lights - 1].falloff = c[4];
}
 
void	camera_reader (FILE *f, int ind, long p)
{
	float	 c[8];

	num_objects --;
	
	if (fread(&c, sizeof(c), 1, f) != 1) return;
/*	printf("%*s    Position: X: %f, Y: %f, Z: %f\n", ind, "", c[0], c[1], c[2]);
	printf("%*s    Target: X: %f, Y: %f, Z: %f\n", ind, "", c[3], c[4], c[5]);
	printf("%*s    Bank: %f, Lens: %f\n", ind, "", c[6], c[7]);*/
}

int		find_object (char *name)
{
	int		i, obj;

	obj = -1;
	
	for (i = 0; i < num_objects; i ++ ) {
		if (strcmp(object_list[i].name, name) == 0)
			obj = i;
	}
	
	return obj;
}

void	hierarchy_reader (FILE *f, int ind, long p)
{
	unsigned short	buf[3];
	unsigned short	level;
	char	objname[20];
	int		hier_num;
	
	name = objname;
	ASCIIZ_reader(f, ind, p);
	
	hier_num = find_object(objname);
	
	if (hier_num == -1)		/* dummy object */
		hier_num = OBJECT_BUF - 1;

	if (fread(&buf, sizeof(buf), 1, f) != 1) return;
	if (fread(&level, sizeof(level), 1, f) != 1) return;
	
	printf("object: %s level = %d\n", objname, level);
	
	if (level == -1);		/* this object is root */
	else {
		object_list[hier_num].child_list[object_list[hier_num].num_child] = level;
		object_list[hier_num].num_child ++;
	}
}


void	mat_reader (FILE *f, int ind, long p)
{
	add_material();

	/* Read rest of chunks inside this one. */
	chunk_reader(f, ind, p);
}

void	mat_name_reader (FILE *f, int ind, long p)
{
	/* Read ASCIIZ material name */
	name = material_list[num_materials - 1].name;
	ASCIIZ_reader(f, ind, p);
/*	printf("%*sMaterial name \"%s", ind, "",name);*/
	name = tmp_name;
}


void	ambient_reader (FILE *f, int ind, long p)
{
	last_chunk = CHUNK_AMBIENT;
	/* Read rest of chunks inside this one. */
    chunk_reader(f, ind, p);
}

void	diffuse_reader (FILE *f, int ind, long p)
{
	last_chunk = CHUNK_DIFFUSE;
	/* Read rest of chunks inside this one. */
    chunk_reader(f, ind, p);
}

void	specular_reader (FILE *f, int ind, long p)
{
	last_chunk = CHUNK_SPECULAR;
	/* Read rest of chunks inside this one. */
    chunk_reader(f, ind, p);
}


void	map_file_reader (FILE *f, int ind, long p)
{
	/* Read ASCIIZ filename. */
/*	printf("%*sMap filename \"", ind, "");*/
	ASCIIZ_reader(f, ind, p);
}

void	frames_reader (FILE *f, int ind, long p)
{
    unsigned long	c[2];

	if (fread(&c, sizeof(c), 1, f) != 1) return;
/*	printf("%*s    Start: %ld, End: %ld\n", ind, "", c[0], c[1]);*/
}

void	track_obj_name_reader (FILE *f, int ind, long p)
{
	unsigned short	w[2];
	unsigned short	parent;

	/* Read ASCIIZ name. */
/*	printf("%*sTrack object name \"", ind, "");*/
	ASCIIZ_reader(f, ind, p);

	if (fread(&w, sizeof(w), 1, f) != 1) return;
	if (fread(&parent, sizeof(parent), 1, f) != 1) return;
/*	printf("%*sObject name data: Flags 0x%X, 0x%X, Parent %d\n", ind, "", w[0], w[1], parent);*/
}

void	pivot_point_reader (FILE *f, int ind, long p)
{
/*	int		i, start, end;*/
	float	pos[3];

	if (fread(&pos, sizeof(pos), 1, f) != 1) return;
/*	printf("%*s  Pivot at X: %f, Y: %f, Z: %f\n", ind, "", pos[0], pos[1], pos[2]);*/

	/* move object's pivot where it should be */
/*	start = object_list[num_objects - 1].vertex_base;
	end = object_list[num_objects - 1].vertex_base + object_list[num_objects - 1].num_vertices;


	for (i = start; i < end; i ++) {
		vertex_list[i].local.x -= pos[0];
		vertex_list[i].local.y -= pos[1];
		vertex_list[i].local.z -= pos[2];
	}
	
	object_list[num_objects - 1].pivot.x -= pos[0];
	object_list[num_objects - 1].pivot.y -= pos[1];
	object_list[num_objects - 1].pivot.z -= pos[2];*/

}

    /* Key info flags for position, rotation and scaling:
        Until I know the meaning of each bit in flags I assume all mean
        a following float data.
    */

/* NOTE THIS IS NOT A CHUNK, but A PART OF SEVERAL CHUNKS */
void	spline_flags_reader(FILE *f, int ind, short flags)
{
	int		i;
	float	dat;
	static const char *flagnames[] = {
		"Tension",
		"Continuity",
		"Bias",
		"Ease To",
		"Ease From",
	};

	for (i = 0; i < 16; i++) {
		if (flags & (1 << i)) {
			if (fread(&dat, sizeof(dat), 1, f) != 1) return;
			if (i < sizeof(flagnames)/sizeof(*flagnames))
/*				printf("%*s             %-15s = %f\n", ind, "", flagnames[i], dat);*/;
			else
/*				printf("%*s             %-15s = %f\n", ind, "", "Unknown", dat);*/;
		}
	}
}

void	track_pos_reader (FILE *f, int ind, long p)
{
	unsigned short	n, nf;
	float			pos[3];
	unsigned short	unkown;
	unsigned short	flags;

	fseek(f, 10, SEEK_CUR);
	if (fread(&n, sizeof(n), 1, f) != 1) return;
/*	printf("%*sPosition keys: %d\n", ind, "", n);*/

	fseek(f, 2, SEEK_CUR);
	while (n-- > 0) {
		if (fread(&nf, sizeof(nf), 1, f) != 1) return;
		if (fread(&unkown, sizeof(unkown), 1, f) != 1) return;
		if (fread(&flags, sizeof(flags), 1, f) != 1) return;

/*		printf("%*s  Frame %3d: Flags 0x%X\n", ind, "", nf, flags);*/
		spline_flags_reader(f, ind, flags);

		if (fread(&pos, sizeof(pos), 1, f) != 1) return;
/*		printf("%*s             X: %f, Y: %f, Z: %f\n", ind, "", pos[0], pos[1], pos[2]);*/
    }
}

void	track_rot_reader (FILE *f, int ind, long p)
{
	unsigned short	n, nf;
	float			pos[4];
	unsigned short	unkown;
	unsigned short	flags;

	fseek(f, 10, SEEK_CUR);
	if (fread(&n, sizeof(n), 1, f) != 1) return;
/*	printf("%*sRotation keys: %d\n", ind, "", n);*/

	fseek(f, 2, SEEK_CUR);
	while (n-- > 0) {
		if (fread(&nf, sizeof(nf), 1, f) != 1) return;
		if (fread(&unkown, sizeof(unkown), 1, f) != 1) return;
		if (fread(&flags, sizeof(flags), 1, f) != 1) return;

/*		printf("%*s  Frame %3d: Flags 0x%X\n", ind, "", nf, flags);*/
		spline_flags_reader(f, ind, flags);

		if (fread(&pos, sizeof(pos), 1, f) != 1) return;
/*		printf("%*s             Angle: %f, X: %f, Y: %f, Z: %f\n", ind, "", pos[0]*180.0/3.1415, pos[1], pos[2], pos[3]);*/
    }
}

void	track_scale_reader (FILE *f, int ind, long p)
{
	unsigned short	n, nf;
	float			pos[3];
	unsigned short	unkown;
	unsigned short	flags;

	fseek(f, 10, SEEK_CUR);
	if (fread(&n, sizeof(n), 1, f) != 1) return;
/*	printf("%*sScale keys: %d\n", ind, "", n);*/

	fseek(f, 2, SEEK_CUR);
	while (n-- > 0) {
		if (fread(&nf, sizeof(nf), 1, f) != 1) return;
		if (fread(&unkown, sizeof(unkown), 1, f) != 1) return;
		if (fread(&flags, sizeof(flags), 1, f) != 1) return;

/*		printf("%*s  Frame %3d: Flags 0x%X\n", ind, "", nf, flags);*/
		spline_flags_reader(f, ind, flags);

		if (fread(&pos, sizeof(pos), 1, f) != 1) return;
/*		printf("%*s            X: %f, Y: %f, Z: %f\n", ind, "", pos[0], pos[1], pos[2]);*/
    }
}

void	obj_number_reader (FILE *f, int ind, long p)
{
	unsigned short	n;

	if (fread(&n, sizeof(n), 1, f) != 1) return;
/*	printf("%*sObject number: %d\n", ind, "", n);*/
}

/* ------------------------------------ */

struct {
	unsigned short	id;
	const char		*name;
	void (*func)(FILE *f, int ind, long p);
} chunk_names[] = {
	{CHUNK_RGBF,		"RGB float",		RGBf_reader},
	{CHUNK_RGBB,		"RGB byte",			RGBb_reader},
	{CHUNK_PRCI,		"Percentage int",	perc_int_reader},
	{CHUNK_PRCF,		"Percentage float",	perc_float_reader},

	{CHUNK_PRJ,			"Project",			NULL},
	{CHUNK_MLI,			"Material Library",	NULL},

	{CHUNK_MAIN,		"Main",				NULL},
	{CHUNK_OBJMESH,		"Object Mesh",		NULL},
	{CHUNK_BKGCOLOR,	"Background color",	NULL},
	{CHUNK_AMBCOLOR,	"Ambient color",	NULL},
	{CHUNK_OBJBLOCK,	"Object Block",		obj_block_reader},
	{CHUNK_TRIMESH,		"Tri-Mesh",			NULL},
	{CHUNK_VERTLIST,	"Vertex list",		vert_list_reader},
	{CHUNK_FACELIST,	"Face list",		face_list_reader},
	{CHUNK_FACEMAT,		"Face material",	face_mat_reader},
	{CHUNK_MAPLIST,		"Mappings list",	map_list_reader},
	{CHUNK_SMOOLIST,	"Smoothings",		smoo_list_reader},
    {CHUNK_TRMATRIX,	"Matrix",			tr_matrix_reader},
	{CHUNK_LIGHT,		"Light",			light_reader},
	{CHUNK_SPOTLIGHT,	"Spotlight",		spot_light_reader},
	{CHUNK_CAMERA,		"Camera",			camera_reader},
	{CHUNK_HIERARCHY,	"Hierarchy",		hierarchy_reader},

	{CHUNK_VIEWPORT,	"Viewport info",	NULL},
	{CHUNK_MATERIAL,	"Material",			mat_reader},
	{CHUNK_MATNAME,		"Material name",	mat_name_reader},
	{CHUNK_AMBIENT,		"Ambient color",	ambient_reader},
	{CHUNK_DIFFUSE,		"Diffuse color",	diffuse_reader},
	{CHUNK_SPECULAR,	"Specular color",	specular_reader},
	{CHUNK_TEXTURE,		"Texture map",		NULL},
	{CHUNK_BUMPMAP,		"Bump map",			NULL},
	{CHUNK_MAPFILE,		"Map filename",		map_file_reader},

	{CHUNK_KEYFRAMER,	"Keyframer data",	NULL},
	{CHUNK_AMBIENTKEY,	"Ambient key",		NULL},
	{CHUNK_TRACKINFO,	"Track info",		NULL},
	{CHUNK_FRAMES,		"Frames",			frames_reader},
	{CHUNK_TRACKOBJNAME,"Track Obj. Name",	track_obj_name_reader},
	{CHUNK_TRACKPIVOT,	"Pivot point",		pivot_point_reader},
	{CHUNK_TRACKPOS,	"Position keys",	track_pos_reader},
	{CHUNK_TRACKROTATE,	"Rotation keys",	track_rot_reader},
	{CHUNK_TRACKSCALE,	"Scale keys",		track_scale_reader},
	{CHUNK_OBJNUMBER,	"Object number",	obj_number_reader},

	{CHUNK_TRACKCAMERA,	"Camera track",				NULL},
	{CHUNK_TRACKCAMTGT,	"Camera target track",		NULL},
	{CHUNK_TRACKLIGHT,	"Pointlight track",			NULL},
	{CHUNK_TRACKLIGTGT,	"Pointlight target track",	NULL},
	{CHUNK_TRACKSPOTL,	"Spotlight track",			NULL},
	{CHUNK_TRACKFOV,	"FOV track",				NULL},
	{CHUNK_TRACKROLL,	"Roll track",				NULL},
};

int		find_chunk (unsigned short id)
{
	int		i;
	
	for (i = 0; i < sizeof(chunk_names) / sizeof(chunk_names[0]); i++)
		if (id == chunk_names[i].id)
			return i;
	return -1;
}

/* ------------------------------------ */

int		Verbose = 0;
int		Quiet   = 0;

void	chunk_reader (FILE *f, int ind, long p)
{
    t_chunk_header	h;
	int				n;
	long			pc;

	while (ftell(f) < p) {
		pc = ftell(f);
		if (fread(&h, sizeof(h), 1, f) != 1) return;
		if (h.len == 0) return;
		n = find_chunk(h.id);

		if (n < 0) {
/*			if (Verbose)
				printf("%*sUnknown chunk: 0x%04X, offset 0x%lX, size: %d bytes.\n", ind, "", h.id, pc, h.len);*/
			fseek(f, pc + h.len, SEEK_SET);
		} else {
/*			if (!Quiet || chunk_names[n].func == NULL)
				printf("%*sChunk type \"%s\", offset 0x%lX, size %d bytes\n", ind, "", chunk_names[n].name, pc, h.len);*/
			pc = pc + h.len;
			if (chunk_names[n].func != NULL)
				chunk_names[n].func(f, ind + 2, pc);
			else
				chunk_reader(f, ind + 2, pc);
			fseek(f, pc, SEEK_SET);
		}
		if (ferror(f))
			break;
	}
}


int load_3ds (char *filename)
{
	FILE	*f;
	long	p;

	if ((f = fopen(filename,"rb")) == NULL) return -1;

	/* find the file size */
	fseek(f, 0, SEEK_END);
	p = ftell(f);
	fseek(f, 0, SEEK_SET);

	/* Go! */
	chunk_reader(f, 0, p);
	
	return 0;
}
