#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "\sr\h\sr.h"
#include "\lib\h\control.h"
#include "\lib\h\memory.h"
#include "\lib\h\bitmap.h"
#include "h\inside.h"

#define MAXFISH 8

static char        *palette,*qtable,*tmap,*waterint;
static SR_FILE     *sro[2];
static SR_MAT      *mat[2];
static SR_SCENE    *scene;
static SR_CAMERA   *camera;
static SR_MESH     *ob[3];
static MATRIX3     obmtx[2],cammtx;
static VECTOR3     obloc[2],camloc;
static BITMAP      *waterbmo,*intbmo;


static SR_FILE     *fishsro;
static SR_MESH     *fish[MAXFISH];
static int water_tag;
typedef short INT;

static char    *picbuf;
static INT     *frame,*oldframe;

static int   raindrops=0;
static int   rainspeed=200;
static int   speed=1;

int picwidth = 320;
int picheight = 200;

//-----------------------------------------------------------------------------

extern void do_water(INT *frame, INT *oldframe,
                     char *picbuf, char *screenbuf);

#pragma aux do_water "*_" \
 parm caller [esi] [edi] [edx] [ebx]\

//-----------------------------------------------------------------------------

void move_fish (int no)
{
    VECTOR3 v,w;
    VECTOR2 sv;
    FLOAT a;
    int p,q,i;
    FLOAT x,y;
    FLOAT amount;

    a = sin(((timer+no*171)/631.0))+cos(((timer-no*57)/370.1))+0.1*cos((-timer/123.0));

    SR_myaw (fish[no]->matrix,DEGREE_TO_RAD(a));

// wiggle fish

    fish[no]->vertex[4].x = -sin(timer/45.0)*15.0; // a*100;
    fish[no]->vertex[5].x = -sin(timer/37.0)*20.0; // a*100;
    fish[no]->vertex[6].x =  sin(timer/61.0)*25.0; // a*100;

    fish[no]->vertex[4].nx = sin(timer/45.0)*800.0; // a*100;
    fish[no]->vertex[5].ny = sin(timer/37.0)*800.0; // a*100;
    fish[no]->vertex[6].nz = sin(timer/61.0)*800.0; // a*100;

// move fish forward

    a = (a*30)+10;

    if (a<15.0) a = 15.0;

    SR_vmake (v,fish[no]->x,fish[no]->y,fish[no]->z);
    SR_vmake (w,0,0,a);
    SR_vmove (v,w,SR_vlen(w),fish[no]->matrix);

    fish[no]->x=v[0];
    fish[no]->y=v[1];
    fish[no]->z=v[2];

// project fish and cause ripples

    SR_project (scene,sv,v);

    x = sv[0];
    y = sv[1];

    if (x<-70) SR_myaw (fish[no]->matrix,DEGREE_TO_RAD(180));
    if (x>390) SR_myaw (fish[no]->matrix,DEGREE_TO_RAD(180));

    if (y<-70) SR_myaw (fish[no]->matrix,DEGREE_TO_RAD(180));
    if (y>270) SR_myaw (fish[no]->matrix,DEGREE_TO_RAD(180));

    amount = 600;

    if (!(rand()%300)) amount = rand()%40000;

    if (x>3 && x<scene->xwidth-3 && y>3 && y<scene->yheight-3)
    {
        for (p=-3; p<3; p++)                          // set "pressure" on water
        for (q=-3; q<p; q++)
            frame[((int)y+q)*scene->xwidth+((int)x+p)]=amount;
    }

}

//-----------------------------------------------------------------------------

void water_loop (char *drawbuf)

{
    int    i,j,l,m,p,q;
    INT   *temp;

    for (i=0; i<MAXFISH; i++)
        move_fish(i);

	for (i=0; i<raindrops; i++)
	if (!(rand()%rainspeed))
	{
        l=(rand()%(scene->xwidth-20))+10;
        m=(rand()%(scene->yheight-20))+10;
        j=rand()%20000;
		for (p=-3; p<4; p++)
		for (q=-3; q<4; q++)
            frame[(m+q)*scene->xwidth+l+p]=j;
	}

    do_water (frame,oldframe,picbuf,drawbuf);   // call assembler-optimized waterdrawing
    temp     = frame;                           // swap water heightfields
    frame    = oldframe;
	oldframe = temp;

}

//-----------------------------------------------------------------------------

static void init_objects()
{
    SR_VERT *v;
    int i;

    camera = MEM_allocate_named(sizeof(SR_CAMERA),"camera");

    SR_camera_init(camera);
    SR_add_object  (scene, (SR_OBJ *)camera);
    scene->camera = camera;
    SR_vmake (camloc,0,0,-1600);
    SR_mrotxyz (cammtx,0,0,0);

    ob[0] = MEM_allocate_named (SR_SIZE(sro[0]),"water object");
    SR_init_object((SR_OBJ *)ob[0]);
    SR_load_object(ob[0],sro[0],65536*0.60,mat[0]);
    SR_set_object_render(ob[0],SR_TEX);
    SR_add_object(scene,(SR_OBJ*)ob[0]);
    ob[0]->flags=SR_ENVLOCAL;

    SR_vmake  (obloc[0],-600,0,0);
    SR_mrotxyz (obmtx[0],0,(DEGREE_TO_RAD(10.0)),0);

    for (i=0; i<MAXFISH; i++)
    {
        fish[i] = MEM_allocate_named(SR_SIZE(fishsro),"waterfish");

        SR_init_object((SR_OBJ *)fish[i]);
        SR_load_object(fish[i],fishsro,65536*0.15,mat[1]); // expand object mesh
        SR_set_object_render(fish[i],SR_TEX_I);
        fish[i]->flags = SR_ENVLOCAL;
        SR_set_location ((SR_OBJ *)fish[i],(rand()%3000)-1500,0,rand()%1000);
        SR_set_rotation ((SR_OBJ *)fish[i],DEGREE_TO_RAD(90),0,0);
        SR_myaw (fish[i]->matrix,DEGREE_TO_RAD(rand()%300));
        SR_add_object (scene,(SR_OBJ *)fish[i]);
        fish[i]->sortbias = -1000*256;
    }


}

//-----------------------------------------------------------------------------

static void rota_object()
{
    MATRIX3 m;

    SR_mrotxyz (m,0,0.0185,0);
    SR_mmul (obmtx[0],m);
}

//-----------------------------------------------------------------------------

static void water_irq()
{
    rota_object();
}

//-----------------------------------------------------------------------------

static void copy_locations()
{

    camera->x = camloc[0];      // copy camera parameters
    camera->y = camloc[1];
    camera->z = camloc[2];
    SR_mcopy (camera->matrix,cammtx);

    ob[0]->x = obloc[0][0];
    ob[0]->y = obloc[0][1];
    ob[0]->z = obloc[0][2];

    SR_mcopy (ob[0]->matrix,obmtx[0]);

}

//-----------------------------------------------------------------------------

static void water_main_loop()
{

    scene->buffer = buffer1;


    file_io++;
    copy_locations();
    file_io--;

    MEM_set (buffer1,0,320*2);
    MEM_set (buffer1+198*320,0,320*2);

    water_loop(buffer1);


    SR_render_view(scene);

    show_info();
    flip_page();
}

//-----------------------------------------------------------------------------

void water_load()
{
    int i;
    file_io++;

    water_tag = MEM_get_unused_tag();
    MEM_set_tag (water_tag);

    tmap        = load_file ("water/waterenv.raw");
    qtable      = load_file ("water/water.shd");
    palette     = load_file ("water/water.pal");
    picbuf      = load_file ("water/water.raw");
    fishsro     = load_file ("water/fish.sro");
    waterint    = load_file ("water/water.int");
    sro[0]      = load_file ("water/obuke.sro");
    mat[0]      = MEM_allocate_named(sizeof(SR_MAT),"water material");
    mat[1]      = MEM_allocate_named(sizeof(SR_MAT),"fish material");

    SR_init();                                  // initialize SurRender


    scene = MEM_allocate_named(sizeof(SR_SCENE),"water scene");
    SR_init_scene (scene);                  // initialize scene to default parameters
    SR_set_viewport(scene,320,200,0,0,320,200);

    init_objects();

    scene->buffer = buffer1;
    scene->perspective = 256;
    scene->front_clip_depth = 256*28;
    scene->ambient_luminance = 0;

    raindrops = 3;

    if (rainspeed<=0) rainspeed = 1;

    SR_set_material (mat[0],tmap,NULL,qtable,NULL,255,255,8,8);
    SR_set_material (mat[1],tmap,NULL,waterint,NULL,255,255,8,8);

    file_io--;
}

//-----------------------------------------------------------------------------

void water_init()
{

    MEM_set(buffer1,0,320*200);
    MEM_set(buffer2,0,320*200);

    set_base_palette(palette);

    frame     = MEM_allocate_named(scene->xwidth*scene->yheight*sizeof(INT),"water frame 1");
    oldframe  = MEM_allocate_named(scene->xwidth*scene->yheight*sizeof(INT),"water frame 2");

    set_demo_irq  (&water_irq);
    set_demo_loop (&water_main_loop);

}

//-----------------------------------------------------------------------------

void water_exit()
{
    set_demo_irq  (NULL);
    set_demo_loop (NULL);
    MEM_free_tagged (water_tag);
}

//-----------------------------------------------------------------------------

