#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#define MAXFILES 500

int  curoffset = 0;
int  entrycounter = 0;

FILE *outfile;

typedef struct
{
    char  name[32];
    int   size;
    int   offset;
    char *data;       // not needed in this program
    int   comptype;   // compression type
} entrystruct;

entrystruct entry[MAXFILES];

//-----------------------------------------------------------------------------

void *allocate_file(char *fname, int *bytes)
{
	int 	size;
	void	*buf;
	FILE	*infile;

	infile = fopen(fname, "rb");
    if(!infile)
    {
        printf ("Loading file %s failed - program execution halted!\n",fname);
        exit(1);
    }

	fseek (infile,0,2); 		   // go to end of file
	size = ftell(infile);		   // get position (i.e. size of file)
	fseek (infile,0,0); 		   // seek back to beginning of file
    if (!size)
    {
        printf ("Loading file %s failed - program execution halted!\n",fname);
        exit(1);
    }

    buf = malloc(size);            // allocate memory (size of file)

    if(!buf)
    {
        printf ("Allocation memory failed - program execution halted!\n");
        exit(1);
    }

    *bytes = fread(buf, 1, size, infile); // read data

    if (*bytes!=size)
    {
        printf ("Sizes don't match (%d %d)\n",*bytes,size);
        exit(1);
    }

	fclose(infile); 				 // close the file
	return buf; 					 // return pointer to new buffer
}

//-----------------------------------------------------------------------------

void save_data(void *buf, int size)
{

    fwrite(buf, 1, size, outfile);
}

//-----------------------------------------------------------------------------

void add_file (char *fname)
{
    char *b;
    int bytes;

    b = allocate_file(fname,&bytes);

    printf ("Adding entry <%s> (%d Kb) to offset %d\n",fname,bytes/1024,curoffset);
    strcpy (entry[entrycounter].name,fname);
    entry[entrycounter].size   = bytes;
    entry[entrycounter].offset = curoffset;
    entrycounter++;
    save_data (b,bytes);
    curoffset+=bytes;
    free (b);
}

//-----------------------------------------------------------------------------

void main (int argc, char *argv[])
{

    FILE *scriptfile;
    char  scriptline[100];
    char *exe;
    int   bytes,i;

    scriptfile = fopen("inside.lst","rt");
    if(!scriptfile)
    {
        printf ("no scriptfile given\n");
        exit(1);
    }

    outfile   = fopen("inside.raw","wb");
    curoffset = 0;                      // starting point for data

    while(fgets(scriptline, 85, scriptfile))
    {

        strlwr (scriptline);

        for (i=0; i<strlen(scriptline); i++)
            if (scriptline[i]=='\\')
                scriptline[i]='/';

        scriptline[strlen(scriptline)-1]='\0';
        add_file (scriptline);
    }

    fclose(scriptfile);

    save_data (entry,entrycounter*sizeof(entrystruct));
    save_data (&entrycounter,4);
    fclose (outfile);
}

//-----------------------------------------------------------------------------

