/*
**
**	Smousse effect by FirEdge / Ethereal
**
*/


#include <windows.h>
#include <gl/gl.h>
#include <math.h>
#include "ijl.h"

#include "fxSmousse.hpp"


fxSmousse::fxSmousse()
{
}


bool fxSmousse::Init(const Loader* l)
{
	JPEG_CORE_PROPERTIES jcprops1;
	BYTE pixel_buff [128*128*3];
	BYTE buffer [1024*128*3];


	ijlInit (&jcprops1);

	jcprops1.JPGFile = "data/squares.jpg";

	jcprops1.DIBWidth = 128;
	jcprops1.DIBHeight = 128;
	jcprops1.DIBChannels = 3;
	jcprops1.DIBColor = IJL_RGB;
	jcprops1.DIBPadBytes = 0;
	jcprops1.DIBBytes = pixel_buff;

    ijlRead (&jcprops1, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops1);	

	glGenTextures(2 , &smap);
	glBindTexture(GL_TEXTURE_2D, smap);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 128, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buff);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	
	ijlInit (&jcprops1);

	jcprops1.JPGFile = "data/greet.jpg";

	jcprops1.DIBWidth = 2048;
	jcprops1.DIBHeight = 64;
	jcprops1.DIBChannels = 3;
	jcprops1.DIBColor = IJL_RGB;
	jcprops1.DIBPadBytes = 0;
	jcprops1.DIBBytes = buffer;

    ijlRead (&jcprops1, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops1);	

	glBindTexture(GL_TEXTURE_2D, greets);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 2048, 64, 0, GL_RGB, GL_UNSIGNED_BYTE, buffer );
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	return true;
}


#define sx 0.3f
#define sy 0.3f
#define sz 0.3f


void fxSmousse::Render(float time, const Demo *env)
{
	int i;

	glEnable( GL_TEXTURE_2D );
	glEnable( GL_BLEND );
	glBlendFunc( GL_DST_COLOR, GL_SRC_COLOR );
	glDisable( GL_LIGHTING );
	glDisable( GL_DEPTH_TEST );

	glColor4ub( 255, 255, 255 , 128);
	glBindTexture(GL_TEXTURE_2D, smap);

/*	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		glTranslatef( 0.0f, 0.0f , -100.0f + time * 100.0f + i*5 );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( -1.68f , 0.5f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 1.68f , 0.5f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 1.68f , 0.5f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( -1.68f , 0.5f , -1.25f );
		glEnd();

	}	//	for (int i=0; i<MAX_QUADS; i++)

	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		glTranslatef( 0.0f, 0.0f , - time * 125.0f + i*5 );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( -1.68f , 0.7f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 1.68f , 0.7f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 1.68f , 0.7f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( -1.68f , 0.7f , -1.25f );
		glEnd();

	}	//	for (int i=0; i<MAX_QUADS; i++)

	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		glTranslatef( 0.0f, 0.0f , -100.0f + time * 100.0f + i*5 );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( -1.5f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( -1.5f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( -1.5f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( -1.5f , -1.0f , -1.25f );
		glEnd();

	}	//	for (int i=0; i<MAX_QUADS; i++)

	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		glTranslatef( 0.0f, 0.0f , - time * 125.0f + i*5 );
		glRotatef( 10*i *time* 5.0f , 10*i*time *1.0f ,10*i*time * 0.2f , 20*i*time *0.3f );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( -0.7f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( -0.7f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( -0.7f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( -0.7f , -1.0f , -1.25f );
		glEnd();

	}	//	for (int i=0; i<MAX_QUADS; i++)
*/
	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		
		glTranslatef( sin(time*30)*2.0f, cos(time*3*30)*2.0f , -100.0f + time * 100.0f + i*5);
		glRotatef( 100*(i+1)* time* 5.0f , 100*(i+1)*time *1.0f ,100*(i+1)*time * 0.2f , 200*(i+1)*time *0.3f );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( 0.8f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 0.8f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 0.8f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( 0.8f , -1.0f , -1.25f );
		glEnd();

	}
	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		
		glTranslatef( sin(time*20)*3.0f, cos(time*30)*1.0f+localbump , -100.0f + time * 100.0f + i*5);
		glRotatef( 100*(i+1)* time* 5.0f +localbump, 100*(i+1)*time *1.0f ,100*(i+1)*time * 0.2f+localbump , 200*(i+1)*time *0.3f );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( 0.8f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 0.8f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 0.8f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( 0.8f , -1.0f , -1.25f );
		glEnd();
	}
	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		
		glTranslatef( sin(time*20)*cos(time*20)*3.0f+localbump, tan(time*30)*1.0f +localbump, -100.0f + time * 100.0f + i*5);
		glRotatef( 100*(i+1)* time* 5.0f+localbump , 100*(i+1)*time *1.0f ,100*(i+1)*time * 0.2f , 200*(i+1)*time *0.3f +localbump);

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( 0.8f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 0.8f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 0.8f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( 0.8f , -1.0f , -1.25f );
		glEnd();
	}
	if (perc){
	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		
		glTranslatef( sin(time*20)*3.0f-5.0, cos(time*30)*1.0f +5.0, -100.0f + time * 100.0f + i*5);
		glRotatef( 100*(i+1)* time* 5.0f , 100*(i+1)*time *1.0f ,100*(i+1)*time * 0.2f , 200*(i+1)*time *0.3f );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( 0.8f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 0.8f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 0.8f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( 0.8f , -1.0f , -1.25f );
		glEnd();
	}
	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		
		glTranslatef( sin(time*20)*3.0f+5.0+localbump, cos(time*30)*1.0f -5.0, -100.0f + time * 100.0f + i*5+localbump);
		glRotatef( 100*(i+1)* time* 5.0f+localbump , 100*(i+1)*time *1.0f+localbump ,100*(i+1)*time * 0.2f+localbump , 200*(i+1)*time *0.3f );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( 0.8f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 0.8f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 0.8f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( 0.8f , -1.0f , -1.25f );
		glEnd();
	}
	
	}

	//	for (int i=0; i<MAX_QUADS; i++)

/*	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		glTranslatef( 0.0f, 0.0f , - time * 125.0f + i*5 );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( 1.7f , -1.0f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 1.7f , 1.0f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 1.7f , 1.0f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( 1.7f , -1.0f , -1.25f );
		glEnd();

	}	//	for (int i=0; i<MAX_QUADS; i++)

	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		glTranslatef( - rand() / 65536.0f , 0.0f , -100.0f + time * 100.0f + i*5 );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( -1.68f , -0.5f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 1.68f , -0.5f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 1.68f , -0.5f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( -1.68f , -0.5f , -1.25f );
		glEnd();

	}	//	for (int i=0; i<MAX_QUADS; i++)

	for (i=0; i<MAX_QUADS; i++)
	{
		glLoadIdentity();
		glTranslatef( 0.0f, 0.0f , - time * 125.0f + i*5 );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 0.0f );
			glVertex3f( -1.68f , -0.7f , 1.25f );
			glTexCoord2f( 1.0f , 0.0f );
			glVertex3f( 1.68f , -0.7f , 1.25f );
			glTexCoord2f( 1.0f , 1.0f );
			glVertex3f( 1.68f , -0.7f , -1.25f );
			glTexCoord2f( 0.0f , 1.0f );
			glVertex3f( -1.68f , -0.7f , -1.25f );
		glEnd();

	}	//	for (int i=0; i<MAX_QUADS; i++)


*/

	glDisable( GL_DEPTH_TEST );

	glLoadIdentity();
	glTranslatef( 12.0f -time * 24.0f , -1.5f, -4.0f );

	glColor4ub( 255, 255, 255 , 128);
	glBindTexture(GL_TEXTURE_2D, greets);
	glBlendFunc( GL_ONE, GL_ONE );

	glBegin( GL_QUADS );
		glTexCoord2f( 0.0f , 0.0f );
		glVertex3f( -10.68f , 0.3f , 0.0f );
		glTexCoord2f( 1.0f , 0.0f );
		glVertex3f( 10.68f , 0.3f , 0.0f );
		glTexCoord2f( 1.0f , 1.0f );
		glVertex3f( 10.68f , -0.3f , 0.0f );
		glTexCoord2f( 0.0f , 1.0f );
		glVertex3f( -10.68f , -0.3f , 0.0f );
	glEnd();

	
	glLoadIdentity();
	glTranslatef( - 12.0f + time * 24.0f , 1.5f, -4.0f );

	glColor4ub( 255, 255, 255 , 128);
	glBindTexture(GL_TEXTURE_2D, greets);
	glBlendFunc( GL_ONE, GL_ONE );

	glBegin( GL_QUADS );
		glTexCoord2f( 0.0f , 0.0f );
		glVertex3f( -10.68f , 0.3f , 0.0f );
		glTexCoord2f( 1.0f , 0.0f );
		glVertex3f( 10.68f , 0.3f , 0.0f );
		glTexCoord2f( 1.0f , 1.0f );
		glVertex3f( 10.68f , -0.3f , 0.0f );
		glTexCoord2f( 0.0f , 1.0f );
		glVertex3f( -10.68f , -0.3f , 0.0f );
	glEnd();

	glEnable( GL_DEPTH_TEST );


}

void fxSmousse::Push(ud type, float value)
{
	if (type == PUSH_PERC){
		perc=true;
		localbump=1.0;
	}else{
		perc=false;
		localbump=0.0;
	}
}

void fxSmousse::DeInit()
{
}


fxSmousse::~fxSmousse()
{
}

