// demoloader2.hpp
// header file for alternate loading system
// based on TIF's tag format, rather than chunks
// by pompy / Ethereal

#ifndef __DEMO_LOADER_H__
#define __DEMO_LOADER_H__

#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>


//#include "demoengine.hpp"

//#include "spline.hpp"  <-- not yet working


/* 
format of a .DAT file:
4 bytes - some check on the header
? bytes - demo 1
? bytes - demo 2
and so on

format of a demo:
4 bytes - length of this demo
4 bytes - offset of next demo (0 if this is the last demo)
20 bytes - name of this demo, padded with zeros
demo table
demo data

format of the demo table:
4 bytes - number of entries in the table
demo table entries

format of a demo table entry:
4 bytes - entry type
4 bytes - some sort of ID number 
4 bytes - offset to beginning of data (note: offset 0 is the "length of demo" field)
4 bytes - size of data
note: each combination of entry type and ID number must be
unique (for the timeline stuff)

notes on compression:
i would suggest compressing each demo separately
and including some sort of tag in the size 
as to whether it is compressed or not
(i.e. if the size is odd, it is compressed)

*/

class Demo;

typedef struct {
	unsigned int type;
	unsigned int id;
	unsigned int ofs;
	unsigned int size;
} table;

class Loader {
	unsigned int currdemo;
	unsigned int ndemos, tabsize;
	table *tab;
	unsigned char *data;
	FILE *in;
	Demo *env;

public:
	Loader() { };
	Loader(char *filename, void (*callback)(int, char *), Demo* environement);
	// opens filename and calls "callback" for each demo
	// found in this data file
	bool SelectDemo(unsigned int demo);
	// select which demo to decompress and load
	int GetNumber(unsigned int type);	
	// returns the number of "type" entries so memory can
	// be allocated, etc.
//	Whatever *GetWhatever(int id);
	// gets the Whatever (Spline, Texture, etc.) with ID id
//	Spline *GetSpline(int id);
	~Loader();
};

class Writer {
public:
	Writer();
	Writer(char *filename);
	int SelectDemo(int demo, int tabsize);
	bool SetName(char *name);
//	bool AddWhatever(Whatever w, int id);
	~Writer();
};

#endif