UNIT PICTURE;
{
	Unit PICTURE
	- by Bjarke Viksoe
	aug 1994

	An unit with various picture handling routines.
	Mostly called by the ILBM256, PCX256 and likes units to handle
	CMAP routines.
	Also picture copying.
}

INTERFACE

USES
	DEMOINIT;

TYPE
	pBuffer = ^buffertype;
	buffertype = array[1..64000] of byte;

VAR
	CMAP : array[1..256*3] of byte;


procedure SetCMAP;
procedure FadeCMAP(faktor : integer);

procedure Copy2Screen(v : pScreen; s : pScreen);
procedure Copy2TweakScreen(v : pScreen; s : pScreen);
procedure MakeTweak(scr1,scr2 : pScreen);


(*----------------------------------------*)


IMPLEMENTATION

procedure SetCMAP; assembler;
{Set all colours from CMAP to VGA palette quickly}
asm
	cli
	lea	si,CMAP
	xor	al,al
	mov	dx,$3C8
	out	dx,al
	inc	dx
	mov	cx,256*3
	cld
	rep outsb
	sti
end;

procedure FadeCMAP(faktor : integer);
{Fade CMAP. Factor = [0..255]. If factor is 0 then colours are black!}
var
	i : integer;
	newCMAP : array[1..256*3] of byte;
begin
	for i:=1 to 256*3 do
		newCMAP[i]:=LongMul(CMAP[i],faktor) SHR 8;

	VBLANK_QUICK;
	asm
		cli
		push	ds
		push	ss {make SS new DS}
		pop	ds
		lea	si,newCMAP
		xor	al,al
		mov	dx,$3C8
		out	dx,al
		inc	dx
		mov	cx,256*3
		rep outsb
		pop	ds
		sti
	end;
end;


(*----------------------------------------*)

procedure Copy2Screen(v : pScreen; s : pScreen); assembler;
{Copy picture buffer to another (might be the screen). Not tweaked, though}
asm
	push	ds
	lds	si,v
	les	di,s
	cld
	mov	cx,320*200/2
	rep movsw
	pop	ds
end;

procedure Copy2TweakScreen(v : pScreen; s : pScreen);
{Copy picture buffer to a tweaked screen display}
	procedure CopyPlane(v : pScreen; s : pScreen); assembler;
	asm
		push	ds
		lds	si,v
		les	di,s
		cld
		mov	cx,80*200/2
		rep movsw
		pop	ds
	end;
const
	size = 80*200;
begin
	SetBitplanes(1);
	CopyPlane(@v^[0],s);
	SetBitplanes(2);
	CopyPlane(@v^[size+0],s);
	SetBitplanes(4);
	CopyPlane(@v^[size*2+0],s);
	SetBitplanes(8);
	CopyPlane(@v^[size*3+0],s);
end;


procedure MakeTweak(scr1,scr2 : pScreen);
{Copy memory buffer to another, but make new buffer bonus-tweaked}
var
	i,scroffset : integer;
begin
	scroffset:=0;
	for i:=0 to 3 do begin
		asm
			push	ds
			lds	si,scr1
			les	di,scr2
			add	si,i
			add	di,scroffset
			mov	cx,80*200
			mov	dx,4-1
			cld
@loop:	movsb
			add	si,dx
			loop	@loop
			pop	ds
		end;
		inc(scroffset,80*200);
	end;
end;


(*----------------------------------------*)

end.
