UNIT ANIMAGE;

INTERFACE

FUNCTION  Activation_MCGA:Boolean;
PROCEDURE Activation_Texte;
PROCEDURE Attente_Synchro;
PROCEDURE Ecriture_Palette(Var palette;debut,quantite:Word);
PROCEDURE Ecriture_Couleur(couleur,rouge,vert,bleu:Byte);
PROCEDURE Ecriture_Pixel(x,y:Word;couleur:Byte);
PROCEDURE Defilement_Ecran(decalage:Byte);
PROCEDURE Dedoublement_Ecran(ligne:Word);
PROCEDURE Zoom_Vertical(resolution_y:Byte);
PROCEDURE Copie_Bloc_Normal(x1,y1,largeur:Word;hauteur:Byte;x2,y2,origine,
			    destination:Word);
PROCEDURE Copie_Bloc_Masque(x1,y1,largeur:Word;hauteur:Byte;x2,y2,origine,
			    destination:Word);

IMPLEMENTATION

 FUNCTION  Activation_MCGA:Boolean;
  BEGIN
    ASM
      MOV   AH, 0
      MOV   AL, 13h
      INT   10h
      MOV   AH, 0Fh
      INT   10h
      CMP   AL, 13h
      JE    @ok
      MOV   AL, 0
      JMP   @fin
     @ok:
      MOV   AL, 1
     @fin:
      MOV   @result, AL
    END;
  END;

 PROCEDURE Activation_Texte;ASSEMBLER;
  ASM
    MOV   AH, 0
    MOV   AL, 3
    INT   10h
  END;

 PROCEDURE Attente_Synchro;ASSEMBLER;
  ASM
    MOV   DX, 3DAh
   @deb1:
    IN    AL, DX
    TEST  AL, 8
    JNE   @deb1
   @deb2:
    IN    AL, DX
    TEST  AL, 8
    JE    @deb2
  END;

 PROCEDURE Ecriture_Palette(VAR palette;debut,quantite:Word);
  BEGIN
    ASM
      PUSH  DS
      LDS   SI, palette
      MOV   DX, 3C8h
      CLD
      MOV   CX, quantite
      MOV   BX, debut
     @deb1:
      MOV   AL, BL
      OUT   DX, AL
      INC   DX
      LODSB
      OUT   DX, AL
      LODSB
      OUT   DX, AL
      LODSB
      OUT   DX, AL
      DEC   DX
      INC   BL
      LOOP  @deb1
      POP   DS
    END;
  END;

 PROCEDURE Ecriture_Couleur(couleur,rouge,vert,bleu:Byte);ASSEMBLER;
  ASM
    MOV   DX, 3C8h
    MOV   AL, couleur
    OUT   DX, AL
    INC   DL
    MOV   AL, rouge
    OUT   DX, AL
    MOV   AL, vert
    OUT   DX, AL
    MOV   AL, bleu
    OUT   DX, AL
  END;

 PROCEDURE Ecriture_Pixel(x,y:Word;couleur:Byte);ASSEMBLER;
  ASM
    MOV   AX, y
    MOV   BX, x
    XCHG  AH, AL
    ADD   BX, AX
    SHR   AX, 1
    SHR   AX, 1
    ADD   BX, AX
    MOV   AX, $A000
    MOV   ES, AX
    MOV   AL, couleur
    MOV   ES:[BX], AL
  END;

 PROCEDURE Defilement_Ecran(decalage:Byte);ASSEMBLER;
  ASM
    MOV   DX, 3D4h
    MOV   AL, 0Dh
    OUT   DX, AL
    INC   DL
    MOV   AL, decalage
    OUT   DX, AL
  END;

 PROCEDURE Dedoublement_Ecran(ligne:Word);ASSEMBLER;
  ASM
    PUSH  DS
    MOV   DX, 3D4h
    MOV   AX, ligne
    MOV   BH, AH
    MOV   BL, BH
    AND   BX, 0201h
    MOV   CL, 4
    SHL   BX, CL
    SHL   BH, 1
    MOV   AH, AL
    MOV   AL, 18h
    OUT   DX, AX
    MOV   AL, 7
    OUT   DX, AX
    INC   DL
    IN    AL, DX
    DEC   DL
    MOV   AH, AL
    AND   AH, 11101111b
    OR    AH, BL
    MOV   AL, 7
    OUT   DX, AX
    MOV   AL, 9
    OUT   DX, AL
    INC   DL
    IN    AL, DX
    DEC   DL
    MOV   AH, AL
    AND   AH, 10111111b
    OR    AH, BH
    MOV   AL, 9
    OUT   DX, AX
    POP   DS
  END;

 PROCEDURE Zoom_Vertical(resolution_y:Byte);ASSEMBLER;
  ASM
    MOV   DX, 3D4h
    MOV   AL, 09h
    OUT   DX, AL
    INC   DL
    MOV   AL, resolution_y
    OUT   DX, AL
  END;

 PROCEDURE Copie_Bloc_Normal(x1,y1,largeur:Word;hauteur:Byte;x2,y2,origine,
			    destination:Word);ASSEMBLER;
  ASM
    PUSH  DS
    MOV   DS, origine
    MOV   ES, destination
    MOV   BX, x1
    MOV   AX, y1
    XCHG  AH, AL
    ADD   BX, AX
    SHR   AX, 1
    SHR   AX, 1
    ADD   BX, AX
    MOV   SI, BX
    MOV   BX, x2
    MOV   AX, y2
    XCHG  AH, AL
    ADD   BX, AX
    SHR   AX, 1
    SHR   AX, 1
    ADD   BX, AX
    MOV   DI, BX
    MOV   DL, 0
    MOV   DH, hauteur
    MOV   AX, largeur
    MOV   BX, 320
    SUB   BX, AX
    SHR   AX, 1
    CLD
   @boucle:
    INC   DL
    MOV   CX, AX
    REP   MOVSW
    ADD   SI, BX
    ADD   DI, BX
    CMP   DL, DH
    JNE   @boucle
    POP   DS
  END;

 PROCEDURE Copie_Bloc_Masque(x1,y1,largeur:Word;hauteur:Byte;x2,y2,origine,
			    destination:Word);ASSEMBLER;
  ASM
    PUSH  DS
    MOV   DS, origine
    MOV   ES, destination
    MOV   BX, x1
    MOV   AX, y1
    XCHG  AH, AL
    ADD   BX, AX
    SHR   AX, 1
    SHR   AX, 1
    ADD   BX, AX
    MOV   SI, BX
    MOV   BX, x2
    MOV   AX, y2
    XCHG  AH, AL
    ADD   BX, AX
    SHR   AX, 1
    SHR   AX, 1
    ADD   BX, AX
    MOV   DI, BX
    MOV   DX, 0
    MOV   AX, largeur
    MOV   BX, 320
    SUB   BX, AX
    CLD
   @boucle1:
    INC   DH
    MOV   CX, AX
   @boucle2:
    MOV   DL, [SI]
    AND   DL, DL
    JZ    @Suite
    MOVSB
    LOOP  @boucle2
    ADD   SI, BX
    ADD   DI, BX
    CMP   DH, hauteur
    JNE   @boucle1
    JMP   @Fin
   @Suite:
    INC   SI
    INC   DI
    LOOP  @boucle2
    ADD   SI, BX
    ADD   DI, BX
    CMP   DH, hauteur
    JNE   @boucle1
   @Fin:
    POP   DS
  END;

END.