//      tunnel.cpp

#include <conio.h>
#include <math.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangles.h"
#include "vectors.h"
#include "phongpal.h"
#include "lightsrc.h"
#include "stuff.h"
#include "tunnel.h"

#include "spherei.h"
#include "tuntorus.h"
#include "helix.h"

#include "tex1.h"
#include "banner5.h"
#include "banner1.h"


int t_tunpos[360][2];
int t_rottable[256][3];


void TUNNEL_Setup() {
        double ang;
        for (int i = 0; i < 360; i++) {
		ang = i * Pi / 180.0;
                t_tunpos[i][0] = 160 + cos(ang) * 250;
                t_tunpos[i][1] = 100 + sin(ang) * 250;
	}
        for (i = 0; i < 256; i++) {
                ang = i * Pi / 128.0;
                t_rottable[i][0] = sin(ang) * 3.0 + 1.0;
                t_rottable[i][1] = cos(ang) * 3.0 + 2.0;
                t_rottable[i][2] = -cos(ang / 2.0) * 3.0 - 2.0;
        }
}


void TUNNEL_Run() {
        TObject3D *sphere = new TObject3D();
        TObject3D *tun = new TObject3D();
        TObject3D *obj = new TObject3D();
        PTVirtual vscr;
        unsigned int voff;
        TPalette pal;

        SetupVirtual(&vscr, &voff);
        ClearScreen(0, voff);
        Read3DObject(TUNTORUS_VKX, tun);
        tun->Rotate(90, 0, 0);
        tun->Scale(7.2, 7.2, 7.2);
        Read3DObject(SPHEREI_VKX, sphere);
        sphere->Scale(3.6, 3.6, 3.6);
        sphere->SetCenter(160, 100);
        sphere->MapEnviroment();
        Read3DObject(HELIX_VKX, obj);
        obj->SetCenter(220, 155);
        obj->Scale(1.8, 1.8, 1.8);
        TextureOffset = (unsigned int)TEX1;

        WidthCol = 63.0;
        unsigned char r = 0;
        int p = 0;
        double ambient = 256.0;
        Light.SetP(1, 1, 1);

        GetMusicInfo();

        while (position < 21) {
                if (rowflag && ((row & 7) == 0)) ambient = 64.0;
                Fast256PhongPal(ambient, 20.0, 100, ambient, 128.0, 256.0,
                                ambient, 20.0, 100.0, pal);
                GlobalStyle = c_texturemapped;
                sphere->Draw(voff);
                sphere->Rotate(t_rottable[r][0], t_rottable[r][1], t_rottable[r++][2]);
                tun->SetCenter(t_tunpos[p][0], t_tunpos[p][1]);
                tun->Rotate(0, 0, -p);
                GlobalStyle = ca_wireframe;
                StartCol = 32;
        	tun->Draw(voff);
                GlobalStyle = c_particles;
                StartCol = 128;
                tun->DrawParticles(voff);
                tun->Rotate(0, 0, p);
                p = (p + 1) % 360;
                tun->Rotate(0, -2, 0);
                Blur(voff);
                if (row >= 32)
                        DrawBanner((unsigned int)BANNER5, 202, 110, 61, 40, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                if (ambient > 0.0) ambient -= 16.0;
                Light.Rotate(0, 0, -4);
        }

        ambient = 256.0;
        while (position < 22) {
                if (rowflag && ((row & 7) == 0)) ambient = 64.0;
                Fast256PhongPal(ambient, 128.0, 256.0, ambient, 20.0, 100.0,
                                ambient, 20.0, 100.0, pal);
                GlobalStyle = c_texturemapped;
                sphere->Draw(voff);
                sphere->Rotate(t_rottable[r][0], t_rottable[r][1], t_rottable[r++][2]);
                tun->SetCenter(t_tunpos[p][0], t_tunpos[p][1]);
                tun->Rotate(0, 0, -p);
                GlobalStyle = ca_wireframe;
                StartCol = 32;
        	tun->Draw(voff);
                GlobalStyle = c_particles;
                StartCol = 128;
                tun->DrawParticles(voff);
                tun->Rotate(0, 0, p);
                p = (p + 1) % 360;
                tun->Rotate(0, -2, 0);
                Blur(voff);
                if (row < 48)
                        DrawBanner((unsigned int)BANNER5, 202, 110, 61, 40, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                if (ambient > 0.0) ambient -= 16.0;
                Light.Rotate(0, 0, -4);
        }

        ambient = 256.0;
        while (position < 23) {
                if (rowflag && ((row & 7) == 0)) ambient = 64.0;
                Fast256PhongPal(ambient, 20.0, 100.0, ambient, 128.0, 256.0,
                                ambient, 20.0, 100.0, pal);
                GlobalStyle = c_texturemapped;
                sphere->Draw(voff);
                sphere->Rotate(t_rottable[r][0], t_rottable[r][1], t_rottable[r++][2]);
                tun->SetCenter(t_tunpos[p][0], t_tunpos[p][1]);
                tun->Rotate(0, 0, -p);
                GlobalStyle = ca_wireframe;
                StartCol = 32;
        	tun->Draw(voff);
                GlobalStyle = c_particles;
                StartCol = 128;
                WidthCol = 63;
                tun->DrawParticles(voff);
                tun->Rotate(0, 0, p);
                StartCol = 64;
                WidthCol = 31;
                obj->DrawParticles(voff);
                p = (p + 1) % 360;
                tun->Rotate(0, -2, 0);
                obj->Rotate(0, 0, 2);
                Blur(voff);
                if ((row > 8) && (row < 56))
                        DrawBanner((unsigned int)BANNER1, 200, 90, 119, 109, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                if (ambient > 0.0) ambient -= 16.0;
                Light.Rotate(0, 0, -4);
        }

//        ShutDownVirtual(&vscr);
//        delete sphere;
//        delete tun;
//        delete obj;
}
